/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
package squirrels.ecshop.action.task;

import java.util.HashMap;
import java.util.Map;

import squirrels.ecshop.constant.AC;
import squirrels.ecshop.constant.VC;
import squirrels.ecshop.model.dao.UserOrderDAO;
import squirrels.ecshop.model.example.UserOrderExample;

/**
 */
@SuppressWarnings("serial")
public class UserOrderAction extends AbstractTaskAction {

	/**
	 * count
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String count() throws Exception {
		log.debug("Loading User Order Count ...");

		Map<String, Integer> cnts = new HashMap<String, Integer>();
		
		UserOrderDAO coDao = new UserOrderDAO(getDataAccessSession());

		UserOrderExample coExp = coDao.createExample();
		coExp.invalid().isFalse()
			.status().equalTo(VC.ORDER_STATUS_BEGIN);
		cnts.put("begin", coDao.countByExample(coExp));

		coExp = coDao.createExample();
		coExp.invalid().isFalse()
		.status().equalTo(VC.ORDER_STATUS_PREPARE);
		cnts.put("prepare", coDao.countByExample(coExp));

		getApplication().put(AC.USER_ORDER_COUNT, cnts);

		return SUCCESS;
	}
}
