/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
package squirrels.ecshop.action.user;

import squirrels.ecshop.action.user.orderhistory.OrderHistoryAction;
import squirrels.ecshop.constant.VC;
import squirrels.ecshop.model.bean.UserOrder;
import squirrels.ecshop.model.dao.UserOrderItemDAO;
import squirrels.ecshop.model.example.UserOrderExample;
import squirrels.ecshop.model.example.UserOrderItemExample;

/**
 * OrderHistoryExAction
 */
@SuppressWarnings("serial")
public class OrderHistoryExAction extends OrderHistoryAction {

	/**
	 * Constructor
	 */
	public OrderHistoryExAction() {
		super();
	}

	/**
	 * queryListByExample
	 * @param example example
	 * @throws Exception if an error occurs
	 */
	@Override
	protected void queryListByExample(UserOrderExample example) throws Exception {
		example.userId().equalTo(utils().getLoginUser().getId())
			.and().invalid().isFalse()
			.and().status().equalTo(VC.ORDER_STATUS_FINISHED);
		super.queryListByExample(example);
	}
	
	/**
	 * view 
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String view() throws Exception {
		UserOrder d = selectData(getData());
		if (d == null) {
			return ERROR;
		}

		setData(d);
		
		UserOrderItemDAO idao = new UserOrderItemDAO(getDataAccessSession());
		UserOrderItemExample iexp = idao.createExample();
		iexp.userOrderId().equalTo(d.getId())
			.and().invalid().isFalse();
		d.setItems(idao.selectByExample(iexp));
		return SUCCESS;
	}
}
