/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
package squirrels.ecshop.action.user;

import squirrels.ecshop.action.user.ordermanage.OrderManageAction;
import squirrels.ecshop.constant.VC;
import squirrels.ecshop.model.bean.UserOrder;
import squirrels.ecshop.model.dao.UserOrderItemDAO;
import squirrels.ecshop.model.example.UserOrderExample;
import squirrels.ecshop.model.example.UserOrderItemExample;


/**
 * OrderManageExAction
 */
@SuppressWarnings("serial")
public class OrderManageExAction extends OrderManageAction {

	/**
	 * Constructor
	 */
	public OrderManageExAction() {
		super();
	}

	/**
	 * queryListByExample
	 * @param example example
	 * @throws Exception if an error occurs
	 */
	@Override
	protected void queryListByExample(UserOrderExample example) throws Exception {
		example.userId().equalTo(utils().getLoginUser().getId())
			.and().invalid().isFalse()
			.and().status().equalTo(VC.ORDER_STATUS_BEGIN);
		super.queryListByExample(example);
	}
	
	/**
	 * checkOnDelete
	 * @param data data
	 * @param srcData srcData
	 * @return true if check success
	 * @throws Exception if an error occurs
	 */
	@Override
	protected boolean checkOnDelete(UserOrder data, UserOrder srcData) throws Exception {
		selectItems(srcData);
		data.setItems(srcData.getItems());
		if (!VC.ORDER_STATUS_BEGIN.equals(srcData.getStatus())) {
			addActionError(getText("cannot-delete-order"));
			return false;
		}
		return super.checkOnDelete(data, srcData);
	}

	/**
	 * startDelete
	 * @param data data
	 * @throws Exception if an error occurs
	 */
	@Override
	protected void startDelete(UserOrder data) throws Exception {
		super.startDelete(data);

		UserOrderItemDAO idao = new UserOrderItemDAO(getDataAccessSession());
		UserOrderItemExample iexp = new UserOrderItemExample();
		iexp.userOrderId().equalTo(data.getId());
		idao.deleteByExample(iexp);
	}

	private void selectItems(UserOrder data) throws Exception {
		UserOrderItemDAO idao = new UserOrderItemDAO(getDataAccessSession());
		UserOrderItemExample iexp = idao.createExample();
		iexp.userOrderId().equalTo(data.getId())
			.and().invalid().isFalse();
		data.setItems(idao.selectByExample(iexp));
	}

	/**
	 * view 
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	@Override
	public String view() throws Exception {
		doViewSelect();
		if (!hasErrors()) {
			selectItems(getData());
		}
		return SUCCESS;
	}
}
