/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
package squirrels.ecshop.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * Cart
 */
@SuppressWarnings("serial")
public class Cart implements Serializable {

	protected List<CartItem> items;

	/**
	 * Constructor
	 */
	public Cart() {
	}

	/**
	 * @return the items
	 */
	public List<CartItem> getItems() {
		if (items == null) {
			items = new ArrayList<CartItem>();
		}
		return items;
	}

	/**
	 * @return true if cart is empty
	 */
	public boolean isEmpty() {
		return items == null || items.isEmpty();
	}
	
	/**
     * @return  a string representation of the object.
	 */
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();

		sb.append("{ ");
		sb.append("items: ").append(items);
		sb.append(" }");

		return sb.toString();
	}
}