/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
package squirrels.ecshop.bean;

import java.io.Serializable;
import java.util.Date;

/**
 * CookieCart
 */
@SuppressWarnings("serial")
public class CartCookieItem implements Serializable {

	protected String goodsId;
	protected Integer quantity;
	protected Date addDate;

	/**
	 * Constructor
	 */
	public CartCookieItem() {
	}

	/**
	 * Constructor
	 * @param cart Cart
	 */
	public CartCookieItem(CartItem cart) {
		this.goodsId = cart.goodsId;
		this.quantity = cart.quantity;
		this.addDate = cart.addDate;
	}

	/**
	 * @return the goodsId
	 */
	public String getG() {
		return goodsId;
	}

	/**
	 * @param goodsId the goodsId to set
	 */
	public void setG(String goodsId) {
		this.goodsId = goodsId;
	}

	/**
	 * @return the quantity
	 */
	public Integer getQ() {
		return quantity;
	}

	/**
	 * @param quantity the quantity to set
	 */
	public void setQ(Integer quantity) {
		this.quantity = quantity;
	}

	/**
	 * @return the addDate
	 */
	public long getD() {
		return addDate == null ? 0 : addDate.getTime();
	}

	/**
	 * @param addDate the addDate to set
	 */
	public void setD(long addDate) {
		if (addDate > 0) {
			this.addDate = new Date(addDate);
		}
	}

	/**
     * @return  a string representation of the object.
	 */
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();

		sb.append("{ ");
		sb.append("goodsId: ").append(goodsId);
		sb.append(", ");
		sb.append("quantity: ").append(quantity);
		sb.append(", ");
		sb.append("addDate: ").append(addDate);
		sb.append(" }");

		return sb.toString();
	}
}