/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
package squirrels.ecshop.bean;

import java.io.Serializable;
import java.util.Date;

import squirrels.ecshop.model.bean.Goods;



/**
 * Cart
 */
@SuppressWarnings("serial")
public class CartItem implements Serializable {

	protected String goodsId;
	protected Integer quantity;
	protected Date addDate;
	
	protected Goods goods;

	/**
	 * Constructor
	 */
	public CartItem() {
	}

	/**
	 * Constructor
	 * @param cart CookieCart
	 */
	public CartItem(CartCookieItem cart) {
		this.goodsId = cart.goodsId;
		this.quantity = cart.quantity;
		this.addDate = cart.addDate;
	}

	/**
	 * @return the goodsId
	 */
	public String getGoodsId() {
		return goodsId;
	}

	/**
	 * @param goodsId the goodsId to set
	 */
	public void setGoodsId(String goodsId) {
		this.goodsId = goodsId;
	}

	/**
	 * @return the quantity
	 */
	public Integer getQuantity() {
		return quantity;
	}

	/**
	 * @param quantity the quantity to set
	 */
	public void setQuantity(Integer quantity) {
		this.quantity = quantity;
	}

	/**
	 * @return the addDate
	 */
	public Date getAddDate() {
		return addDate;
	}

	/**
	 * @param addDate the addDate to set
	 */
	public void setAddDate(Date addDate) {
		this.addDate = addDate;
	}

	/**
	 * @return the goods
	 */
	public Goods getGoods() {
		return goods;
	}

	/**
	 * @param goods the goods to set
	 */
	public void setGoods(Goods goods) {
		this.goods = goods;
	}

	/**
     * @return  a string representation of the object.
	 */
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();

		sb.append("{ ");
		sb.append("goodsId: ").append(goodsId);
		sb.append(", ");
		sb.append("quantity: ").append(quantity);
		sb.append(", ");
		sb.append("addDate: ").append(addDate);
		sb.append(", ");
		sb.append("goods: ").append(goods);
		sb.append(" }");
		
		return sb.toString();
	}
}