/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
package squirrels.ecshop.bean;

import java.io.Serializable;


/**
 * ImageInfo
 */
@SuppressWarnings("serial")
public class ImageInfo implements Comparable<ImageInfo>, Serializable {

	/**
	 * DELETE = "D";
	 */
	public static final String DELETE = "D";
	
	/**
	 * INSERT = "I";
	 */
	public static final String INSERT = "I";
	
	/**
	 * String UPDATE = "U";
	 */
	public static final String UPDATE = "U";
	
	private String action;
	private String name;
	private String temp;
	private long time;
	private boolean display = false;

	/**
	 * @return the action
	 */
	public String getAction() {
		return action;
	}

	/**
	 * @param action the action to set
	 */
	public void setAction(String action) {
		this.action = action;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the temp
	 */
	public String getTemp() {
		return temp;
	}

	/**
	 * @param temp the temp to set
	 */
	public void setTemp(String temp) {
		this.temp = temp;
	}

	/**
	 * @return the time
	 */
	public long getTime() {
		return time;
	}

	/**
	 * @param time the time to set
	 */
	public void setTime(long time) {
		this.time = time;
	}

	/**
	 * @return the display
	 */
	public boolean isDisplay() {
		return display;
	}

	/**
	 * @param display the display to set
	 */
	public void setDisplay(boolean display) {
		this.display = display;
	}

	/**
     * @return  a string representation of the object.
	 */
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();

		sb.append("{ ");
		sb.append("action: ").append(action);
		sb.append(", ");
		sb.append("name: ").append(name);
		sb.append(", ");
		sb.append("temp: ").append(temp);
		sb.append(", ");
		sb.append("time: ").append(time);
		sb.append(", ");
		sb.append("display: ").append(display);
		sb.append(" }");

		return sb.toString();
	}

	@Override
	public int compareTo(ImageInfo o) {
		if (o == null) {
			return 1;
		}
		return (int)(o.time - this.time);
	}
}