/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
package squirrels.ecshop.bean;

import java.io.Serializable;

/**
 * RankCount
 */
@SuppressWarnings("serial")
public class RankCount implements Serializable {

	//-------------------------------------------------------------------------
	// properties
	//-------------------------------------------------------------------------
	private int rank;
	private int count;
	private int rate;

	/**
	 * Constructor
	 */
	public RankCount() {
		this.rank = 0;
		this.count = 0;
		this.rate = 0;
	}

	/**
	 * @return the rank
	 */
	public int getRank() {
		return rank;
	}

	/**
	 * @param rank the rank to set
	 */
	public void setRank(int rank) {
		this.rank = rank;
	}

	/**
	 * @return the count
	 */
	public int getCont() {
		return count;
	}

	/**
	 * @param count the count to set
	 */
	public void setCont(int count) {
		this.count = count;
	}

	/**
	 * @return the count
	 */
	public int getCount() {
		return count;
	}

	/**
	 * @param count the count to set
	 */
	public void setCount(int count) {
		this.count = count;
	}

	/**
	 * @return the rate
	 */
	public int getRate() {
		return rate;
	}

	/**
	 * @param rate the rate to set
	 */
	public void setRate(int rate) {
		this.rate = rate;
	}

	/**
     * @return  a string representation of the object.
	 */
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();

		sb.append("{ ");
		sb.append("rank: ").append(rank);
		sb.append(", ");
		sb.append("count: ").append(count);
		sb.append(", ");
		sb.append("rate: ").append(rate);
		sb.append(" }");

		return sb.toString();
	}
}