<#--
/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<#assign _an_ = utils.actionName!/>
<#assign _ai_ = 0/>
<#assign _ac_ = 0/>
<#macro menu ap ac tx>
	<#if action.hasPermission("/admin", ac)>
				<li<#if _an_?starts_with(ap)><#assign _ac_ = _ai_/> class="active"</#if>><#rt/>
<@n.a action=ac namespace="/admin"><@n.text name=tx/></@n.a></li>
	</#if>
</#macro>

<div id="menu_admin" class="n-sect">
	<h3><@n.a href="#" icon="n-icon-vcard"><@n.text name="menu-admin-account"/></@n.a></h3>
	<div id="menu_admin_account">
		<ul class="menu">
			<@menu ap="user_" ac="user_list" tx="menu-admin-account-user"/>
			<@menu ap="usergroup_" ac="usergroup_list" tx="menu-admin-account-usergroup"/>
			<@menu ap="userstate_" ac="userstate_list" tx="menu-admin-account-userstate"/>
			<@menu ap="useraddress_" ac="useraddress_list" tx="menu-admin-account-useraddress"/>
			<@menu ap="usercreditcard_" ac="usercreditcard_list" tx="menu-admin-account-usercreditcard"/>
			<@menu ap="userwanted_" ac="userwanted_list" tx="menu-admin-account-userwanted"/>
		</ul>
	</div>

	<#assign _ai_ = _ai_ + 1/>
	<h3><@n.a href="#" icon="n-icon-database_gear"><@n.text name="menu-admin-stock"/></@n.a></h3>
	<div id="menu_admin_stock">
		<ul class="menu">
			<@menu ap="category_" ac="category_list" tx="menu-admin-stock-category"/>
			<@menu ap="maker_" ac="maker_list" tx="menu-admin-stock-maker"/>
			<@menu ap="platform_" ac="platform_list" tx="menu-admin-stock-platform"/>
			<@menu ap="goods_" ac="goods_list" tx="menu-admin-stock-goods"/>
			<@menu ap="goodscomment_" ac="goodscomment_list" tx="menu-admin-stock-goodscomment"/>
			<@menu ap="goodsreview_" ac="goodsreview_list" tx="menu-admin-stock-goodsreview"/>
		</ul>
	</div>

	<#assign _ai_ = _ai_ + 1/>
	<h3><@n.a href="#" icon="n-icon-flag_blue"><@n.text name="menu-admin-sale"/></@n.a></h3>
	<div id="menu_admin_sale">
		<ul class="menu">
			<@menu ap="supplier_" ac="supplier_list" tx="menu-admin-sale-supplier"/>
			<@menu ap="supplement_" ac="supplement_list" tx="menu-admin-sale-supplement"/>
			<@menu ap="userorder_" ac="userorder_list" tx="menu-admin-sale-userorder"/>
			<@menu ap="userorderitem_" ac="userorderitem_list" tx="menu-admin-sale-userorderitem"/>
			<@menu ap="report" ac="report_input" tx="menu-admin-sale-report"/>
		</ul>
	</div>

	<#if action.hasPermission("/admin", "goodsindex_input")>
	<#assign _ai_ = _ai_ + 1/>
	<h3><@n.a href="#" icon="n-icon-wrench"><@n.text name="menu-admin-system"/></@n.a></h3>
	<div id="menu_admin_system">
		<ul class="menu">
			<@menu ap="goodsindex_" ac="goodsindex_input" tx="menu-admin-system-goodsindex"/>
			<@menu ap="memcache_" ac="memcache_index" tx="menu-admin-system-memcache"/>
		<#if utils.databaseResourceLoader>
			<@menu ap="resource_" ac="resource_list" tx="menu-admin-system-resource"/>
		</#if>
			<@menu ap="template_" ac="template_list" tx="menu-admin-system-template"/>
			<@menu ap="cronjobs" ac="cronjobs" tx="menu-admin-system-cronjobs"/>
			<@menu ap="dataimp" ac="dataimp" tx="menu-admin-system-dataimp"/>
			<@menu ap="ognleval" ac="ognleval" tx="menu-admin-system-ognleval"/>
		<#if utils.gaeSupport>
			<@menu ap="ndfsfile_" ac="ndfsfile_list" tx="menu-admin-system-ndfsfile"/>
		<#else>
			<@menu ap="pdf" ac="html2pdf" tx="menu-admin-system-html2pdf"/>
			<@menu ap="sqlexec" ac="sqlexec" tx="menu-admin-system-sqlexec"/>
		</#if>
		</ul>
	</div>
	</#if>
</div>
<script type="text/javascript">
	$(function() {
		$("#menu_admin").accordion({
			active: ${_ac_},
			autoHeight: false,
			event: "click mouseover"
		});
	});
</script>
