<#--
/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<#assign _an_ = utils.actionName!/>
<#macro menu ap ac tx>
				<li<#if _an_?starts_with(ap)> class="active"</#if>><#rt/>
<@n.a action=ac><@n.text name=tx/></@n.a></li>
</#macro>
<#macro ctree cl>
	<ul class="menu">
	<#list cl as c>
	<#if cid?? && utils.isSuperCategory(c.id?string, cid?string)>
		<li class="<#if cid == c.id?string && !(c.childs?has_content)>active<#else>expanda</#if>">
			<a href="<@n.url action='goods_list' namespace='/'><@s.param name='cid'>${c.id}</@s.param></@n.url>">${c.name?html}</a>
		<#if c.childs?has_content>
			<@ctree cl=c.childs/>
		</#if>
		</li>
	<#else>
		<li><@n.a action="goods_list" namespace="/"><@s.param name="cid">${c.id}</@s.param>${c.name?html}</@n.a></li>
	</#if>
	</#list>
	</ul>
</#macro>
<div id="menu_side" class="n-sect">
	<#if Session?? && Session.user?? && utils.namespace?starts_with("/user")>
	<div class="n-sect-head">
		<em class="n-sect-icon n-icon n-icon-wrench_orange"></em>
		<h3 class="n-sect-title"><@n.text name="menu-user"/></h3>
	</div>
	<div class="n-sect-body">
		<ul class="menu">
			<@menu ap="account_" ac="account_input" tx="menu-user-account"/>
			<@menu ap="passwordchange_" ac="passwordchange_input" tx="menu-user-passwordchange"/>
			<@menu ap="profile_" ac="profile_input" tx="menu-user-profile"/>
			<@menu ap="address_" ac="address_list" tx="menu-user-address"/>
			<@menu ap="creditcard_" ac="creditcard_list" tx="menu-user-creditcard"/>
			<@menu ap="wanted_" ac="wanted_list" tx="menu-user-wanted"/>
			<@menu ap="ordermanage_" ac="ordermanage_list" tx="menu-user-order-manage"/>
			<@menu ap="orderconfirm_" ac="orderconfirm_list" tx="menu-user-order-confirm"/>
			<@menu ap="orderhistory_" ac="orderhistory_list" tx="menu-user-order-history"/>
			<@menu ap="goodsreview_" ac="goodsreview_list" tx="menu-user-goods-review"/>
			<@menu ap="goodscomment_" ac="goodscomment_list" tx="menu-user-goods-comment"/>
		</ul>
	</div>
	</#if>

	<div class="n-sect-head">
		<em class="n-sect-icon n-icon n-icon-book_open"></em>
		<h3 class="n-sect-title"><@n.text name="menu-category"/></h3>
	</div>
	<div class="n-sect-body">
		<@ctree cl=Application.categoryTopList![]/>
	</div>
</div>
