<#--
/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<tr>
	<td class="n-td-label"><@n.text name="images"/>:</td>
	<td class="n-td-input" colspan="2">
	<#if inputResult>
		<table id="goodsimg_file_box"><tr>
			<td><input type="checkbox" class="checkbox" id="goodsimg_resize"/></td>
			<td><label for="goodsimg_resize"><@n.text name="label-resize"/></label></td>
			<td class="sep"></td> 
			<td><input type="file" id="goodsimg_file"/></td>
			<td id="goodsimg_file_info"></td>
		</tr></table>
		<table id="goodsimg_uploading" style="display: none"><tr>
			<td><@n.text name="message-file-uploading"/></td>
			<td><img src="${static}/nuts/images/loader/snake.gif"/></td>
			<td><div class="progressbar" style="width:150px; height:12px;"></div></td>
		</tr></table>
		<div id="goodsimg_prompt"></div>
	</#if>
		<div class="goodsimg-list">
		<#if imageList?has_content>
			<#list imageList as i>
				<div class="goodsimg-item<#if i.display> ui-state-highlight</#if>">
				<#if i.name?has_content>
					<input type="hidden" class="goodsimg-name" name="images[${i_index?c}].name" value="${i.name?html}"/>
					<@n.url var="_url_" action='gi' namespace='/images'><@s.param name="gid">${d.id?c}</@s.param><@s.param name="gin">${i.name}</@s.param></@n.url>
					<a href="${_url_}" title="${i.name?html}"><img src="${_url_}"/></a>
				<#elseif i.temp?has_content>
					<input type="hidden" class="goodsimg-name" name="images[${i_index?c}].temp" value="${i.temp?html}"/>
					<@n.url var="_url_" action='id' namespace='/images'><@s.param name="fn">${i.temp}</@s.param></@n.url>
					<a href="${_url_}" title="${i.temp?html}"><img src="${_url_}"/></a>
				</#if>
					<table class="goodsimg-tb"><tr>
					<#if inputResult || confirmMethodResult>
					<#if i.name?has_content>
						<td><input type="checkbox" class="goodsimg-delete" id="goodsimgs_${i_index?c}a" name="images[${i_index?c}].action" value="D"<#if 'D' == i.action!> checked="checked"</#if>/>
							<label for="goodsimgs_${i_index?c}a"><@n.text name="button-delete"/></label>
						</td>
					<#elseif i.temp?has_content>
						<td><input type="checkbox" class="goodsimg-insert" id="goodsimgs_${i_index?c}a" name="images[${i_index?c}].action" value="I"<#if 'I' == i.action!> checked="checked"</#if>/>
							<label for="goodsimgs_${i_index?c}a"><@n.text name="button-insert"/></label>
						</td>
					</#if>
						<td align="right"><input type="checkbox" class="goodsimg-thumb" id="goodsimgs_${i_index?c}d" name="images[${i_index?c}].display" value="true"<#if i.display> checked="checked"</#if>/>
							<label for="goodsimgs_${i_index?c}d"><@n.text name="button-thumb"/></label>
						</td>
					</#if>
					</tr></table>
				</div>
			</#list>
		</#if>
		</div>
	
		<script type="text/javascript"><!--
			$(function() {
				var items = <#if images??>${images.size()?c}<#else>0</#if>;
				var progress = 0;
				var timer = null;
				var ogconf = { 
				    target: '#goodsimg-gallery', 
				    expose: '#f1f1f1' 
				};
				
				function clearTimer() {
					if (timer) {
						clearInterval(timer);
						timer = null;
					}
				}

				function checkDelete() {
					var $gt = $(this).closest('.goodsimg-item').find('.goodsimg-thumb');
					if (this.checked) {
						$gt.attr({
							'checked': false,
							'disabled': true
						})
						.triggerHandler('change');
					}
					else {
						$gt.attr({
							'disabled': false
						});
					}
				}
				
				function checkInsert() {
					var $gt = $(this).closest('.goodsimg-item').find('.goodsimg-thumb');
					if (this.checked) {
						$gt.attr({
							'disabled': false
						});
					}
					else {
						$gt.attr({
							'checked': false,
							'disabled': true
						})
						.triggerHandler('change');
					}
				}
				
				function checkThumb() {
					var c = this;
					var $i = $(c).closest('.goodsimg-item');
					var v = $i.find('.goodsimg-name').val();
					var $t = $('#goods_d_thumbs');
					var ss = $t.val().split(/\r|\n/g);
					var i = ss.indexOf(v);
					if (c.checked) {
						$i.addClass('ui-state-highlight');
						if (i < 0) {
							$t.val([ v ].concat(ss).join('\n'));
						}
					}
					else {
						$i.removeClass('ui-state-highlight');
						if (i >= 0) {
							ss.splice(i, 1);
							$t.val(ss.join('\n'));
						}
					}
				}
				
				function uploadImage() {
					progress = 0;
					$('#goodsimg_uploading .progressbar').progressbar('value', progress);

					$('#goodsimg_file_box').hide();
					$('#goodsimg_file_info').html('');
					$('#goodsimg_uploading').show();
					
					$('#goodsimg_prompt').html('');

					timer = setInterval(function() {
						progress += 1;

						$('#goodsimg_uploading .progressbar').progressbar('value', progress);
						
						if (progress >= 90) {
							clearTimer();
						}
					}, 20);

					var data = null;
					if ($('#goodsimg_resize').attr('checked')) {
						data = { 
							scale: ${consts.imageScaleMap['L']}
						};
					}

					$.ajaf({
						url: '<@n.url action="iu" namespace="/images"/>',
						file: {
							'image': '#goodsimg_file'
						},
						data: data,
						dataType: 'json',
						success: function(d) {
							progress = 100;
							$('#goodsimg_uploading')
								.children('.progressbar').progressbar('value', progress).end()
								.hide();
							$('#goodsimg_file_box').show();
							$('#goodsimg_file').val('');
							if (d.success) {
								$('#goodsimg_file_info')
									.css('color', 'navy')
									.html('<em class="ui-icon ui-icon-check n-fleft"></em><span></span>')
									.children('span').text(d.image.fileName);
								
								var u = '<@n.url action='id' namespace='/images'/>?fn=' + encodeURIComponent(d.image.saveName);
								var n = d.image.saveName.escapeHtml();
								var s = $('.goodsimg-list');
								var a = $('<div class="goodsimg-item">'
									+ '<input type="hidden" class="goodsimg-name" name="images[' + items + '].temp" value="' + n + '"/>'
									+ '<a href="' + u + '" title="' + n + '"><img src="' + u + '"></a>'
									+ '<table class="goodsimg-tb"><tr>'
									+ '<td>'
										+ '<input type="checkbox" class="goodsimg-insert" id="goodsimgs_' + items + 'a" name="images[' + items + '].action" value="I" checked="checked"/>'
										+ '<label for="goodsimgs_' + items + 'a"><@n.text name="button-add"/></label>'
									+ '</td>'
									+ '<td align="right">'
										+ '<input type="checkbox" class="goodsimg-thumb" id="goodsimgs_' + items + 'd" checked="checked"/>'
										+ '<label for="goodsimgs_' + items + 'd"><@n.text name="button-thumb"/></label>'
									+ '</td>'
									+ '</tr></table>'
									+ '</div>');

								items++;

								s.prepend(a);

								a.find('.goodsimg-thumb').change(checkThumb).change();
								a.find('.goodsimg-insert').change(checkInsert);

								$('.goodsimg-list a').lightBox();
							}
							else {
								$('#goodsimg_file_info')
									.css('color', 'red')
									.html('<em class="ui-icon ui-icon-close n-fleft"></em><span></span>')
									.children('span').text(d.image.fileName);
								nuts.prompt({ container: '#goodsimg_prompt' }).add(d);
							}
						},
						error: function(xhr, status, e) {
							$('#goodsimg_uploading').hide();
							$('#goodsimg_file_box').show();
							$('#goodsimg_file').val('');
							nuts.prompt({ container: '#goodsimg_prompt' }).add( 
								'<@n.text name="error-file-upload"/><br/>'	+ (e ? e.message : (xhr ? xhr.responseText : status)),
								'error'
							);
						}
					});
				}
				
				$('.goodsimg-list a').lightBox();

				$('#goodsimg_uploading .progressbar').progressbar();

				$('#goodsimg_file').change(function() { setTimeout(uploadImage, 10); });
				
				$('.goodsimg-list')
					.find('.goodsimg-thumb').change(checkThumb).end()
					.find('.goodsimg-insert').change(checkInsert).end()
					.find('.goodsimg-delete').change(checkDelete).end();
			});
		--></script>
	</td>
</tr>
