<#--
/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<html>
<head>
	<title><@n.text name="title-${actionResult}"><@s.param><@n.text name="title"/></@s.param></@n.text></title>
</head>

<body>

<div class="n-sect" id="a_goods_reindex">
	<div class="n-sect-head">
		<h3 class="n-sect-title"><@n.text name="title-${actionResult}"><@s.param><@n.text name="title"/></@s.param></@n.text></h3>
	</div>
	<div class="n-sect-body">
		<div id="goodsinx_b">
			<#include "/nuts/exts/struts2/views/action-prompt.ftl"/>
			<br/>
			<div class="n-tcenter">
				<@n.submit icon="n-icon-arrow_switch" onclick="doReindex()"><@n.text name="button-reindex"/></@n.submit>
				<@n.submit icon="n-icon_bullet_back" onclick="doBack()"><@n.text name="button-back"/></@n.submit>
			</div>
			<br/>
		</div>
		
		<br/>
		<div id="goodsinx_i">
		</div>
		<br/>
		<br/>

		<script type="text/javascript">
			function doBack() {
				history.back();
			}

			var $hr;
			
			function doReindex() {
				$('#goodsinx_b').loadmask('<@n.text name="button-reindex"/>...');
				
				$hr = $('<div class="hr"></div>').appendTo($('#goodsinx_i').empty());

				var data = {
					__decorator: 'none',
					error: 'parent.goods_reindex_error("{0}");',
					process: 'parent.goods_reindex_process({0}, "{1}");',
					success: 'parent.goods_reindex_success("{0}");'
				};
				
				$.ajaf({
					url: "<@n.url action='goodswork_indexes'/>",
					data: data,
					success: function(d) {
					},
					error: function(xhr, status, e) {
						$('#goodsinx_b').unloadmask();
						$hr.after('<div class="error">' + String.escapeHtml(xhr.responseText) + '</div>');
					}
				});
			}
			
			function goods_reindex_error(msg) {
				$hr.after('<div class="error">' + String.escapeHtml(msg) + '</div>');
				$('#goodsinx_b').unloadmask();
			}
			
			function goods_reindex_success(msg) {
				msg = '<@n.text name="success-reindex"/>'.replace('{0}', msg);
				$hr.after('<div>' + String.escapeHtml(msg) + '</div>');
				$('#goodsinx_b').unloadmask();
			}
			
			function goods_reindex_process(progress, msg) {
				var msg = progress + '. ' + msg;
				$hr.after('<div>' + (msg) + '</div>');
			}
		</script>
	</div>
</div>

</body>
</html>
