<#--
/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<html>
<head>
	<title><@n.text name="title"/></title>
	<style type="text/css">
		table.mc-table {
			width: 100%;
		}
		table.mc-table th, table.mc-table td {
			padding: 5px;
			vertical-align: top;
		}
		td.mc-td-no {
			width: 30px;
		}
		td.mc-td-name, td.mc-td-key, td.mc-td-time {
			width: 150px;
		}
	</style>
</head>

<body>

<div class="n-sect" id="a_cache">
	<div class="n-sect-head">
		<h3 class="n-sect-title"><@n.text name="title"/></h3>
	</div>
	<div class="n-sect-body">
		<#include "/nuts/exts/struts2/views/action-prompt.ftl"/>

		<table class="n-table mc-table">
		<thead>
			<tr>
				<th>No.</th>
				<th>Name</th>
				<th>Key</th>
				<th>Load Time</th>
				<th>Reload</th>
			</tr>
		</thead>
		<tbody>
		<#assign cl = [
				'category',
				'resource',
				'template'
			] />
		<#list cl as c>
			<tr class="ui-tr-<#if c_index % 2 == 0>odd<#else>even</#if>">
				<td class="mc-td-no">${c_index + 1}.</td>
				<td class="mc-td-name"><@n.text name=c/></td>
				<td class="mc-td-key">${c}</td>
				<td class="mc-td-time"><@n.property value=(Application[c + '.reload']!)/></td>
				<td class="mc-td-reload"><@n.a icon="icon-reload" action="${c}_load" namespace="/task" onclick="return mc_reload(this);"><@n.text name="button-reload"/></@n.a></td>
			</tr>
			<tr class="n-hidden ui-tr-<#if c_index % 2 == 0>odd<#else>even</#if>">
				<td>&nbsp;</td>
				<td colspan="4" class="mc-td-result"></td>
			</tr>
		</#list>
		</tbody>
		</table>
	</div>
	<script type="text/javascript">
		function mc_reload(el) {
			var $a = $(el);
			var $d = $a.closest('tr');
			var $r = $d.next().show().children('.mc-td-result');

			try {
				$a.parent().loadmask();
				$r.html((new Date()).format('yyyy-MM-dd HH:mm:ss'));

				$.ajax({
					url: $a.attr('href'),
					dataType: 'text',
					success: function(data, ts, xhr) {
						$d.unloadmask();
						$r.html($r.html() 
							+ '<pre>' + data.formatXml().escapeHtml() + '</pre>');
					},
					error: function(xhr, ts, ex) {
						$d.unloadmask();
						$r.html($r.html()
							+ '<pre>'
							+ ((ex ? (ex + '\r\n') : '') + xhr.responseText).formatXml().escapeHtml()
							+ '</pre>');
					}
				});
			}
			catch (ex) {
				$r.html((new Date()).format('yyyy-MM-dd HH:mm:ss') 
					+ '<pre>' + ('ERROR:\r\n' + ex).escapeHtml() + '</pre>');
			}
			return false;
		}
	</script>
</div>

</body>
</html>
