<#--
/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<html>
<head>
	<title><@n.text name="title-page"/></title>
</head>

<body>

<#if !cart.empty>
	<table class="n-sect cart-table" id="a_cart_edit">
	<thead>
		<tr>
			<th class="n-sect-head n-nowrap" colspan="3">
				<h3 class="n-sect-title"><@n.text name="title-page"/>--<@n.text name="label-order"/></h3>
			</th>
			<th class="hline n-nowrap sale-price"><@n.text name="label-sale-price"/></th>
			<th class="hline n-nowrap goods-quantity"><@n.text name="label-quantity"/></th>
			<th class="hline n-nowrap actions">&nbsp;</th>
		</tr>
	</thead>
	<tbody class="n-sect-body">
		<tr>
			<td colspan="6">
				<#include "/nuts/exts/struts2/views/action-prompt.ftl"/>
				<br/>
			</td>
		</tr>
	<#assign _sp_=0 />
	<#list cart.items as ci>
		<#assign _sp_ = _sp_ + ci.goods.salePrice * ci.quantity />

		<@n.url var="_vurl_" action="goods_view">
			<@s.param name="gid">${ci.goodsId}</@s.param>
		</@n.url>
		<tr>
			<td class="item-no">${ci_index + 1}.</td>
			<td class="goods-icon">
				<a href="${_vurl_}"><img src="<@n.url action="gi" namespace="/images">
					<@s.param name="gid">${ci.goodsId}</@s.param></@n.url>"/></a>
			</td>
			<td class="goods-name"><a href="${_vurl_}">${ci.goods.name?html}</a></td>
			<td class="sale-price"><@n.text name="format-price"><@s.param value="${ci.goods.salePrice?c}"/></@n.text></td>
			<td class="goods-quantity">
				<input type="text" class="edit" size="2" maxlength="2" value="${ci.quantity?c}"/>
			</td>
			<td class="actions">
				<ul class="list">
					<li><@n.submit icon="n-icon-basket_edit" onclick="return changeItem(this, '${ci.goods.id}');" title="<@n.text name='tooltip-change'/>"><@n.text name="button-change"/></@n.submit></li>
					<li><@n.submit icon="n-icon-basket_delete" onclick="return deleteItem(this, '${ci.goods.id}');" title="<@n.text name='tooltip-delete'/>"><@n.text name="button-delete"/></@n.submit></li>
				</ul>
			</td>
		</tr>
		<#if ci_has_next><tr><td colspan="6"><div class="hr"></div></td></tr></#if>
	</#list>
	</tbody>
	<tfoot>
		<tr><td colspan="6"><div class="shr"></div></td></tr>
		<tr>
			<td colspan="4" align="right">
				<span class="sum-price">
					<@n.text name="label-sum-price"/>&nbsp;
					<@n.text name="format-price"><@s.param value="${_sp_?c}"/></@n.text>
				</span>
			</td>
			<td colspan="2" align="center"><@n.submit icon="n-icon-basket_go" onclick="return gotoOrder();"><@n.text name="link-order"/></@n.submit></td>
		</tr>
	</tfoot>
	</table>
	<br/>
	<br/>

	<script type="text/javascript">
		function changeItem(e, id) {
			var url = "<@n.url action='cart_change'/>";
			var v = $(e).closest('tr').find('td.goods-quantity input').val();
			var n = parseInt(v);

			if (isNaN(n) || n < 1 || n > 99) {
				alert("<@n.text name='error-goods-quantity'/>");
				return false;
			}
			location.href = url + "?ci.goodsId=" + id + "&ci.quantity=" + n;
			return false;
		}
		function deleteItem(e, id) {
			var url = "<@n.url action='cart_delete'/>";
			location.href = url + "?ci.goodsId=" + id;
			return false;
		}
		function gotoOrder() {
			location.href = "<@n.url action='order_input' namespace='/user'/>";
			return false;
		}
	</script>
<#else>
<div class="n-sect" id="a_cart_edit">
	<div class="n-sect-head">
		<h3 class="n-sect-title"><@n.text name="title-page"/></h3>
	</div>
	<div class="n-sect-body">
		<#include "/nuts/exts/struts2/views/action-prompt.ftl"/>
	</div>
	<br/>
	<br/>
</div>
</#if>

</body>
</html>
