<#--
/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<html>
<head>
	<title><@n.text name="title-page"/></title>
</head>

<body>
<#if commentList?has_content>
	<@n.form id="goodscomment" method="get" theme="simple">
		<@n.hidden name="gid"/>
		<@n.hidden name="pg.s"/>
		<@n.hidden name="pg.l"/>
		<@n.hidden name="so.c"/>
		<@n.hidden name="so.d"/>
	</@n.form>

	<#macro gcnav>
	<table width="100%" border="0">
	<tr>
		<td valign="middle">
			<@n.pager start="pg.s" limit="pg.l" total="pg.t" onLinkClick="sl_goto('goodscomment', #)" onLimitChange="sl_limit('goodscomment', this)"/>
		</td>
		<td>&nbsp;</td>
		<td align="right">
		<#if "voteOk" == sorter.column!>
			<span class="sort-on"><@n.text name="sort-vote"/></span>
		<#else>
			<a href="#" onclick="sl_sortn('goodscomment', 'voteOk', 'DESC'); return false;"><@n.text name="sort-vote"/></a>
		</#if>
			 | 
		<#if "ptime" == sorter.column!>
			<span class="sort-on"><@n.text name="sort-date"/></span>
		<#else>
			<a href="#" onclick="sl_sortn('goodscomment', 'ptime', 'DESC'); return false;"><@n.text name="sort-date"/></a>
		</#if>
		</td>
	</tr>
	</table>
	</#macro>

	<div class="hr"></div><@gcnav/>

	<#list commentList as v>
	<div class="hr"></div>
	<div class="comment-item">
		<#if ((v.voteOk!0) + (v.voteNo!0)) gt 0>
		<div class="comment-voted"><@n.text name="label-vote"><@s.param>${(v.voteOk!0) + (v.voteNo!0)}</@s.param><@s.param>${v.voteOk!0}</@s.param><@s.param>${(v.voteOk!0) + (v.voteNo!0)}</@s.param></@n.text></div>
		</#if>
		
		<span class="comment-title">${v.title?html}</span>
		 | 
		<@n.text name="label-by"/>  
		<span class="comment-title"><#if v.userId??>${action.getCommentUser(v.userId).name?html}<#else><@n.text name="anonymous"/></#if></span>,  
		<span class="comment-date"><@n.date value=v.ptime format="datetime"/></span>
		
		<pre class="comment-comment">${v.comment?html}</pre>
	
		<div class="comment-coop"><@n.text name="label-cooperate"/></div>
		<table class="vote-tbl">
		<tr>
			<td><@n.text name="label-voteOk"/></td>
			<td><@n.submit icon="n-icon-thumb_up" onclick="return gc_vote(this, '${v.id}', true);"><@n.text name="button-voteOk"/></@n.submit>
				<@n.submit icon="n-icon-thumb_down" onclick="return gc_vote(this, '${v.id}', false);"><@n.text name="button-voteNo"/></@n.submit>
			</td>
			<td>&nbsp;<img class="vote-ind" src="${static}/nuts/images/loader/snake.gif"/></td>
		</tr>
		</table>
		<div class="vote-msg"></div>
		<br/>
	</div>
	</#list>
	
	<#if commentList?size gt 7><div class="hr"></div><@gcnav/></#if>

	<script type="text/javascript">
		function gc_vote(el, id, ok) {
			$(el).closest('table')
				.find('.vote-ind').show().end()
				.next('.vote-msg').html('').load(
					'<@n.url action="goodscomment_vote"/>', 
					{
						__decorator: 'none',
						cid: id,
						v: ok
					}, 
					function(rt, ts, xhr) {
						$(this).closest('table').find('.vote-ind').hide();
					});
			return false;
		}
	</script>
<#else>
	<@n.text name="pager-text-nodata"/>
</#if>
</body>
</html>
