<#--
/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<html>
<head>
	<title><@n.text name="title-page"/></title>
</head>

<body>
	<@n.a id="goodsreviewica" icon="n-icon-comment" sicon="ui-icon-carat-1-s" href="#" onclick="gri_toggle(this); return false;"><@n.text name="label-yours"/></@n.a>
	<div id="goodsreviewic">
		<@n.form id="goodsreviewi" action="goodsreview_post" method="post" theme="nxhtml">
			<@n.hidden
				name="d.goodsId"
			/>
			<@n.radio
				key="d.rank"
				list="consts.reviewRankMap"
			/>
			<@n.textfield
				key="d.title"
				maxlength="40"
				size="80"
			/>
			<@n.textarea
				key="d.review"
				maxlength="1000"
				cols="80"
				rows="8"
			/>
			<@n.submit icon="n-icon-comment_edit"><@n.text name="button-post"/></@n.submit>
		</@n.form>
	</div>

	<script type="text/javascript">
		function gri_focus() {
			var gric = $('#goodsreviewic');
			if (gric.is(':hidden')) {
				gri_toggle("#goodsreviewica");
			}
		}
		function gri_toggle(e) {
			var gric = $('#goodsreviewic');
			if (gric.is(':hidden')) {
				$(e).children('.a-i:last')
					.removeClass('ui-icon-carat-1-s')
					.addClass('ui-icon-carat-1-n');
				gric.slideDown();
			}
			else {
				$(e).children('.a-i:last')
					.removeClass('ui-icon-carat-1-n')
					.addClass('ui-icon-carat-1-s');
				gric.slideUp();
			}
		}
		
		<#if posted>
		$(function() {
			goodsReviewListLoad();
		});
		</#if>
	</script>
</body>
</html>
