<#--
/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<html>
<head>
	<title><@n.text name="title-page"/></title>
</head>

<body>
<#if reviewList?has_content>
	<table>
	<tr>
		<td><#if rankList?has_content>
			<table class="review-rank-sum">
			<#list rankList as rc>
			<tr>
				<td class="rrs-rank"><@n.text name="label-rank"><@s.param>${rc.rank}</@s.param></@n.text></td>
				<td class="rrs-rate"><div class="percent"><div style="width: ${rc.rate}%"></div></div></td>
				<td class="rrs-cont">(${rc.count})</td>
			</tr>
			</#list>
			</table></#if>
		</td>
		<td width="20px"></td>
		<td>
			<@n.text name="label-count"><@s.param>${pager.total}</@s.param></@n.text>
			<br/><br/>
			<@n.text name="label-average"/>&nbsp;
			<span class="review-rank">${consts.reviewRankMap[average?c]!}</span>
			<br/><br/>
			<@n.a icon="n-icon-comment_edit" href="#goodsreviewica" onclick="gri_focus()"><@n.text name="button-mine"/></@n.a>
		</td>
	</tr>
	</table>
	<br/>
			
	<@n.form id="goodsreview" method="get" theme="simple">
		<@n.hidden name="gid"/>
		<@n.hidden name="pg.s"/>
		<@n.hidden name="pg.l"/>
		<@n.hidden name="so.c"/>
		<@n.hidden name="so.d"/>
	</@n.form>

	<#macro grnav>
	<table width="100%" border="0">
	<tr>
		<td valign="middle">
			<@n.pager start="pg.s" limit="pg.l" total="pg.t" onLinkClick="sl_goto('goodsreview', #)" onLimitChange="sl_limit('goodsreview', this)"/>
		</td>
		<td>&nbsp;</td>
		<td align="right">
		<#if "voteOk" == sorter.column!>
			<span class="sort-on"><@n.text name="sort-vote"/></span>
		<#else>
			<a href="#" onclick="sl_sortn('goodsreview', 'voteOk', 'DESC'); return false;"><@n.text name="sort-vote"/></a>
		</#if>
			 | 
		<#if "ptime" == sorter.column!>
			<span class="sort-on"><@n.text name="sort-date"/></span>
		<#else>
			<a href="#" onclick="sl_sortn('goodsreview', 'ptime', 'DESC'); return false;"><@n.text name="sort-date"/></a>
		</#if>
		</td>
	</tr>
	</table>
	</#macro>

	<div class="hr"></div><@grnav/>

	<#list reviewList as v>
	<div class="hr"></div>
	<div class="review-item"> 
		<#if ((v.voteOk!0) + (v.voteNo!0)) gt 0>
		<div class="review-voted"><@n.text name="label-vote"><@s.param>${(v.voteOk!0) + (v.voteNo!0)}</@s.param><@s.param>${v.voteOk!0}</@s.param><@s.param>${(v.voteOk!0) + (v.voteNo!0)}</@s.param></@n.text></div>
		</#if>
		
		<span class="review-rank">${consts.reviewRankMap[v.rank?c]}</span> 
		<span class="review-title">${v.title?html}</span>
		 | 
		<@n.text name="label-by"/>  
		<span class="review-title">${action.getReviewUser(v.userId).name?html}</span>,  
		<span class="review-date"><@n.date value=v.ptime format="datetime"/></span>
		
		<pre class="review-review">${v.review?html}</pre>
	
		<div class="review-coop"><@n.text name="label-cooperate"/></div>
		<table class="vote-tbl">
		<tr>
			<td><@n.text name="label-voteOk"/></td>
			<td><@n.submit icon="n-icon-thumb_up" onclick="gr_vote(this, '${v.id}', true)"><@n.text name="button-voteOk"/></@n.submit>
				<@n.submit icon="n-icon-thumb_down" onclick="gr_vote(this, '${v.id}', false)"><@n.text name="button-voteNo"/></@n.submit>
			</td>
			<td>&nbsp;<img class="vote-ind" src="${static}/nuts/images/loader/snake.gif"/></td>
		</tr>
		</table>
		<div class="vote-msg"></div>
		<br/>
	</div>
	</#list>
	
	<#if reviewList?size gt 7><div class="hr"></div><@grnav/></#if>
	
	<script type="text/javascript">
		function gr_vote(el, id, ok) {
			$(el).closest('table')
				.find('.vote-ind').show().end()
				.next('.vote-msg').html('').load(
					'<@n.url action="goodsreview_vote"/>', 
					{
						__decorator: 'none',
						rid: id,
						v: ok
					}, 
					function(rt, ts, xhr) {
						$(this).closest('table').find('.vote-ind').hide();
					});
		}
	</script>
<#else>
	<@n.text name="pager-text-nodata"/>
</#if>
</body>
</html>
