<#--
/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<html>
<head>
	<title><@n.text name="title"><@s.param><@n.text name="title-${step}"/></@s.param></@n.text></title>
</head>

<body>

<div class="n-sect" id="a_order_input">
	<div class="n-sect-head">
		<h3 class="n-sect-title"><@n.text name="title"><@s.param><@n.text name="title-${step}"/></@s.param></@n.text></h3>
	</div>
	<div class="n-sect-body">
		<ul class="n-step">
			<li class="n-step-first<#if step=='goods'> n-step-self</#if>"><@n.text name="step-goods"/></li>
			<li class="n-step-arrow"><@n.text name="step-arrow-e">&gt;</@n.text></li>
			<li class="n-step-next<#if step=='address'> n-step-self</#if>"><@n.text name="step-address"/></li>
			<li class="n-step-arrow"><@n.text name="step-arrow-e">&gt;</@n.text></li>
			<li class="n-step-next<#if step=='delivery'> n-step-self</#if>"><@n.text name="step-delivery"/></li>
			<li class="n-step-arrow"><@n.text name="step-arrow-e">&gt;</@n.text></li>
			<li class="n-step-next<#if step=='payment'> n-step-self</#if>"><@n.text name="step-payment"/></li>
			<li class="n-step-arrow"><@n.text name="step-arrow-e">&gt;</@n.text></li>
			<li class="n-step-next<#if step=='confirm'> n-step-self</#if>"><@n.text name="step-confirm"/></li>
			<li class="n-step-arrow"><@n.text name="step-arrow-e">&gt;</@n.text></li>
			<li class="n-step-last<#if step=='successs'> n-step-self</#if>"><@n.text name="step-success"/></li>
		</ul>
		<div class="n-clear"><hr/></div>

		<#include "/nuts/exts/struts2/views/action-prompt.ftl"/>
		<br/>
	
	<@n.form id="order" method="post" theme="simple">
	<@n.hidden name="step"/>

	<#if step == "goods" || step == "confirm">
		<#if !cart.empty>
			<#assign _sum_price = 0 />
			<table class="cart-table">
			<thead class="xhead">
				<tr>
					<th colspan="3"><@n.text name="label-cart-list"/></th>
					<th class="sale-price"><@n.text name="label-sale-price"/></th>
					<th class="goods-quantity"><@n.text name="label-quantity"/></th>
				</tr>
			</thead>
			<tbody>
			<#list cart.items as ci>
				<#assign _sum_price = _sum_price + ci.goods.salePrice * ci.quantity />
				
				<@n.url var="_url_" action="goods_view" namespace="/">
					<@s.param name="gid">${ci.goodsId}</@s.param>
				</@n.url>
				<tr><td colspan="5"><div class="hr"/></td></tr>
				<tr>
					<td class="item-check"><input type="checkbox" name="gids" value="${ci.goodsId}"<#if gids?? && gids?seq_contains(ci.goodsId)> checked="checked"</#if>/></td>
					<td class="goods-icon"><a href="${_url_}"><img src="<@n.url action="gi" namespace="/images">
							<@s.param name="gid">${ci.goodsId}</@s.param></@n.url>"/></a>
					</td>
					<td class="goods-name"><a href="${_url_}">${ci.goods.name?html}</a></td>
					<td class="sale-price"><@n.text name="format-price"><@s.param value="${ci.goods.salePrice?c}"/></@n.text></td>
					<td class="goods-quantity">${ci.quantity}</td>
				</tr>
			</#list>
			</tbody>
			<tfoot>
				<tr><td colspan="5"><div class="hr"/></td></tr>
				<tr>
					<td colspan="4" align="right">
						<span class="sum-price">
							<@n.text name="label-sum-price"/>&nbsp;
							<@n.text name="format-price"><@s.param value="${_sum_price?c}"/></@n.text>
						</span>
					</td>
					<td></td>
				</tr>
			</tfoot>
			</table>
			<br/>
			<div class="n-tcenter">
				<@n.submit icon="n-icon-bullet_go" action="order_selectGoodsConfirm"><@n.text name="button-next"/></@n.submit>
			</div>
		</#if>
	<#else>
		<#list gids as i>
			<input type="hidden" name="gids" value="${i}"/>
		</#list>
	</#if>
	
	<#if step == "address" || step == "confirm">
	<div>
		<h4 class="caption"><@n.text name="label-select-address"/></h4>
		<div><@n.text name="label-address-tip"><@s.param><@n.url action='help' namespace='/'><@s.param name='name'>termsofuse</@s.param></@n.url></@s.param></@n.text></div>
		<br/>
		
		<#if userAddressList?has_content>
			<@n.hidden name="caId"/>
			<h4 class="xhead"><@n.text name="label-address-user"><@s.param>${Session.user.name}</@s.param></@n.text></h4>
			<div>
			<#list userAddressList as ca>
				<span class="address-card">
					<b>${ca.name?html}</b><br/>
					<@n.text name="label-zipcode"/>${ca.zipcode?html}<br/>
					${utils.escapePhtml(ca.address)}<br/>
					<#if ca.company?has_content>${ca.company?html}<br/></#if>
					<img class="n-icon n-icon-telephone" src="${base}/statc/nuts/images/s.gif"/>${ca.phone?html}<br/>
					<br/>
					<@n.submit icon="n-icon-bullet_go" onclick="selectAddress('${ca.id}'); return false;"><@n.text name="button-address"/></@n.submit>
				</span>
			</#list>
			</div>
			<script type="text/javascript">
				function selectAddress(id) {
					$('#order_caId').val(id);

					var form = $('#order').get(0);
					form.action = "<@n.url action='order_selectAddressConfirm'/>";
					form.submit();

					return false;
				}
			</script>
		</#if>
		<br/>
		
		<h4 class="xhead"><@n.text name="label-address-new"/></h4>
		<div class="xbody">
		<table class="n-eform">
			<@n.textfield key="ca.name" required="true" maxlength="40" size="40" theme="nxhtml">
				<@s.param name="tooltip"><@n.text name="ca.name-tip"> </@n.text></@s.param>
			</@n.textfield>
			<@n.textfield key="ca.zipcode" required="true" maxlength="8" size="10" theme="nxhtml">
				<@s.param name="tooltip"><@n.text name="ca.zipcode-tip"> </@n.text></@s.param>
			</@n.textfield>
			<@n.textarea key="ca.address" required="true" maxlength="200" cols="40" rows="2" theme="nxhtml">
				<@s.param name="tooltip"><@n.text name="ca.address-tip"> </@n.text></@s.param>
			</@n.textarea>
			<@n.textarea key="ca.company" maxlength="200" cols="40" rows="2" theme="nxhtml">
				<@s.param name="tooltip"><@n.text name="ca.company-tip"> </@n.text></@s.param>
			</@n.textarea>
			<@n.textfield key="ca.phone" required="true" maxlength="14" size="16" theme="nxhtml">
				<@s.param name="tooltip"><@n.text name="ca.phone-tip"> </@n.text></@s.param>
			</@n.textfield>
			<@n.submit icon="n-icon-bullet_go" action="order_inputAddressConfirm" theme="nxhtml"><@n.text name="button-address"/></@n.submit>
		</table>
		</div>
	</div>
	<#else>
		<@n.hidden name="caId"/>
		<@n.hidden name="ca.name"/>
		<@n.hidden name="ca.zipcode"/>
		<@n.hidden name="ca.address"/>
		<@n.hidden name="ca.company"/>
		<@n.hidden name="ca.phone"/>
	</#if>
	
	<#if step == "delivery" || step == "confirm">
		<h4 class="caption"><@n.text name="label-select-delivery"/></h4>
		<div><@n.text name="label-delivery-tip"> </@n.text></div>
		<br/>
		<#assign _map = consts.deliveryKindMap/> 
		<#list _map?keys as k>
			<input type="radio" id="order_co_deliveryKind_${k}" name="co.deliveryKind" value="${k}"<#if k == co.deliveryKind!> checked="checked"</#if>/>
			<label for="order_co_deliveryKind_${k}">${_map[k]?html}</label><br/>
			<#if k_has_next><div class="hr"></div></#if>
		</#list>
		<br/>
		<div class="shr"></div>
		<table class="n-eform">
			<@n.datepicker key="co.deliveryDate" inline="true" size="18" maxlength="16" theme="nxhtml">
				<@s.param name="options">{'minDate': '<@n.text name="order-delivery-min-date">+2d</@n.text>'}</@s.param>
				<@s.param name="tooltip"><@n.text name="co.deliveryDate-tip"> </@n.text></@s.param>
			</@n.datepicker>
			<@n.radio key="co.deliveryTime" list="consts.deliveryTimeMap" theme="nxhtml">
				<@s.param name="tooltip"><@n.text name="co.deliveryTime-tip"> </@n.text></@s.param>
			</@n.radio>
			<@n.textarea key="co.memo" maxlength="500" cols="40" rows="3" theme="nxhtml">
				<@s.param name="tooltip"><@n.text name="co.memo-tip"> </@n.text></@s.param>
			</@n.textarea>
			<@n.submit icon="n-icon-bullet_go" action="order_selectDeliveryConfirm" theme="nxhtml"><@n.text name="button-next"/></@n.submit>
		</table>
	<#else>
		<@n.hidden name="co.deliveryKind"/>
		<@n.hidden name="co.deliveryDate"/>
		<@n.hidden name="co.deliveryTime"/>
		<@n.hidden name="co.memo"/>
	</#if>
	
	<#if step == "payment" || step == "confirm">
		<h4 class="caption"><@n.text name="label-select-payment"/></h4>
		<div><@n.text name="label-payment-tip"/></div>
		<br/>
		
		<#if userCreditCardList?has_content>
			<@n.hidden name="cccId"/>
			<h4 class="xhead"><@n.text name="label-creditcard-user"><@s.param>${Session.user.name}</@s.param></@n.text></h4>
			<div>
			<#list userCreditCardList as ccc>
				<span class="creditcard-card">
					${consts.creditCardTypeMap[ccc.cardType]?html}<br/>
					<b>${ccc.cardNo?substring(0, ccc.cardNo?length - 4)}XXXX</b><br/>
					${ccc.cardName?html}<br/>
					${ccc.cardExpires?string('MM/yyyy')}<br/>
					<br/>
					<@n.submit icon="n-icon-bullet_go" onclick="selectCreditCard('${ccc.id}'); return false;"><@n.text name="button-creditcard"/></@n.submit>
				</span>
			</#list>
			</div>
			<script type="text/javascript">
				function selectCreditCard(id) {
					$('#order_cccId').val(id);

					var form = $('#order').get(0);
					form.action = "<@n.url action='order_selectCreditCardConfirm'/>";
					form.submit();

					return false;
				}
			</script>
		</#if>
		<br/>
		
		<h4 class="xhead"><@n.text name="label-creditcard-new"/></h4>
		<div class="xbody">
			<table class="n-eform">
				<@n.radio
					key="ccc.cardType"
					required="true"
					list="consts.creditCardTypeMap"
					theme="nxhtml"
					tooltip="%{getText('ccc.cardType-tip', '')}"
				>
				</@n.radio>
	
				<@n.textfield
					key="ccc.cardNo"
					required="true"
					maxlength="24"
					size="26"
					theme="nxhtml"
					tooltip="%{getText('ccc.cardNo-tip', '')}"
				>
				</@n.textfield>
	
				<@n.textfield
					key="ccc.cardName"
					required="true"
					maxlength="40"
					size="26"
					theme="nxhtml"
					tooltip="%{getText('ccc.cardName-tip', '')}"
				>
				</@n.textfield>
	
				<@n.datepicker
					key="ccc.cardExpires"
					required="true"
					format="cce"
					maxlength="7"
					size="12"
					theme="nxhtml"
					tooltip="%{getText('ccc.cardExpires-tip', '')}"
				>
				</@n.datepicker>
	
				<@n.submit icon="n-icon-bullet_go" action="order_inputCreditCardConfirm" theme="nxhtml"><@n.text name="button-creditcard"/></@n.submit>
			</table>
		</div>
		<br/>

		<h4 class="xhead"><@n.text name="label-payment-other"/></h4>
		<div class="xbody">
		<#assign _map = consts.paymentKindMap/> 
		<#list _map?keys as k><#if k != 'C'>
			<input type="radio" id="order_co_paymentKind_${k}" name="co.paymentKind" value="${k}"<#if k == co.paymentKind!> checked="checked"</#if>/>
			<label for="order_co_paymentKind_${k}">${_map[k]?html}</label><br/>
			<#if k_has_next><div class="hr"></div></#if>
		</#if></#list>

			<div class="shr"></div>
			<ul class="comment">
				<li><@n.text name="label-payment-tip"> </@n.text></li>
				<li><@n.text name="label-before-confirm"> </@n.text></li>
			</ul>
			<div class="n-tcenter">
				<@n.submit icon="n-icon-bullet_go" action="order_selectPaymentConfirm"><@n.text name="button-next"/></@n.submit>
			</div>
		</div>
	<#else>
		<@n.hidden name="cccId"/>
		<@n.hidden name="ccc.cardType"/>
		<@n.hidden name="ccc.cardNo"/>
		<@n.hidden name="ccc.cardName"/>
		<@n.hidden name="ccc.cardExpires"/>
	</#if>
	
	</@n.form>
	</div>
</div>

</body>
</html>
