package squirrels.ecshop.action.user;

import nuts.aems.action.user.LoginAction;

import squirrels.ecshop.action.ActionTestCase;

import com.opensymphony.xwork2.Action;
import com.opensymphony.xwork2.ActionProxy;

/**
 * LoginTest
 */
public class LoginTest extends ActionTestCase {
	/**
	 * testInput
	 * @throws Exception if an error occurs
	 */
	public void testInput() throws Exception {
		ActionProxy proxy = createActionProxy("/user", "login", "input");

		String result = proxy.execute();

		assertTrue(getAction() instanceof LoginAction);
		assertEquals(Action.INPUT, result);

		getResponseContentAsString();
	}

	/**
	 * testLoginEmptyInput
	 * @throws Exception if an error occurs
	 */
	public void testLoginEmptyInput() throws Exception {
		doRequest("/user/login_login");

		String rc = getResponseContentAsString();

		assertTrue("no field errors", rc.indexOf("fieldError") > 0);
	}

	/**
	 * testLoginSuccess
	 * @throws Exception if an error occurs
	 */
	public void testLoginSuccess() throws Exception {
		ActionProxy proxy = createActionProxy("/user", "login", "login", "LoginTest-success.properties");

		String result = proxy.execute();

		assertEquals(Action.SUCCESS, result);

		getResponseContentAsString();
	}
}
