<#--
/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
-->
		<table class="cart-table">
		<thead class="xhead">
			<tr>
				<th colspan="3"><@n.text name="label-goodss"/></th>
				<th class="sale-price"><@n.text name="label-sale-price"/></th>
				<th class="goods-quantity"><@n.text name="label-quantity"/></th>
			</tr>
		</thead>
		<tbody>
		<#list d.items as ci>
			<@n.url var="_url_" action="goods_view">
				<@s.param name="gid">${ci.goodsId}</@s.param>
			</@n.url>
			<tr><td colspan="5"><div class="hr"/></td></tr>
			<tr>
				<td class="item-no">${ci_index + 1}.</td>
				<td class="goods-icon"><a href="${_url_}"><img src="<@n.url action="gi" namespace="/images">
						<@s.param name="gid">${ci.goodsId}</@s.param></@n.url>"/></a>
				</td>
				<td class="goods-name"><a href="${_url_}">${ci.goodsName?html}</a></td>
				<td class="sale-price"><@n.text name="format-price"><@s.param value="${ci.salePrice?c}"/></@n.text></td>
				<td class="goods-quantity">${ci.quantity}</td>
			</tr>
		</#list>
		</tbody>
		<tfoot>
			<tr><td colspan="5"><div class="hr"/></td></tr>
			<tr>
				<td colspan="4">
					<span class="sum-price">
						<@n.text name="label-sum-price"/>&nbsp;
						<@n.text name="format-price"><@s.param value="${d.orderPrice?c}"/></@n.text>
					</span>
				</td>
				<td></td>
			</tr>
		</tfoot>
		</table>
		<br>
	
		<h4 class="xhead"><@n.text name="label-address"/></h4>
		<div class="xbody">
			<table>
				<@n.viewfield key="d.toName" theme="nxhtml"/>
				<@n.viewfield key="d.toZipcode" theme="nxhtml"/>
				<@n.viewfield key="d.toAddress" theme="nxhtml"/>
				<@n.viewfield key="d.toCompany" theme="nxhtml"/>
				<@n.viewfield key="d.toPhone" theme="nxhtml"/>
			</table>
		</div>
	
		<h4 class="xhead"><@n.text name="label-delivery"/></h4>
		<div class="xbody">
			<table>
				<@n.viewfield key="d.deliveryKind" list="consts.deliveryKindMap" theme="nxhtml"/>
				<@n.viewfield key="d.deliveryDate" format="date" theme="nxhtml"/>
				<@n.viewfield key="d.deliveryTime" list="consts.deliveryTimeMap" theme="nxhtml"/>
				<@n.viewfield key="d.memo" theme="nxhtml"/>
			</table>
		</div>
	
		<h4 class="xhead"><@n.text name="label-payment"/></h4>
		<div class="xbody">
			<table>
				<@n.viewfield key="d.paymentKind" list="consts.paymentKindMap" theme="nxhtml"/>
			<#if d.paymentKind == 'C'> 
				<@n.viewfield key="d.cardType" list="consts.creditCardTypeMap" theme="nxhtml"/>
				<@n.viewfield key="d.cardNo" expression="d.cardNo.substring(0, d.cardNo.length()-4)+'XXXX'" theme="nxhtml"/>	
				<@n.viewfield key="d.cardName" theme="nxhtml"/>
				<@n.viewfield key="d.cardExpires" theme="nxhtml"/>
			</#if>
			</table>
		</div>
