#include	"init.h"
#include	"dstatus.h"
#include	"config.h"

void	pselectSet(void);
void	portSet(void);
void	aprs (void);
void    lost_frame(void);
void    repeater_gw(void);
int     repeater_zr(void);
int	repeater_mon(void);
int     repeater_init(void);
int     read_config(int argc, char **argv);
int     handler_init(void);
void	serial_read(void);
void    status_keep_alive_send(void);
void    status_logoff_send(void);
unsigned int crc32(int n, unsigned char c[]);

struct	ModuleTable	*module_check_ex (char FrameID[], in_addr_t ipaddr, in_port_t port);

extern	void	handler(int sig);

extern	int		rpt_zr_sd;
extern	int		rpt_gw_sd;
extern	int		rpt_mon_sd;
time_t			start_time;


struct	sockaddr_in	in_sock;
socklen_t		len_in_sock;

int main(int argc, char** argv)
{

	int	i;
	int	ret;
	int	status_start;

	time_t	atime;
	time_t	uptime;

	tzset();

        uname(&uname_buf);

	log_file = fopen (LOG_FILE, "a");
	if (log_file == NULL)
	{
		return 1;
	}
	time (&start_time);

	fprintf (log_file, "%24.24s D-STAR X-change (xchange) add on status V%5.5s (%s  %s) Start\n", 
						ctime(&start_time), PACKAGE_VERSION, __DATE__, __TIME__);
	fflush (log_file);

	pid_file = fopen(PID_FILE, "r");
	if (pid_file == NULL)
	{
		pid_file = fopen(PID_FILE, "w");
	}
	else
	{
		fprintf (log_file, "%24.24s Already running status.\n", ctime(&atime));
		fclose (log_file);
		return -1;
	}
	fprintf (pid_file, "%d", getpid());
	fclose (pid_file); 

	/* default value */
	mon_port = MON_PORT;
	reload = FALSE;
	sig_term = FALSE;
	debug_sw = FALSE;

	DprsMsg_pnt = NULL;

	module_pnt = NULL;

	status_pnt = NULL;

	mon_port = 0;

	rpt_mon_sd = 0;

	time (&status_keep_alive);

	if (!handler_init()) goto end;

	xchange_conf_read();
	if (!read_config (argc, (char **)argv)) goto end;

        if (debug_sw) 
	{
		fprintf (log_file, "                         %s %s %s\n",
                	uname_buf.sysname, uname_buf.release, uname_buf.version);
		fflush (log_file);
	}

	srand (crc32(8, (unsigned char *)client_callsign));
	status_start = rand() % 300;

	time (&atime);
	if (debug_sw)
	{
		fprintf (log_file, "%24.24s Word Size : %d\n", ctime(&atime), __WORDSIZE);
		fflush (log_file);
	}

	pselectSet();	// FD & sig init
	if (!repeater_init()) goto end;

	portSet();
	
	while (1)
	{
		memcpy (&read_set, &fd_save, sizeof(fd_set));
		memcpy (&sigset, &save_sig, sizeof(save_sig));
		ret = pselect (FD_SETSIZE, &read_set, (fd_set *)NULL, 
				(fd_set *)NULL, &timeout, &sigset);
		time (&atime);
		if (ret < 0) 
		{
                	fprintf (log_file, "%24.24s pselect error %s\n", ctime(&atime), strerror(errno));
                	fflush (log_file);
			break;
		}
		else if (ret > 0)
		{
                	if (FD_ISSET (rpt_mon_sd, &read_set))
                	{
                        	if (!repeater_mon()) break;
                	}

		}
		else
		{
			lost_frame();
		}
		if ((status_pnt != NULL) && ((atime - status_keep_alive) >= status_start))
		{
							status_keep_alive_send();
							status_start = 300;
		}
		module_pass_check();
		if (sig_term) break;
	
	}

	// socket close
	if (rpt_mon_sd) close (rpt_mon_sd);
end:
	if (status_pnt) status_logoff_send();
	time(&atime);
	uptime = atime - start_time;
	fprintf (log_file, "%24.24s D-STAR X-change (xchange) add on status terminated (Up : %ldd%2ldh%2ldm%2lds)\n\n",
			ctime(&atime), 
			(uptime / 86400),
			((uptime % 86400) / 3600),
			(((uptime % 86400) % 3600) / 60),
			(((uptime % 86400) % 3600) % 60));
	fclose (log_file);
	remove (PID_FILE);
    	return 0;
}

