#include	"dstatus.h"

void    module_init(struct ModuleTable *module, char Module[]);
void	forward_init (struct forward *fwd, char Fullname[], 
		int port);
void    status_init (struct status *sta, char Fullname[], int port);


int	read_config(int argc, char **argv)
{
	char	buff[256];
	char	*delmi = "=\n\r\t\0";
	char	*pnt;
	char	*p;
	int	len;
	int	n;
	int	field_sw;
	int	port;
	time_t	atime;
	int	false_ret;
	char	fqdn[128];
	struct	status		*status_next;

	FILE	*config_file;
	
	if (argc == 2)
	{
		config_file = fopen (argv[1], "r");
		if (!config_file)
		{
			time(&atime);
			fprintf (log_file, "%24.24s config file not found (%s)\n", ctime(&atime), argv[1]);
			fflush (log_file);
			return FALSE;
		}
	} 
	else
	{
		config_file = fopen (CONFIG_FILE,"r");
		if (!config_file)
		{
			time(&atime);
			fprintf (log_file, "%24.24s config file not found (%s)\n", 
						ctime(&atime), CONFIG_FILE);
			fflush (log_file);
			return FALSE;
		}
	}

	while (fgets (buff, 255, config_file))
	{
		if (buff[0] != '#')
		{
			n = 0;
			while (buff[n] == 0x20) n++;
			p = strtok(&buff[n], delmi);
			if (p != NULL)
			{
				pnt = strtok(NULL, delmi);
	
				if (!memcmp (p, "MON_PORT", 8) || !memcmp(p, "RECV_PORT", 9))
				{
					mon_port = atoi (pnt);
				}
				else if (!memcmp (p, "DEBUG", 5))
				{
					debug_sw = atoi(pnt);
				}
                                else if (!memcmp (p, "STATUS", 7))
                                {
                                        n = 0;
                                        field_sw = 0;
                                        port = 0;
                                        memset (fqdn, 0x20, 128);
                                        while (*pnt)
                                        {
                                                if (*pnt != ',')
                                                {
                                                        if (field_sw)
                                                        {
                                                                if (isdigit (*pnt)) port = port * 10 + *pnt - '0';
                                                        }
                                                        else
                                                        {
                                                                if (*pnt == ':') field_sw = 1;
                                                                else
                                                                {
                                                                        if (*pnt != 0x20) fqdn[n++] = *pnt;
                                                                        if (n > 127) n = 127;
                                                                }
                                                        }
                                                }
                                                else
                                                {
                                                        status_next = malloc (sizeof (struct status));
                                                        if (status_next != NULL)
                                                        {
                                                                fqdn[n] = 0x00;
                                                                status_init(status_next, fqdn, port);
                                                                if (status_pnt) status_last->f_chain = status_next;
                                                                else status_pnt = status_next;
                                                                status_last = status_next;
                                                                port = 0;
                                                                n = 0;
                                                                field_sw = 0;
                                                        }
                                                        else
                                                        {
                                                                time(&atime);
                                                                fprintf (log_file, "%24.24s Memoty not allocate (STATUS)\n",
										ctime(&atime));
                                                                fflush (log_file);
                                                        }
                                                }
                                                pnt++;
                                        }
                                        if (n)
                                        {
                                                fqdn[n] = 0x00;
                                                status_next = malloc (sizeof (struct status));
                                                status_init(status_next, fqdn, port);
                                                if (status_pnt) status_last->f_chain = status_next;
                                                else status_pnt = status_next;
                                                status_last = status_next;
                                        }
                                }
                                else if (!memcmp (p, "CALLSIGN", 8))
                                {
                                        memset (client_callsign, 0x20, 8);
                                        len = strlen(pnt);
                                        if (len > 8) len = 8;
                                        memcpy (client_callsign, pnt, len);
                                }
				else
				{
					time (&atime);
					fprintf (log_file, "%24.24s Error on config file : %s\n",ctime(&atime), buff);
					fflush (log_file);
				}
			}
		}
	}

	fclose (config_file);

	false_ret = FALSE;
	time (&atime);
	if (mon_port <= 0)
	{
		fprintf (log_file, "%24.24s Zone Repeater Monitor port not assign.\n", ctime(&atime));
		false_ret = TRUE;
		fflush (log_file);
	}

	if (false_ret) return FALSE;
	return TRUE;
	
}

void	module_init(struct ModuleTable *module, char Module[])
{
	module->AccessTime = 0;
	memcpy (module->ModuleName, Module, 8);
	memset (module->mycall, 0x20, 8);
	memset (module->mycall_ex, 0x20, 4);
	memset (module->rptcall, 0x20, 8);
	module->aprs_msg_pnt = 0;
	module->packet_cnt = 0;
	module->HeaderCnt = 0;
	module->RadioVoicePacketCnt = 0;
	module->f_chain = NULL;
	module->SendSeq = 0;
	module->rpt_save_length = 0;
	module->recv_time.tv_sec = 0;
	module->recv_time.tv_usec = 0;
	module->lost_cnt = 0;
}

void    status_init (struct status *sta, char FullName[], int port)
{
        sta->f_chain = NULL;
        sta->port = port;
        memcpy (sta->fqdn, FullName, 128);
        sta->packets = 0;
	memset (sta->userID, 0x00, 16);
	memset (sta->passwd, 0x00, 64);
	sta->status_info = NULL;
}

