﻿using System;
using System.Collections.Generic;

namespace FDK.カウンタ
{
	/// <summary>
	/// FPS（１秒間の進行処理回数）と VPS（１秒間の描画処理回数）を計測する。
	/// </summary>
	/// <remarks>
	/// 計測するだけで、表示はしない。
	/// FPSをカウントする() を呼び出さないと、VPS も更新されないので注意。
	/// </remarks>
	public class FPS
	{
		public int 現在のFPS
		{
			get
			{
				lock( this.排他利用 )
				{
					return this.bs_現在のFPS;
				}
			}
		}
		public int 現在のVPS
		{
			get
			{
				lock( this.排他利用 )
				{
					return this.bs_現在のVPS;
				}
			}
		}

		public FPS()
		{
			this.初めてのFPS更新 = true;
			this.bs_現在のFPS = 0;
			this.bs_現在のVPS = 0;
		}

		// 進行処理時に呼び出す想定。
		public void FPSをカウントする()
		{
			lock( this.排他利用 )
			{
				if( this.初めてのFPS更新 )
				{
					this.初めてのFPS更新 = false;
					this.fps用カウンタ = 0;
					this.vps用カウンタ = 0;
					this.定間隔進行 = new 定間隔進行();
					this.定間隔進行.経過時間の計測を開始する();
				}
				else
				{
					// fps 更新。
					this.fps用カウンタ++;

					// 1秒ごとに FPS, VPS プロパティの値を更新。
					this.定間隔進行.経過時間の分だけ進行する( 1000, () => {

						this.bs_現在のFPS = this.fps用カウンタ;
						this.bs_現在のVPS = this.vps用カウンタ;
						this.fps用カウンタ = 0;
						this.vps用カウンタ = 0;

					} );
				}
			}
		}

		// 描画時に呼び出す想定。
		public void VPSをカウントする()
		{
			lock( this.排他利用 )
			{
				this.vps用カウンタ++;
			}
		}

		private int fps用カウンタ = 0;
		private int vps用カウンタ = 0;
		private FDK.カウンタ.定間隔進行 定間隔進行 = null;
		private bool 初めてのFPS更新 = true;

		// Write のほうが多いだろうから、ReaderWriterLockSlim より高速な lock を使う。
		private readonly object 排他利用 = new object();

		#region " バックストア "
		//-----------------
		private int bs_現在のFPS = 0;
		private int bs_現在のVPS = 0;
		//-----------------
		#endregion
	}
}
