﻿using System;

namespace FDK.メディア.サウンド.WASAPI排他
{
	/// <summary>
	/// IMFAsyncCallback の汎用的な実装。
	/// </summary>
	/// <remarks>
	/// コンストラクタで、ワークキューIDとコールバックデリゲート（InvokeFunc型）を指定する。
	/// </remarks>
	public class MFAsyncCallback : SharpDX.MediaFoundation.AsyncCallbackBase, SharpDX.MediaFoundation.IAsyncCallback
	{
		public delegate void InvokeFunc( SharpDX.MediaFoundation.AsyncResult asyncResult );

		public MFAsyncCallback( int QueueID, InvokeFunc invokeFunc )
		{
			this.QueueID = new SharpDX.MediaFoundation.WorkQueueId( QueueID );
			this.invokeFunc = invokeFunc;
		}

		public override SharpDX.MediaFoundation.WorkQueueId WorkQueueId
		{
			get
			{
				return this.QueueID;
			}
		}
		public override void Invoke( SharpDX.MediaFoundation.AsyncResult asyncResult )
		{
			this.invokeFunc( asyncResult );
		}

		private SharpDX.MediaFoundation.WorkQueueId QueueID = SharpDX.MediaFoundation.WorkQueueId.Standard;
		private InvokeFunc invokeFunc = null;
	}
}
