﻿using System;
using System.Collections.Generic;

namespace FDK.メディア.サウンド.WASAPI排他
{
	/// <summary>
	/// Sound のリストを持ち、そのサウンドデータを合成してWASAPIデバイスへ出力するミキサー。
	/// </summary>
	public unsafe class Mixer : IDisposable
	{
		public Mixer()
		{
		}
		public void 初期化する( int エンドポイントバッファサイズsample )
		{
			lock( this.排他利用 )
			{
				if( エンドポイントバッファサイズsample == this.エンドポイントバッファサイズsample )
					return;     // サイズに変更があったときのみ初期化する。

				this.エンドポイントバッファサイズsample = エンドポイントバッファサイズsample;
				this.サウンドリスト.Clear();

				if( null != this.合成用バッファ )
					FDK.Memory.Free( this.合成用バッファ );
				this.合成用バッファ = FDK.Memory.Alloc( this.エンドポイントバッファサイズsample * ( 4 * 2 ) );       // 1sample = 32bit×2ch
			}
		}
		public void Dispose()
		{
			lock( this.排他利用 )
			{
				this.サウンドリスト.Clear();
				if( null != this.合成用バッファ )
				{
					FDK.Memory.Free( this.合成用バッファ );
					this.合成用バッファ = null;
				}
				this.エンドポイントバッファサイズsample = -1;
			}
		}
		public void サウンドリストをクリアする()
		{
			lock( this.排他利用 )
			{
				this.サウンドリスト.Clear();
			}
		}
		public void サウンドを追加する( Sound sound )
		{
			lock( this.排他利用 )
			{
				this.サウンドリスト.Add( sound );
			}
		}
		public void サウンドを削除する( Sound sound )
		{
			lock( this.排他利用 )
			{
				this.サウンドリスト.Remove( sound );
			}
		}
		public CSCore.CoreAudioAPI.AudioClientBufferFlags エンドポイントへ出力する( void* エンドポイントの出力先, int 出力数sample )
		{
			lock( this.排他利用 )
			{
				if( null == this.合成用バッファ )
					return CSCore.CoreAudioAPI.AudioClientBufferFlags.Silent;

				#region " すべてのサウンドについて、合成バッファへ出力する。"
				//-----------------
				bool 最初の出力である = true;

				foreach( var sound in this.サウンドリスト )
				{
					var flag = sound.次のサウンドデータを出力する( this.合成用バッファ, 出力数sample, 最初の出力である );

					if( false == flag.HasFlag( CSCore.CoreAudioAPI.AudioClientBufferFlags.Silent ) )
						最初の出力である = false;   // sound が何らかのデータを出力した（戻り値がSILENTじゃなかった）
				}

				// 全サウンドが SILENT だったなら、エンドポイントには何も書き込まずに SILENT フラグを返す。
				if( 最初の出力である )
					return CSCore.CoreAudioAPI.AudioClientBufferFlags.Silent;
				//-----------------
				#endregion
				#region " 合成バッファのデータ値（32bit;オーバーサンプル）を16bitに丸めてエンドポイントに出力する。"
				//-----------------
				Int32* 出力元 = (Int32*) ( this.合成用バッファ );
				Int16* 出力先 = (Int16*) エンドポイントの出力先;
				for( int i = 0; i < 出力数sample; i++ )
				{
					Int32 src;

					// 音量やミュートの処理は不要。（WASAPI が自動でマスタ音量・ミュート状態に合わせてくれる）

					// 左ch
					src = *出力元++;
					if( -32768 > src )
						src = -32768;
					else if( 32767 < src )
						src = 32767;
					*出力先++ = (Int16) src;

					// 右ch
					src = *出力元++;
					if( -32768 > src )
						src = -32768;
					else if( 32767 < src )
						src = 32767;
					*出力先++ = (Int16) src;
				}
				//-----------------
				#endregion
			}
			return CSCore.CoreAudioAPI.AudioClientBufferFlags.None;
		}

		private int エンドポイントバッファサイズsample = -1;
		private readonly List<Sound> サウンドリスト = new List<Sound>();
		private void* 合成用バッファ = null;
		private readonly object 排他利用 = new object();
	}
}
