﻿using System;
using System.Collections.Generic;
using System.Threading;

namespace FDK.同期
{
	/// <summary>
	/// System.Threading.ManualResetEvent のラッパー。
	/// </summary>
	public class ManualEvent
	{
		public ManualEvent( bool 初期状態 = false )
		{
			if( 初期状態 )
				this._event.Set();
			else
				this._event.Reset();
		}

		public bool セットされている => this._event.WaitOne( 0 );
		public bool セットされていない => !( this._event.WaitOne( 0 ) );

		public void セットする() => this._event.Set();
		public void リセットする() => this._event.Reset();
		public void セットされるまでブロックする( int タイムアウトms = System.Threading.Timeout.Infinite ) => this._event.WaitOne( タイムアウトms );

		protected readonly System.Threading.ManualResetEvent _event = new ManualResetEvent( false );
	}
}
