﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Diagnostics;
using System.Xml.Serialization;
using System.Windows.Forms;

namespace SSTFEditor
{
	public class Config
	{
		// プロパティ（保存される）

		public bool AutoFocus = true;
		public bool ShowRecentUsedFiles = true;
		public int MaxOfUsedRecentFiles = 10;
		public List<string> RecentUsedFiles = new List<string>();


		// メソッド（保存されない）

		public static Config 読み込む( string strFileName )
		{
			Config config = null;


			// 読み込み。

			try
			{
				config = FDK.XML.Serializer.ファイルをデシリアライズしてインスタンスを生成する<Config>( strFileName );
			}
			catch( Exception )
			{
//				if( ( e as FileNotFoundException ) == null )		// FileNotFound 以外ならログに例外詳細を出力する。
//					FDK.C共通.t例外の詳細をログに出力する( e );

				config = new Config();	// 読み込めなかったので新規作成。
			}


			// 後処理。（特になし。）

			return config;
		}
		public void 保存する( string strFileName )
		{
			try
			{
				FDK.XML.Serializer.インスタンスをシリアライズしてファイルに保存する( strFileName, this );
			}
			catch( Exception e )
			{
				MessageBox.Show( "ファイルの保存に失敗しました。[{0}]\n--------\n" + e.ToString(), strFileName );
			}
		}
		public void ファイルを最近使ったファイルの一覧に追加する( string fileName )
		{
			// 絶対パスを取得する。

			fileName = Path.GetFullPath( fileName );


			// 一覧に同じ文字列があったら一覧から削除する。

			this.RecentUsedFiles.RemoveAll( ( path ) => { return path.Equals( fileName ); } );


			// 一覧の先頭に登録する。

			this.RecentUsedFiles.Insert( 0, fileName );
	

			// 10個以上は記録しない。

			if( this.RecentUsedFiles.Count > 10 )
			{
				int n超えてる数 = this.RecentUsedFiles.Count - 10;

				for( int i = n超えてる数; i > 0; i-- )
					this.RecentUsedFiles.RemoveAt( 10 + i - 1 );
			}
		}
	}
}
