﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;

namespace SSTFEditor.UndoRedo
{
	class セルリスト : セルBase
	{
		public List<セルBase> セルs;
		public int 次にセルが追加される位置0to;
		public セルリスト 親リスト;
		public int Redo可能な回数 => ( this.現在の総セル数 - this.Undo可能な回数 );
		public int Undo可能な回数 => this.次にセルが追加される位置0to;
		public int 現在の総セル数 => this.セルs.Count;

		public セルリスト( セルリスト 親リスト )
		{
			this.親リスト = 親リスト;
			this.セルs = new List<セルBase>();
			this.次にセルが追加される位置0to = 0;
		}
		public override void Redoを実行する()
		{
			// 前から順に実行する。
			foreach( セルBase cell in this.セルs )
				cell.Redoを実行する();
		}
		public override void Undoを実行する()
		{
			// 後ろから順に実行する。
			for( int i = this.セルs.Count - 1; i >= 0; i-- )
				this.セルs[ i ].Undoを実行する();
		}
	}
}
