﻿using System;
using System.Collections.Generic;
using System.Text;

namespace SSTFEditor
{
	class クリップボード
	{
		class Cセル
		{
			public bool b貼り付け済 = false;
			public int nグループID = 0;
			public SSTFormat.チップ cチップ = null;
		}


		// プロパティ

		public int セル数
		{
			get { return this.listセル.Count; }
		}


		// メソッド

		public クリップボード( メインフォーム form )
		{
			this.Form = form;
		}

		public void tクリアする()
		{
			this.listセル.Clear();
		}
		public void 現在選択されているチップをボードにコピーする()
		{
			this.tクリアする();

			foreach( var chip in this.Form.譜面.SSTFormatScore.listチップ )
			{
				if( chip.選択が確定している )
				{
					this.listセル.Add(
						new Cセル() { cチップ = new SSTFormat.チップ( chip ) } );
				}
			}
		}
		public void tチップを指定位置から貼り付ける( int n貼り付け先頭の譜面内絶対位置grid )
		{
			if( this.セル数 == 0 )
				return;

			this.Form.UndoRedo管理.トランザクション記録を開始する();

			#region [ すべてのセルについて、チップ位置を、ボード内でもっとも位置が前にあるセルを 0grid とした相対値に変換する。]
			//-----------------
			int n最小値grid = this.listセル[ 0 ].cチップ.譜面内絶対位置grid;
			foreach( var cell in this.listセル )
			{
				if( cell.cチップ.譜面内絶対位置grid < n最小値grid )
					n最小値grid = cell.cチップ.譜面内絶対位置grid;
			}
			foreach( var cell in this.listセル )
				cell.cチップ.譜面内絶対位置grid -= n最小値grid;
			//-----------------
			#endregion
			#region [ すべてのセルについて、チップ位置を、実際に貼り付ける位置に変換する。]
			//-----------------
			foreach( var cell in this.listセル )
				cell.cチップ.譜面内絶対位置grid += n貼り付け先頭の譜面内絶対位置grid;
			//-----------------
			#endregion

			#region [ チップを譜面に貼り付ける。]
			//-----------------
			foreach( var cell in this.listセル )
			{
				this.Form.譜面.tチップを配置または置換する(
					this.Form.譜面.dicチップ編集レーン対応表[ cell.cチップ.チップ種別 ],
					cell.cチップ.チップ種別,
					cell.cチップ.譜面内絶対位置grid,
					cell.cチップ.チップ内文字列,
					cell.cチップ.音量,
					cell.cチップ.BPM,
					true );	// 選択状態
			}
			//-----------------
			#endregion

			this.Form.UndoRedo管理.トランザクション記録を終了する();
			this.Form.UndoRedo用GUIのEnabledを設定する();
			this.Form.選択チップの有無に応じて編集用GUIのEnabledを設定する();
			this.Form.譜面をリフレッシュする();
			this.Form.未保存である = true;
		}

		
		#region [ protected ]
		//-----------------
		protected メインフォーム Form;
		private List<Cセル> listセル = new List<Cセル>();
		//-----------------
		#endregion
	}
}
