﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Diagnostics;
using System.Windows.Forms;
using System.Reflection;

namespace SSTFEditor
{
	/// <summary>
	/// <para>StrokeStyle.Cスコア を柱とし、編集内容はこれに反映させるものとする。</para>
	/// <para>ファイルへの読み込み・保存は、SSTFormat.スコアのメソッドを流用する。</para>
	/// <para>SSTFEditorで必要な追加情報、随時このクラスに追加していくものとする。</para>
	/// </summary>
	class C譜面 : IDisposable
	{
		// 定数プロパティ

		public readonly Size szチップpx
			#region [ **** ]
			//-----------------
			= new Size( 30, 8 );
			//-----------------
			#endregion

		/// <summary>
		/// <para>C編集モードのコンストラクタでも参照されるので、登録ルールに注意すること。</para>
		/// <para>登録ルール → 同一レーンについて、最初によく使うチップを、２番目にトグルで２番目によく使うチップを登録する。</para>
		/// </summary>
		public readonly Dictionary<SSTFormat.チップ種別, 編集レーン種別> dicチップ編集レーン対応表
			#region [ **** ]
			//-----------------
			= new Dictionary<SSTFormat.チップ種別, 編集レーン種別>() {
				{ SSTFormat.チップ種別.BPM, 編集レーン種別.BPM },
				{ SSTFormat.チップ種別.LeftCrash, 編集レーン種別.左シンバル },
				{ SSTFormat.チップ種別.HiHat_Close, 編集レーン種別.ハイハット },
				{ SSTFormat.チップ種別.HiHat_Open, 編集レーン種別.ハイハット },
				{ SSTFormat.チップ種別.HiHat_HalfOpen, 編集レーン種別.ハイハット },
				{ SSTFormat.チップ種別.HiHat_Foot, 編集レーン種別.ハイハット },
				{ SSTFormat.チップ種別.Snare, 編集レーン種別.スネア },
				{ SSTFormat.チップ種別.Snare_Ghost, 編集レーン種別.スネア },
				{ SSTFormat.チップ種別.Snare_ClosedRim, 編集レーン種別.スネア },
				{ SSTFormat.チップ種別.Snare_OpenRim, 編集レーン種別.スネア },
				{ SSTFormat.チップ種別.Tom1, 編集レーン種別.ハイタム },
				{ SSTFormat.チップ種別.Tom1_Rim, 編集レーン種別.ハイタム },
				{ SSTFormat.チップ種別.Bass, 編集レーン種別.バス },
				{ SSTFormat.チップ種別.Tom2, 編集レーン種別.ロータム },
				{ SSTFormat.チップ種別.Tom2_Rim, 編集レーン種別.ロータム },
				{ SSTFormat.チップ種別.Tom3, 編集レーン種別.フロアタム },
				{ SSTFormat.チップ種別.Tom3_Rim, 編集レーン種別.フロアタム },
				{ SSTFormat.チップ種別.RightCrash, 編集レーン種別.右シンバル },
				{ SSTFormat.チップ種別.Ride, 編集レーン種別.右シンバル },			// 右側で固定とする
				{ SSTFormat.チップ種別.Ride_Cup, 編集レーン種別.右シンバル },		//
				{ SSTFormat.チップ種別.China, 編集レーン種別.右シンバル },			//
				{ SSTFormat.チップ種別.Splash, 編集レーン種別.右シンバル },			//
				{ SSTFormat.チップ種別.背景動画, 編集レーン種別.背景動画 },
				{ SSTFormat.チップ種別.小節線, 編集レーン種別.Unknown },
				{ SSTFormat.チップ種別.拍線, 編集レーン種別.Unknown },
				{ SSTFormat.チップ種別.小節メモ, 編集レーン種別.Unknown },
				{ SSTFormat.チップ種別.Unknown, 編集レーン種別.Unknown },
			};
			//-----------------
			#endregion

		public readonly Dictionary<編集レーン種別, int> dicレーン番号 
			#region [ **** ]
			//-----------------
			= new Dictionary<編集レーン種別, int>() {
				{ 編集レーン種別.BPM, 0 },
				{ 編集レーン種別.左シンバル, 1 },
				{ 編集レーン種別.ハイハット, 2 },
				{ 編集レーン種別.スネア, 3 },
				{ 編集レーン種別.ハイタム, 4 },
				{ 編集レーン種別.バス, 5 },
				{ 編集レーン種別.ロータム, 6 },
				{ 編集レーン種別.フロアタム, 7 },
				{ 編集レーン種別.右シンバル, 8 },
				{ 編集レーン種別.背景動画, 9 },
				{ 編集レーン種別.Unknown, -1 },
			};
			//-----------------
			#endregion

		public readonly Dictionary<int, 編集レーン種別> dicレーン番号逆引き
			#region [ **** ]
			//-----------------
			= new Dictionary<int, 編集レーン種別>();	// 初期化はコンストラクタ内で。
			//-----------------
			#endregion


		// プロパティ

		public SSTFormat.スコア SSTFormatScore;
		public int 現在の譜面表示下辺の譜面内絶対位置grid
		{
			get;
			set;
		}
		public int 現在のカレントラインの譜面内絶対位置grid
		{
			get
			{
				return this.現在の譜面表示下辺の譜面内絶対位置grid + ( 230 * this.Form.GRID_PER_PIXEL );	// 譜面拡大率によらず、大体下辺から -230 pixel くらいで。
			}
		}
		public int 全小節の高さgrid
		{
			get
			{
				int n高さgrid = 0;

				for( int i = 0; i <= this.SSTFormatScore.最大小節番号; i++ )
					n高さgrid += this.t小節長をグリッドで返す( i );

				return n高さgrid;
			}
		}
		public int レーンの合計幅px
		{
			get 
			{
				return ( Enum.GetValues( typeof( 編集レーン種別 ) ).Length - 1 ) * this.szチップpx.Width;	// -1 は Unknown の分
			}
		}
		public int 現在譜面表示下辺に存在している小節番号
		{
			get
			{
				int dummy;
				return this.譜面内絶対位置gridにおける小節の番号と小節先頭の位置gridを返す( this.現在の譜面表示下辺の譜面内絶対位置grid, out dummy );
			}
		}
		public int n現在カレントラインに存在している小節番号
		{
			get
			{
				int dummy;
				return this.譜面内絶対位置gridにおける小節の番号と小節先頭の位置gridを返す( this.現在のカレントラインの譜面内絶対位置grid, out dummy );
			}
		}
		
		// メソッド

		public C譜面( メインフォーム form )
		{
			this.Form = form;

			// 初期化

			this.SSTFormatScore = new SSTFormat.スコア();
			this.現在の譜面表示下辺の譜面内絶対位置grid = 0;
			foreach( var kvp in this.dicレーン番号 )
				this.dicレーン番号逆引き.Add( kvp.Value, kvp.Key );

			#region [ 最初は10小節ほど用意しておく → 10小節目の先頭に Unknown チップを置くことで実現。]
			//-----------------
			this.SSTFormatScore.listチップ.Add(
				new SSTFormat.チップ()
				{
					チップ種別 = SSTFormat.チップ種別.Unknown,
					小節番号 = 9,											// 0から数えて10番目の小節 = 009
					小節解像度 = 1,
					小節内位置 = 0,
					譜面内絶対位置grid = 9 * this.Form.GRID_PER_PART,		// 小節009の先頭位置
				} );
			//-----------------
			#endregion
		}

		public void 曲データファイルを読み込む( string strファイル名 )
		{
			// 解放

			FDK.Utilities.解放する( ref this.SSTFormatScore );


			// 読み込み

			#region [ ファイルを読み込んで Score を構築する。]
			//-----------------
			string str拡張子 = Path.GetExtension( strファイル名 ).ToLower();

			if( str拡張子 == ".sstf" )
			{
				this.SSTFormatScore = new SSTFormat.スコア();
				this.SSTFormatScore.t曲データファイルを読み込む( strファイル名 );
			}
			//else if( str拡張子 == ".dtx" )
			//{
			//	var dr = new SSTFormat.スコア();
			//	this.Score = dr.tDTXファイルを読み込む( strファイル名 );
			//}
			else
			{
				throw new InvalidDataException( "対応していないファイルです。" );
			}
			//-----------------
			#endregion


			// 後処理

			#region [ 小節線・拍線チップをすべて削除する。]
			//-----------------
			this.SSTFormatScore.listチップ.RemoveAll(
				( chip ) => { return chip.チップ種別 == SSTFormat.チップ種別.小節線 || chip.チップ種別 == SSTFormat.チップ種別.拍線 || chip.チップ種別 == SSTFormat.チップ種別.Unknown; } );
			//-----------------
			#endregion
			#region [ 全チップに対して「n譜面内絶対位置grid」を設定する。]
			//-----------------
			int nチップが存在する小節の先頭grid = 0;
			int n現在の小節番号 = 0;

			foreach( SSTFormat.チップ chip in this.SSTFormatScore.listチップ )
			{
				#region [ チップの小節番号が現在の小節番号よりも大きい場合、チップが存在する小節に至るまで、「nチップが存在する小節の先頭grid」を更新する。]
				//-----------------
				while( n現在の小節番号 < chip.小節番号 )
				{
					double db現在の小節の小節長倍率 = this.SSTFormatScore.小節長倍率を取得する( n現在の小節番号 );
					nチップが存在する小節の先頭grid += (int) ( this.Form.GRID_PER_PART * db現在の小節の小節長倍率 );

					n現在の小節番号++;	// n現在の小節番号 が chip.n小節番号 に追いつくまでループする。
				}
				//-----------------
				#endregion

				chip.譜面内絶対位置grid = nチップが存在する小節の先頭grid + ( ( chip.小節内位置 * this.t小節長をグリッドで返す( chip.小節番号 ) ) / chip.小節解像度 );
			}
			//-----------------
			#endregion
		}
		public void SSTFファイルを書き出す( string strファイル名, string ヘッダ行 )
		{
			this.SSTFormatScore.t曲データファイルを書き出す( strファイル名, $"{ヘッダ行}{Environment.NewLine}" );
		}

		public void 描画する( Graphics g, Control panel )
		{
			#region [ panel のレーン背景画像が未作成なら作成する。]
			//-----------------
			if( panel.BackgroundImage == null )
			{
				this.bmp譜面パネル背景 = new Bitmap( this.レーンの合計幅px, 1 );
				using( var graphics = Graphics.FromImage( this.bmp譜面パネル背景 ) )
				{
					int x = 0;
					foreach( var kvp in this.dicレーン背景色 )
					{
						using( var brush = new SolidBrush( kvp.Value ) )
							graphics.FillRectangle( brush, x, 0, this.szチップpx.Width, 1 );

						x += this.szチップpx.Width;
					}
				}

				panel.Width = レーンの合計幅px;
				panel.BackgroundImage = this.bmp譜面パネル背景;
				panel.BackgroundImageLayout = ImageLayout.Tile;
			}
			//-----------------
			#endregion

			int n小節先頭の譜面内絶対位置grid = 0;
			int nパネル下辺の譜面内絶対位置grid = this.現在の譜面表示下辺の譜面内絶対位置grid;
			int nパネル上辺の譜面内絶対位置grid = nパネル下辺の譜面内絶対位置grid + ( panel.ClientSize.Height * this.Form.GRID_PER_PIXEL );

			#region [ 小節番号・ガイド線・拍線・レーン区分線・小節線を描画。]
			//-----------------
			for( int n小節番号 = 0; n小節番号 <= this.SSTFormatScore.最大小節番号; n小節番号++ )
			{
				int n次の小節の先頭位置	= n小節先頭の譜面内絶対位置grid + this.t小節長をグリッドで返す( n小節番号 );
				Rectangle rc小節の描画領域;

				#region [ クリッピングと rc小節の描画領域 の取得。小節が描画領域上端を超えたら終了。]
				//-----------------
				#region [ (A) 小節の描画領域が、パネルの領域外（下）にある場合。→ この小節は無視して次の小節へ。]
				//-----------------
				if( n次の小節の先頭位置 < nパネル下辺の譜面内絶対位置grid )
				{
					n小節先頭の譜面内絶対位置grid = n次の小節の先頭位置;
					continue;
				}
				//-----------------
				#endregion
				#region [ (B) 小節の描画領域が、パネルの領域外（上）にある場合。→ ここで描画終了。]
				//-----------------
				else if( n小節先頭の譜面内絶対位置grid >= nパネル上辺の譜面内絶対位置grid )
				{
					break;
				}
				//-----------------
				#endregion
				#region [ (C) 小節の描画領域が、パネル内にすべて収まっている場合。]
				//-----------------
				else if( n小節先頭の譜面内絶対位置grid >= nパネル下辺の譜面内絶対位置grid && n次の小節の先頭位置 < nパネル上辺の譜面内絶対位置grid )
				{
					rc小節の描画領域 = new Rectangle() {
						X = 0,
						Width = panel.ClientSize.Width,
						Y = ( nパネル上辺の譜面内絶対位置grid - n次の小節の先頭位置 ) / this.Form.GRID_PER_PIXEL,
						Height = ( n次の小節の先頭位置 - n小節先頭の譜面内絶対位置grid ) / this.Form.GRID_PER_PIXEL,
					};
				}
				//-----------------
				#endregion
				#region [ (D) 小節の描画領域が、パネルをすべて包み込んでいる場合。]
				//-----------------
				else if( n小節先頭の譜面内絶対位置grid < nパネル下辺の譜面内絶対位置grid && n次の小節の先頭位置 >= nパネル上辺の譜面内絶対位置grid )
				{
					rc小節の描画領域 = new Rectangle() {
						X = 0,
						Width = panel.ClientSize.Width,
						Y = ( nパネル上辺の譜面内絶対位置grid - n次の小節の先頭位置 ) / this.Form.GRID_PER_PIXEL,
						Height = ( n次の小節の先頭位置 - n小節先頭の譜面内絶対位置grid ) / this.Form.GRID_PER_PIXEL,
					};
				}
				//-----------------
				#endregion
				#region [ (E) 小節の描画領域が、パネルの下側にはみだしている場合。]
				//-----------------
				else if( n小節先頭の譜面内絶対位置grid < nパネル下辺の譜面内絶対位置grid )
				{
					rc小節の描画領域 = new Rectangle() {
						X = 0,
						Width = panel.ClientSize.Width,
						Y = ( nパネル上辺の譜面内絶対位置grid - n次の小節の先頭位置 ) / this.Form.GRID_PER_PIXEL,
						Height = ( n次の小節の先頭位置 - n小節先頭の譜面内絶対位置grid ) / this.Form.GRID_PER_PIXEL,
					};
				}
				//-----------------
				#endregion
				#region [ (F) 小節の描画領域が、パネルの上側にはみだしている場合。]
				//-----------------
				else
				{
					rc小節の描画領域 = new Rectangle() {
						X = 0,
						Width = panel.ClientSize.Width,
						Y = ( nパネル上辺の譜面内絶対位置grid - n次の小節の先頭位置 ) / this.Form.GRID_PER_PIXEL,
						Height = ( n次の小節の先頭位置 - n小節先頭の譜面内絶対位置grid ) / this.Form.GRID_PER_PIXEL,
					};
				}
				//-----------------
				#endregion

				//-----------------
				#endregion

				#region [ 小節番号を描画。]
				//-----------------
				g.DrawString(
					n小節番号.ToString( "000" ),
					this.font小節番号文字,
					this.brush小節番号文字,
					rc小節の描画領域,
					this.strfmt小節番号文字 );
				//-----------------
				#endregion
				#region [ ガイド線を描画。]
				//-----------------
				this.t譜面に定間隔で線を描画する( g, n小節番号, rc小節の描画領域, this.n現在のガイド間隔grid, this.penガイド線 );
				//-----------------
				#endregion
				#region [ 拍線を描画。]
				//-----------------
				this.t譜面に定間隔で線を描画する( g, n小節番号, rc小節の描画領域, this.Form.GRID_PER_PART / 4, this.pen拍線 );
				//-----------------
				#endregion
				#region [ レーン区分線を描画。]
				//-----------------
				{
					int x = 0;

					int num = Enum.GetValues( typeof( 編集レーン種別 ) ).Length - 1;	// -1 は Unknown の分
					for( int i = 0; i < num; i++ )
					{
						x += this.szチップpx.Width;

						if( x >= rc小節の描画領域.Width )
							x = rc小節の描画領域.Width - 1;

						g.DrawLine(
							( i == 0 || i == num - 2 ) ? this.penレーン区分線太 : this.penレーン区分線,
							x,
							rc小節の描画領域.Top,
							x,
							rc小節の描画領域.Bottom );
					}
				}
				//-----------------
				#endregion
				#region [ 小節線を描画。]
				//-----------------
				this.t譜面に定間隔で線を描画する( g, n小節番号, rc小節の描画領域, this.Form.GRID_PER_PART, this.pen小節線 );
				//-----------------
				#endregion


				// 次の小節へ。

				n小節先頭の譜面内絶対位置grid = n次の小節の先頭位置;
			}
			//-----------------
			#endregion

			#region [ チップを描画。]
			//-----------------
			var rcチップ描画領域 = new Rectangle();
			foreach( var chip in this.SSTFormatScore.listチップ )
			{
				#region [ クリッピング ]
				//-----------------
				if( chip.チップ種別 == SSTFormat.チップ種別.Unknown )
					continue;	// 描画対象外

				if( chip.枠外レーン数 != 0 )
					continue;	// 描画範囲外

				if( chip.譜面内絶対位置grid < nパネル下辺の譜面内絶対位置grid )
					continue;	// 描画範囲外（次のチップへ）

				if( chip.譜面内絶対位置grid >= nパネル上辺の譜面内絶対位置grid )
					break;		// 描画範囲外（ここで終了）
				//-----------------
				#endregion

				#region [ rcチップ描画領域 更新。]
				//-----------------
				int nレーン番号 = this.dicレーン番号[ this.dicチップ編集レーン対応表[ chip.チップ種別 ] ];

				rcチップ描画領域.X = nレーン番号 * this.szチップpx.Width;
				rcチップ描画領域.Y = panel.ClientSize.Height - ( chip.譜面内絶対位置grid - this.現在の譜面表示下辺の譜面内絶対位置grid ) / this.Form.GRID_PER_PIXEL - this.szチップpx.Height;
				rcチップ描画領域.Width = this.szチップpx.Width;
				rcチップ描画領域.Height = this.szチップpx.Height;
				//-----------------
				#endregion

				this.tチップを指定領域へ描画する( g, chip.チップ種別, chip.音量, rcチップ描画領域, chip.チップ内文字列 );


				// 選択中なら太枠を付与。

				if( chip.ドラッグ操作により選択中である || chip.選択が確定している )
					this.tチップの太枠を指定領域へ描画する( g, rcチップ描画領域 );
			}
			//-----------------
			#endregion

			#region [ レーン名を描画。 ]
			//-----------------
			var rcレーン名描画領域下側 = new Rectangle( 0, 10, panel.Width, C譜面.nレーン番号表示高さpx );
			var rcレーン名描画領域上側 = new Rectangle( 0, 0, panel.Width, 10 );


			// グラデーション描画。

			using( var brush = new LinearGradientBrush( rcレーン名描画領域下側, Color.FromArgb( 255, 50, 155, 50 ), Color.FromArgb( 0, 0, 255, 0 ), LinearGradientMode.Vertical ) )
				g.FillRectangle( brush, rcレーン名描画領域下側 );

			using( var brush = new LinearGradientBrush( rcレーン名描画領域上側, Color.FromArgb( 255, 0, 100, 0 ), Color.FromArgb( 255, 50, 155, 50 ), LinearGradientMode.Vertical ) )
				g.FillRectangle( brush, rcレーン名描画領域上側 );


			// レーン名を描画。

			var rcレーン名描画領域 = new Rectangle( 0, 0, 0, 0 );

			foreach( var obj in Enum.GetValues( typeof( 編集レーン種別 ) ) )
			{
				var e編集レーン = (編集レーン種別) obj;

				if( e編集レーン == 編集レーン種別.Unknown )
					break;

				rcレーン名描画領域.X = rcレーン名描画領域下側.X + ( this.dicレーン番号[ e編集レーン ] * this.szチップpx.Width ) + 2;
				rcレーン名描画領域.Y = rcレーン名描画領域下側.Y + 2;
				rcレーン名描画領域.Width = this.szチップpx.Width;
				rcレーン名描画領域.Height = 24;

				g.DrawString(
					this.dicレーン名[ e編集レーン ],
					this.fontレーン名文字,
					this.brushレーン名文字影,
					rcレーン名描画領域,
					this.strfmtレーン名文字 );

				rcレーン名描画領域.X -= 2;
				rcレーン名描画領域.Y -= 2;

				g.DrawString(
					this.dicレーン名[ e編集レーン ],
					this.fontレーン名文字,
					this.brushレーン名文字,
					rcレーン名描画領域,
					this.strfmtレーン名文字 );
			}
			//-----------------
			#endregion

			#region [ カレントラインを描画。]
			//-----------------
			float y = panel.Size.Height - ( (float) ( this.現在のカレントラインの譜面内絶対位置grid - this.現在の譜面表示下辺の譜面内絶対位置grid ) / (float) this.Form.GRID_PER_PIXEL );

			g.DrawLine(
				this.penカレントライン,
				0.0f,
				y,
				(float) (panel.Size.Width - 1 ),
				y );
			//-----------------
			#endregion

		}
		public void tチップを指定領域へ描画する( Graphics g, SSTFormat.チップ種別 eチップ, int n音量, Rectangle rcチップ描画領域, string strチップ内文字列 )
		{
			// ※Cチップの描画以外の目的でも呼ばれるため、本メソッドの引数には Cチップ を入れていない。

			switch( eチップ )
			{
				case SSTFormat.チップ種別.BPM:
				case SSTFormat.チップ種別.LeftCrash:
				case SSTFormat.チップ種別.HiHat_Close:
				case SSTFormat.チップ種別.Snare:
				case SSTFormat.チップ種別.Tom1:
				case SSTFormat.チップ種別.Bass:
				case SSTFormat.チップ種別.Tom2:
				case SSTFormat.チップ種別.Tom3:
				case SSTFormat.チップ種別.RightCrash:
				case SSTFormat.チップ種別.China:
				case SSTFormat.チップ種別.Splash:
				case SSTFormat.チップ種別.背景動画:
					this.tチップを描画する_通常( g, eチップ, n音量, rcチップ描画領域, strチップ内文字列 );
					break;

				case SSTFormat.チップ種別.Snare_Ghost:
					this.tチップを描画する_小丸( g, eチップ, n音量, rcチップ描画領域, strチップ内文字列 );
					break;

				case SSTFormat.チップ種別.Ride:
					this.tチップを描画する_幅狭( g, eチップ, n音量, rcチップ描画領域, strチップ内文字列 );
					break;

				case SSTFormat.チップ種別.Snare_OpenRim:
				case SSTFormat.チップ種別.HiHat_Open:
					this.tチップを描画する_幅狭白丸( g, eチップ, n音量, rcチップ描画領域, strチップ内文字列 );
					break;

				case SSTFormat.チップ種別.HiHat_HalfOpen:
				case SSTFormat.チップ種別.Ride_Cup:
					this.tチップを描画する_幅狭白狭丸( g, eチップ, n音量, rcチップ描画領域, strチップ内文字列 );
					break;

				case SSTFormat.チップ種別.HiHat_Foot:
				case SSTFormat.チップ種別.Snare_ClosedRim:
				case SSTFormat.チップ種別.Tom1_Rim:
				case SSTFormat.チップ種別.Tom2_Rim:
				case SSTFormat.チップ種別.Tom3_Rim:
					this.tチップを描画する_幅狭白バツ( g, eチップ, n音量, rcチップ描画領域, strチップ内文字列 );
					break;
			}
		}
		public void tチップの太枠を指定領域へ描画する( Graphics g, Rectangle rcチップ描画領域 )
		{
			g.DrawRectangle( this.penチップの太枠, rcチップ描画領域 );
		}

		public int 小節先頭の譜面内絶対位置gridを返す( int n小節番号 )
		{
			#region [ 事前チェック。]
			//-----------------
			if( n小節番号 < 0 )
				throw new ArgumentOutOfRangeException( "小節番号に負数が指定されました。" );
			//-----------------
			#endregion

			int n高さgrid = 0;

			for( int i = 0; i < n小節番号; i++ )
				n高さgrid += this.t小節長をグリッドで返す( i );

			return n高さgrid;
		}
		public 編集レーン種別 譜面パネル内X座標pxにある編集レーンを返す( int n譜面パネル内X座標px )
		{
			int nレーン番号 = n譜面パネル内X座標px / this.szチップpx.Width;

			foreach( var kvp in this.dicレーン番号 )
			{
				if( kvp.Value == nレーン番号 )
					return kvp.Key;
			}

			return 編集レーン種別.Unknown;
		}
		public int t編集レーンのX座標pxを返す( 編集レーン種別 lane )
		{
			if( lane == 編集レーン種別.Unknown )
				return -1;

			return this.dicレーン番号[ lane ] * this.szチップpx.Width;
		}
		public int 譜面パネル内Y座標pxにおける小節番号を返す( int n譜面パネル内Y座標px )
		{
			int dummy = 0;
			int n小節番号 = this.t譜面パネル内Y座標pxにおける小節番号とその小節の譜面内絶対位置gridを返す( n譜面パネル内Y座標px, out dummy );
			return n小節番号;
		}
		public int t譜面パネル内Y座標pxにおける小節の譜面内絶対位置gridを返す( int n譜面パネル内Y座標px )
		{
			int n小節の譜面内絶対位置grid = 0;
			this.t譜面パネル内Y座標pxにおける小節番号とその小節の譜面内絶対位置gridを返す( n譜面パネル内Y座標px, out n小節の譜面内絶対位置grid );
			return n小節の譜面内絶対位置grid;
		}
		public int t譜面パネル内Y座標pxにおける小節番号とその小節の譜面内絶対位置gridを返す( int n譜面パネル内Y座標px, out int n小節の譜面内絶対位置grid )
		{
			int n譜面パネル内Y座標に対応する譜面内絶対位置grid = 
				this.現在の譜面表示下辺の譜面内絶対位置grid + ( this.Form.譜面パネルサイズ.Height - n譜面パネル内Y座標px ) * this.Form.GRID_PER_PIXEL;

			if( n譜面パネル内Y座標に対応する譜面内絶対位置grid < 0 )
			{
				n小節の譜面内絶対位置grid = -1;
				return -1;
			}

			int n現在の小節の先頭までの長さgrid = 0;
			int n次の小節の先頭までの長さgrid = 0;

			int i = 0;
			while( true )	// 最大小節番号を超えてどこまでもチェック。
			{
				double db小節長倍率 = this.SSTFormatScore.小節長倍率を取得する( i );

				n現在の小節の先頭までの長さgrid = n次の小節の先頭までの長さgrid;
				n次の小節の先頭までの長さgrid += (int) ( this.Form.GRID_PER_PART * db小節長倍率 );

				if( n譜面パネル内Y座標に対応する譜面内絶対位置grid < n次の小節の先頭までの長さgrid )
				{
					n小節の譜面内絶対位置grid = n現在の小節の先頭までの長さgrid;
					return i;
				}
				i++;
			}
		}
		public int t譜面パネル内Y座標pxにおける譜面内絶対位置gridを返す( int n譜面パネル内Y座標px )
		{
			int n譜面パネル底辺からの高さpx = this.Form.譜面パネルサイズ.Height - n譜面パネル内Y座標px;

			return this.現在の譜面表示下辺の譜面内絶対位置grid + ( n譜面パネル底辺からの高さpx * this.Form.GRID_PER_PIXEL );
		}
		public int 譜面パネル内Y座標pxにおける譜面内絶対位置gridをガイド幅単位で返す( int n譜面パネル内Y座標px )
		{
			int n最高解像度での譜面内絶対位置grid = this.t譜面パネル内Y座標pxにおける譜面内絶対位置gridを返す( n譜面パネル内Y座標px );
			int n対応する小節の譜面内絶対位置grid = this.t譜面パネル内Y座標pxにおける小節の譜面内絶対位置gridを返す( n譜面パネル内Y座標px );

			int n対応する小節の小節先頭からの相対位置grid =
				( ( n最高解像度での譜面内絶対位置grid - n対応する小節の譜面内絶対位置grid ) / this.n現在のガイド間隔grid ) * this.n現在のガイド間隔grid;

			return n対応する小節の譜面内絶対位置grid + n対応する小節の小節先頭からの相対位置grid;
		}
		public int t譜面内絶対位置gridにおける対象領域内のY座標pxを返す( int n譜面内絶対位置grid, Size sz対象領域px )
		{
			int n対象領域内の高さgrid = n譜面内絶対位置grid - this.現在の譜面表示下辺の譜面内絶対位置grid;

			return ( sz対象領域px.Height - ( n対象領域内の高さgrid / this.Form.GRID_PER_PIXEL ) );
		}
		public int 譜面内絶対位置gridにおける小節の番号と小節先頭の位置gridを返す( int n譜面内絶対位置grid, out int n位置grid )
		{
			n位置grid = -1;

			if( n譜面内絶対位置grid < 0 )
				throw new ArgumentOutOfRangeException( "n譜面内絶対位置grid が負数です。" );

			int n = 0;
			int nBack = 0;

			int i = 0;
			while( true )		// 最大譜面番号を超えてどこまでもチェック。
			{
				nBack = n;
				n += this.t小節長をグリッドで返す( i );

				if( n譜面内絶対位置grid < n )
				{
					n位置grid = nBack;
					return i;
				}

				i++;
			}
		}
		public double db譜面内絶対位置gridにおけるBPMを返す( int n譜面内絶対位置grid )
		{
			double bpm = SSTFormat.スコア.db初期BPM;

			foreach( var chip in this.SSTFormatScore.listチップ )
			{
				if( chip.譜面内絶対位置grid > n譜面内絶対位置grid )
					break;

				if( chip.チップ種別 == SSTFormat.チップ種別.BPM )
					bpm = chip.BPM;
			}

			return bpm;
		}
		public SSTFormat.チップ t譜面パネル内座標pxに存在するチップがあれば返す( int x, int y )
		{
			var e座標の編集レーン = this.譜面パネル内X座標pxにある編集レーンを返す( x );
			if( e座標の編集レーン == 編集レーン種別.Unknown )
				return null;
			int n座標の譜面内絶対位置grid = this.t譜面パネル内Y座標pxにおける譜面内絶対位置gridを返す( y );
			int nチップの厚さgrid = this.szチップpx.Height * this.Form.GRID_PER_PIXEL;

			foreach( var chip in this.SSTFormatScore.listチップ )
			{
				if( this.dicチップ編集レーン対応表[ chip.チップ種別 ] == e座標の編集レーン &&
					n座標の譜面内絶対位置grid >= chip.譜面内絶対位置grid &&
					n座標の譜面内絶対位置grid < chip.譜面内絶対位置grid + nチップの厚さgrid )
				{
					return chip;
				}
			}

			return null;
		}
		public int t小節長をグリッドで返す( int n小節番号 )
		{
			double dbこの小節の倍率 = this.SSTFormatScore.小節長倍率を取得する( n小節番号 );
			return (int) ( this.Form.GRID_PER_PART * dbこの小節の倍率 );
		}

		public void 現在のガイド間隔を変更する( int n分 )
		{
			this.n現在のガイド間隔grid = ( n分 == 0 ) ? 1 : ( this.Form.GRID_PER_PART / n分 );
		}
		public void tチップを配置または置換する( 編集レーン種別 e編集レーン, SSTFormat.チップ種別 eチップ, int n譜面内絶対位置grid, string strチップ文字列, int n音量, double dbBPM, bool b選択確定中 )
		{
			this.Form.UndoRedo管理.トランザクション記録を開始する();

			#region [ 配置位置にチップがあれば削除する。]
			//-----------------
			this.tチップを削除する( e編集レーン, n譜面内絶対位置grid );	// そこにチップがなければ何もしない。
			//-----------------
			#endregion
			#region [ 新しいチップを作成し配置する。]
			//-----------------
			
			int n小節先頭位置grid;
			int n小節番号 = this.譜面内絶対位置gridにおける小節の番号と小節先頭の位置gridを返す( n譜面内絶対位置grid, out n小節先頭位置grid );
			int n小節の長さgrid = this.t小節長をグリッドで返す( n小節番号 );

			var chip = new SSTFormat.チップ()
			{
				ヒット済みである = false,		// SSTFEditorでは使わない
				可視 = true,			// SSTFEditorでは使わない
				選択が確定している = b選択確定中,
				BPM = dbBPM,
				発声時刻ms = 0,		// SSTFEditorでは使わない
				チップ種別 = eチップ,
				音量 = n音量,
				小節解像度 = n小節の長さgrid,
				小節内位置 = n譜面内絶対位置grid - n小節先頭位置grid,
				小節番号 = n小節番号,
				譜面内絶対位置grid = n譜面内絶対位置grid,
				チップ内文字列 = strチップ文字列,
			};


			// チップを譜面に追加。

			var chip変更前 = new SSTFormat.チップ( chip );
			var cell = new UndoRedo.セル<SSTFormat.チップ>(
				null,
				( 変更対象, 変更前, 変更後, 任意1, 任意2 ) => {	// Undo
					this.SSTFormatScore.listチップ.Remove( 変更対象 );
					this.Form.未保存である = true;
				},
				( 変更対象, 変更前, 変更後, 任意1, 任意2 ) => {	// Redo
					変更対象.CopyFrom( 変更前 );
					this.SSTFormatScore.listチップ.Add( 変更対象 );
					this.SSTFormatScore.listチップ.Sort();
					this.Form.未保存である = true;
				},
				chip, chip変更前, null, null, null );

			this.Form.UndoRedo管理.セルを追加する( cell );
			cell.Redoを実行する();
			//-----------------
			#endregion
			#region [ 配置した小節が現状最後の小節だったら、後ろに小節を４つ追加する。]
			//-----------------
			if( chip.小節番号 == this.SSTFormatScore.最大小節番号 )
			{
				this.t最後の小節の後ろに小節を４つ追加する();
			}
			//-----------------
			#endregion

			this.Form.UndoRedo管理.トランザクション記録を終了する();
			this.Form.UndoRedo用GUIのEnabledを設定する();
			this.Form.未保存である = true;
		}
		public void tチップを削除する( 編集レーン種別 e編集レーン, int n譜面内絶対位置grid )
		{
			for( int i = 0; i < this.SSTFormatScore.listチップ.Count; i++ )
			{
				var chip = this.SSTFormatScore.listチップ[ i ];


				// 条件チェック。

				if( this.dicチップ編集レーン対応表[ chip.チップ種別 ] != e編集レーン )
					continue;

				if( chip.譜面内絶対位置grid != n譜面内絶対位置grid )
					continue;


				// UndoRedo セルを登録。

				var chip変更前 = new SSTFormat.チップ( chip );
				var cc = new UndoRedo.セル<SSTFormat.チップ>(
					null,
					( 変更対象, 変更前, 変更後, 任意1, 任意2 ) => {	// Undo
						変更対象.CopyFrom( 変更前 );
						this.SSTFormatScore.listチップ.Add( 変更対象 );
						this.SSTFormatScore.listチップ.Sort();
						this.Form.未保存である = true;
					},
					( 変更対象, 変更前, 変更後, 任意1, 任意2 ) => {	// Redo
						this.SSTFormatScore.listチップ.Remove( 変更対象 );
						this.Form.未保存である = true;
					},
					chip, chip変更前, null, null, null );

				this.Form.UndoRedo管理.セルを追加する( cc );
				cc.Redoを実行する();


				// 完了。

				this.Form.UndoRedo用GUIのEnabledを設定する();
				break;	// 削除するのは１つだけ。
			}
		}
		public void t最後の小節の後ろに小節を４つ追加する()
		{
			// 最終小節の小節先頭位置grid と 小節長倍率 を取得する。

			int n小節先頭位置grid = this.小節先頭の譜面内絶対位置gridを返す( this.SSTFormatScore.最大小節番号 );
			int n小節の長さgrid = this.t小節長をグリッドで返す( this.SSTFormatScore.最大小節番号 );
			double db最終小節の小節長倍率 = this.SSTFormatScore.小節長倍率を取得する( this.SSTFormatScore.最大小節番号 );


			// ダミーで置いた Unknown チップがあれば削除する。

			int n最大小節番号の控え = this.SSTFormatScore.最大小節番号;		// ダミーが削除されたら最大小節番号が減ってしまう場合がある。
			this.tチップを削除する( 編集レーン種別.Unknown, n小節先頭位置grid );


			// 新しくダミーの Unknown チップを、最終小節番号の控え＋４の小節の先頭に置く。

			var dummyChip = new SSTFormat.チップ() {
				チップ種別 = SSTFormat.チップ種別.Unknown,
				小節番号 = n最大小節番号の控え + 4,
				小節解像度 = 1,
				小節内位置 = 0,
				譜面内絶対位置grid = n小節先頭位置grid + n小節の長さgrid + ( this.Form.GRID_PER_PART * 3 ),
			};

			var chip変更後 = new SSTFormat.チップ( dummyChip );
			var cc = new UndoRedo.セル<SSTFormat.チップ>(
				null,
				( 変更対象, 変更前, 変更後, 小節長倍率, 任意2 ) => {	// Undo
					this.SSTFormatScore.listチップ.Remove( 変更対象 );
					for( int i = 0; i < 4; i++ )
						this.SSTFormatScore.list小節長倍率.RemoveAt( 変更後.小節番号 - 3 );
				},
				( 変更対象, 変更前, 変更後, 小節長倍率, 任意2 ) => {	// Redo
					変更対象.CopyFrom( 変更後 );
					this.SSTFormatScore.listチップ.Add( 変更対象 );
					this.SSTFormatScore.listチップ.Sort();
					if( (double) 小節長倍率 != 1.0 )	// 増設した４つの小節の小節長倍率を、最終小節の小節長倍率と同じにする。1.0 の場合は何もしない。
					{
						for( int i = 0; i < 4; i++ )
							this.SSTFormatScore.小節長倍率を設定する( 変更後.小節番号 - i, (double) 小節長倍率 );
					}
					this.Form.未保存である = true;
				},
				dummyChip, null, chip変更後, db最終小節の小節長倍率, null );

			this.Form.UndoRedo管理.セルを追加する( cc );
			cc.Redoを実行する();
		}

		#region [ IDisposable 実装 ]
		//-----------------
		public void Dispose()
		{
			FDK.Utilities.解放する( ref this.SSTFormatScore );
			FDK.Utilities.解放する( ref this.font小節番号文字 );
			FDK.Utilities.解放する( ref this.brush小節番号文字 );
			FDK.Utilities.解放する( ref this.strfmt小節番号文字 );
			FDK.Utilities.解放する( ref this.penガイド線 );
			FDK.Utilities.解放する( ref this.pen小節線 );
			FDK.Utilities.解放する( ref this.pen拍線 );
			FDK.Utilities.解放する( ref this.penレーン区分線 );
			FDK.Utilities.解放する( ref this.penレーン区分線太 );
			FDK.Utilities.解放する( ref this.penカレントライン );
			FDK.Utilities.解放する( ref this.fontレーン名文字 );
			FDK.Utilities.解放する( ref this.brushレーン名文字 );
			FDK.Utilities.解放する( ref this.brushレーン名文字影 );
			FDK.Utilities.解放する( ref this.strfmtレーン名文字 );
			FDK.Utilities.解放する( ref this.penチップの太枠 );
			FDK.Utilities.解放する( ref this.strfmtチップ内文字列 );
			FDK.Utilities.解放する( ref this.fontチップ内文字列 );
			FDK.Utilities.解放する( ref this.pen白丸白バツ );
		}
		//-----------------
		#endregion

		#region [ protected ]
		//-----------------
		protected メインフォーム Form;
		protected int n現在のガイド間隔grid = 0;

		// 定数プロパティ

		protected const int nレーン番号表示高さpx = 32;
		protected const int nチップ背景色透明度 = 192;
		protected const int nチップ明影透明度 = 255;
		protected const int nチップ暗影透明度 = 64;
		protected const int nレーン背景色透明度 = 25;

		protected readonly Dictionary<編集レーン種別, Color> dicレーン背景色
			#region [ **** ]
			//-----------------
			= new Dictionary<編集レーン種別, Color>() {
				{ 編集レーン種別.BPM, Color.FromArgb( nレーン背景色透明度, Color.SkyBlue ) },
				{ 編集レーン種別.左シンバル, Color.FromArgb( nレーン背景色透明度, Color.WhiteSmoke ) },
				{ 編集レーン種別.ハイハット, Color.FromArgb( nレーン背景色透明度, Color.SkyBlue ) },
				{ 編集レーン種別.スネア, Color.FromArgb( nレーン背景色透明度, Color.Orange ) },
				{ 編集レーン種別.ハイタム, Color.FromArgb( nレーン背景色透明度, Color.Lime ) },
				{ 編集レーン種別.バス, Color.FromArgb( nレーン背景色透明度, Color.Gainsboro) },
				{ 編集レーン種別.ロータム, Color.FromArgb( nレーン背景色透明度, Color.Red ) },
				{ 編集レーン種別.フロアタム, Color.FromArgb( nレーン背景色透明度, Color.Magenta ) },
				{ 編集レーン種別.右シンバル, Color.FromArgb( nレーン背景色透明度, Color.WhiteSmoke ) },
				{ 編集レーン種別.背景動画, Color.FromArgb( nレーン背景色透明度, Color.SkyBlue ) },
				{ 編集レーン種別.Unknown, Color.FromArgb( nレーン背景色透明度, Color.White ) },
			};
			//-----------------
			#endregion

		protected readonly Dictionary<SSTFormat.チップ種別, Color> dicチップ色対応表
			#region [ **** ]
			//-----------------
			= new Dictionary<SSTFormat.チップ種別, Color>() {
				{ SSTFormat.チップ種別.BPM, Color.FromArgb( nチップ背景色透明度, Color.SkyBlue ) },
				{ SSTFormat.チップ種別.LeftCrash, Color.FromArgb( nチップ背景色透明度, Color.WhiteSmoke ) },
				{ SSTFormat.チップ種別.HiHat_Close, Color.FromArgb( nチップ背景色透明度, Color.SkyBlue ) },
				{ SSTFormat.チップ種別.HiHat_Foot, Color.FromArgb( nチップ背景色透明度, Color.SkyBlue ) },
				{ SSTFormat.チップ種別.HiHat_HalfOpen, Color.FromArgb( nチップ背景色透明度, Color.SkyBlue ) },
				{ SSTFormat.チップ種別.HiHat_Open, Color.FromArgb( nチップ背景色透明度, Color.SkyBlue ) },
				{ SSTFormat.チップ種別.Snare, Color.FromArgb( nチップ背景色透明度, Color.Orange ) },
				{ SSTFormat.チップ種別.Snare_ClosedRim, Color.FromArgb( nチップ背景色透明度, Color.OrangeRed ) },
				{ SSTFormat.チップ種別.Snare_Ghost, Color.FromArgb( nチップ背景色透明度, Color.DeepPink ) },
				{ SSTFormat.チップ種別.Snare_OpenRim, Color.FromArgb( nチップ背景色透明度, Color.Orange ) },
				{ SSTFormat.チップ種別.Tom1, Color.FromArgb( nチップ背景色透明度, Color.Lime ) },
				{ SSTFormat.チップ種別.Tom1_Rim, Color.FromArgb( nチップ背景色透明度, Color.Lime ) },
				{ SSTFormat.チップ種別.Bass, Color.FromArgb( nチップ背景色透明度, Color.Gainsboro ) },
				{ SSTFormat.チップ種別.Tom2, Color.FromArgb( nチップ背景色透明度, Color.Red ) },
				{ SSTFormat.チップ種別.Tom2_Rim, Color.FromArgb( nチップ背景色透明度, Color.Red ) },
				{ SSTFormat.チップ種別.Tom3, Color.FromArgb( nチップ背景色透明度, Color.Magenta ) },
				{ SSTFormat.チップ種別.Tom3_Rim, Color.FromArgb( nチップ背景色透明度, Color.Magenta ) },
				{ SSTFormat.チップ種別.RightCrash, Color.FromArgb( nチップ背景色透明度, Color.WhiteSmoke ) },
				{ SSTFormat.チップ種別.Ride, Color.FromArgb( nチップ背景色透明度, Color.WhiteSmoke ) },
				{ SSTFormat.チップ種別.Ride_Cup, Color.FromArgb( nチップ背景色透明度, Color.WhiteSmoke ) },
				{ SSTFormat.チップ種別.China, Color.FromArgb( nチップ背景色透明度, Color.WhiteSmoke ) },
				{ SSTFormat.チップ種別.Splash, Color.FromArgb( nチップ背景色透明度, Color.WhiteSmoke ) },
				{ SSTFormat.チップ種別.背景動画, Color.FromArgb( nチップ背景色透明度, Color.SkyBlue ) },
			};
			//-----------------
			#endregion

		protected readonly Dictionary<編集レーン種別, string> dicレーン名
			#region [ **** ]
			//-----------------
			= new Dictionary<編集レーン種別, string>() {
				{ 編集レーン種別.BPM, "BPM" },
				{ 編集レーン種別.左シンバル, "LC" },
				{ 編集レーン種別.ハイハット, "HH" },
				{ 編集レーン種別.スネア, "SD" },
				{ 編集レーン種別.ハイタム, "HT" },
				{ 編集レーン種別.バス, "BD" },
				{ 編集レーン種別.ロータム, "LT" },
				{ 編集レーン種別.フロアタム, "FT" },
				{ 編集レーン種別.右シンバル, "RC" },
				{ 編集レーン種別.背景動画, "BGA" },
				{ 編集レーン種別.Unknown, "NG" },
			};
			//-----------------
			#endregion


		// プロパティ

		protected Bitmap bmp譜面パネル背景;

		// 以下、Dispose は this.Dispose() 内で行うので、追加時には忘れずに。
		protected Font font小節番号文字 = new Font( "MS UI Gothic", 50f, FontStyle.Regular );
		protected Brush brush小節番号文字 = new SolidBrush( Color.FromArgb( 80, Color.White ) );
		protected StringFormat strfmt小節番号文字 = new StringFormat() { LineAlignment = StringAlignment.Center, Alignment = StringAlignment.Center };
		protected Pen penガイド線 = new Pen( Color.FromArgb( 50, 50, 50 ) );
		protected Pen pen小節線 = new Pen( Color.White, 2.0f );
		protected Pen pen拍線 = new Pen( Color.Gray );
		protected Pen penレーン区分線 = new Pen( Color.Gray );
		protected Pen penレーン区分線太 = new Pen( Color.Gray, 3.0f );
		protected Pen penカレントライン = new Pen( Color.Red );
		protected Font fontレーン名文字 = new Font( "MS US Gothic", 8.0f, FontStyle.Regular );
		protected Brush brushレーン名文字 = new SolidBrush( Color.FromArgb( 0xff, 220, 220, 220 ) );
		protected Brush brushレーン名文字影 = new SolidBrush( Color.Black );
		protected StringFormat strfmtレーン名文字 =  new StringFormat() { LineAlignment = StringAlignment.Near, Alignment = StringAlignment.Center };
		protected Pen penチップの太枠 = new Pen( Color.White, 2.0f );
		protected StringFormat strfmtチップ内文字列 = new StringFormat() { LineAlignment = StringAlignment.Near, Alignment = StringAlignment.Center };
		protected Font fontチップ内文字列 = new Font( "MS Gothic", 8f, FontStyle.Bold );
		protected Pen pen白丸白バツ = new Pen( Color.White );


		// メソッド

		protected void t譜面に定間隔で線を描画する( Graphics g, int n小節番号, Rectangle rc小節の描画領域, int n間隔grid, Pen pen )
		{
			if( pen == this.penガイド線 )
				Debug.Assert( n間隔grid != 0 );

			if( n間隔grid >= this.Form.GRID_PER_PIXEL * 2 )		// 間隔 1px 以下は描画しない。最低2pxから。
			{
				int n小節長grid = this.t小節長をグリッドで返す( n小節番号 );

				for( int i = 0; true; i++ )
				{
					int y = rc小節の描画領域.Bottom - ( ( i * n間隔grid ) / this.Form.GRID_PER_PIXEL );

					if( y < rc小節の描画領域.Top )
						break;

					g.DrawLine(
						pen,
						rc小節の描画領域.Left,
						y,
						rc小節の描画領域.Right,
						y );
				}
			}
		}
		protected void tチップを描画する_通常( Graphics g, SSTFormat.チップ種別 eチップ, int n音量, Rectangle rcチップ描画領域, string strチップ内文字列, Color color )
		{
			using( var brush背景 = new SolidBrush( color ) )
			using( var pen明 = new Pen( Color.FromArgb( nチップ明影透明度, color ) ) )
			using( var pen暗 = new Pen( Color.FromArgb( nチップ暗影透明度, color ) ) )
			{
				this.tチップ音量に合わせてチップ描画領域を縮小する( n音量,  ref rcチップ描画領域 );

				// チップ本体

				g.FillRectangle( brush背景, rcチップ描画領域 );
				g.DrawLine( pen明, rcチップ描画領域.X, rcチップ描画領域.Y, rcチップ描画領域.Right, rcチップ描画領域.Y );
				g.DrawLine( pen明, rcチップ描画領域.X, rcチップ描画領域.Y, rcチップ描画領域.X, rcチップ描画領域.Bottom );
				g.DrawLine( pen暗, rcチップ描画領域.X, rcチップ描画領域.Bottom, rcチップ描画領域.Right, rcチップ描画領域.Bottom );
				g.DrawLine( pen暗, rcチップ描画領域.Right, rcチップ描画領域.Bottom, rcチップ描画領域.Right, rcチップ描画領域.Y );


				// チップ内文字列

				if( !string.IsNullOrEmpty( strチップ内文字列 ) )
				{
					var rcLayout = new RectangleF() {
						X = rcチップ描画領域.X,
						Y = rcチップ描画領域.Y,
						Width = rcチップ描画領域.Width,
						Height = rcチップ描画領域.Height,
					};
					g.DrawString( strチップ内文字列, this.fontチップ内文字列, Brushes.Black, rcLayout, this.strfmtチップ内文字列 );
					rcLayout.X--;
					rcLayout.Y--;
					g.DrawString( strチップ内文字列, fontチップ内文字列, Brushes.White, rcLayout, this.strfmtチップ内文字列 );
				}
			}
		}
		protected void tチップを描画する_通常( Graphics g, SSTFormat.チップ種別 eチップ, int n音量, Rectangle rcチップ描画領域, string strチップ内文字列 )
		{
			this.tチップを描画する_通常( g, eチップ, n音量, rcチップ描画領域, strチップ内文字列, this.dicチップ色対応表[ eチップ ] );
		}
		protected void tチップを描画する_幅狭( Graphics g, SSTFormat.チップ種別 eチップ, int n音量, Rectangle rcチップ描画領域, string strチップ内文字列, Color color )
		{
			// チップの幅を半分にする。

			int w = rcチップ描画領域.Width;
			rcチップ描画領域.Width = w / 2;
			rcチップ描画領域.X += w / 4;

			this.tチップを描画する_通常( g, eチップ, n音量, rcチップ描画領域, strチップ内文字列, color );
		}
		protected void tチップを描画する_幅狭( Graphics g, SSTFormat.チップ種別 eチップ, int n音量, Rectangle rcチップ描画領域, string strチップ内文字列 )
		{
			this.tチップを描画する_幅狭( g, eチップ, n音量, rcチップ描画領域, strチップ内文字列, this.dicチップ色対応表[eチップ]);
		}
		protected void tチップを描画する_幅狭白丸( Graphics g, SSTFormat.チップ種別 eチップ, int n音量, Rectangle rcチップ描画領域, string strチップ内文字列 )
		{
			// はじめに幅狭チップを描画。

			this.tチップを描画する_幅狭( g, eチップ, n音量, rcチップ描画領域, strチップ内文字列 );


			// その上に丸を描く。

			this.tチップ音量に合わせてチップ描画領域を縮小する( n音量, ref rcチップ描画領域 );

			g.DrawEllipse( this.pen白丸白バツ, rcチップ描画領域 ); 
		}
		protected void tチップを描画する_幅狭白狭丸( Graphics g, SSTFormat.チップ種別 eチップ, int n音量, Rectangle rcチップ描画領域, string strチップ内文字列 )
		{
			// はじめに幅狭チップを描画。

			this.tチップを描画する_幅狭( g, eチップ, n音量, rcチップ描画領域, strチップ内文字列 );


			// その上に狭い丸を描く。

			this.tチップ音量に合わせてチップ描画領域を縮小する( n音量, ref rcチップ描画領域 );

			int w = rcチップ描画領域.Width;
			rcチップ描画領域.Width = w / 3;
			rcチップ描画領域.X += w / 3 - 1;	// -1 は見た目のバランス（直感）

			g.DrawEllipse( this.pen白丸白バツ, rcチップ描画領域 );
		}
		protected void tチップを描画する_幅狭白バツ( Graphics g, SSTFormat.チップ種別 eチップ, int n音量, Rectangle rcチップ描画領域, string strチップ内文字列 )
		{
			// はじめに幅狭チップを描画。

			this.tチップを描画する_幅狭( g, eチップ, n音量, rcチップ描画領域, strチップ内文字列 );


			// その上に×を描く。

			this.tチップ音量に合わせてチップ描画領域を縮小する( n音量, ref rcチップ描画領域 );

			int w = rcチップ描画領域.Width;
			rcチップ描画領域.Width = w / 3;
			rcチップ描画領域.X += w / 3;

			g.DrawLine( this.pen白丸白バツ, new Point( rcチップ描画領域.Left, rcチップ描画領域.Top ), new Point( rcチップ描画領域.Right, rcチップ描画領域.Bottom ) );
			g.DrawLine( this.pen白丸白バツ, new Point( rcチップ描画領域.Left, rcチップ描画領域.Bottom ), new Point( rcチップ描画領域.Right, rcチップ描画領域.Top ) );
		}
		protected void tチップを描画する_小丸( Graphics g, SSTFormat.チップ種別 eチップ, int n音量, Rectangle rcチップ描画領域, string strチップ内文字列 )
		{
			this.tチップ音量に合わせてチップ描画領域を縮小する( n音量, ref rcチップ描画領域 );

			Color color = this.dicチップ色対応表[ eチップ ];

			int w = rcチップ描画領域.Width;
			rcチップ描画領域.Width = w / 3;
			rcチップ描画領域.X += w / 3;

			using( var brush背景 = new SolidBrush( color ) )
			using( var pen枠 = new Pen( Color.Orange ) )
			{
				g.FillEllipse( brush背景, rcチップ描画領域 );
				g.DrawEllipse( pen枠, rcチップ描画領域 );
			}
		}
		protected void tチップ音量に合わせてチップ描画領域を縮小する( int nチップ音量, ref Rectangle rc描画領域 )
		{
			double db縮小率 = (double) nチップ音量 * ( 1.0 / ( メインフォーム.最大音量 - メインフォーム.最小音量 + 1 ) );

			rc描画領域.Y += (int) ( rc描画領域.Height * ( 1.0 - db縮小率 ) );
			rc描画領域.Height = (int) ( rc描画領域.Height * db縮小率 );
		}
		//-----------------
		#endregion
	}
}
