﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using FDK.メディア;

namespace SST.ステージ.汎用
{
	/// <summary>
	/// フェードアウト用のタイル画像を表示する。
	/// </summary>
	/// <remarks>
	/// パネル画像（任意）の透明度を徐々に濃くしていくことで、フェードアウトを実現する。
	/// </remarks>
	class フェードアウト : FDK.Activity
	{
		public bool 完了した => this.透明度カウンタ.終了値に達した;
		public bool 完了していない => !( this.完了した );

		public フェードアウト( float 総フェード時間sec )
		{
			Debug.Assert( 0.0f < 総フェード時間sec );
			this.総フェード時間sec = 総フェード時間sec;
		}
		public void 開始する()
		{
			int 最初の値 = 0;
			int 最後の値 = 100;
			long 値をひとつ増加させるのにかける時間ms = (long) ( this.総フェード時間sec * 1000f / ( 最後の値 - 最初の値 ) );
			this.透明度カウンタ.開始する( 最初の値, 最後の値, 値をひとつ増加させるのにかける時間ms );
		}
		public void 進行描画する( デバイスリソース dr, FDK.メディア.画像 フェードアウトに使うタイル画像 )
		{
			int タイル枚数X = (int) ( dr.設計画面サイズdpx.Width / フェードアウトに使うタイル画像.サイズdpx.Width ) + 1;  // 剰余は切り捨てられるので +1 。
			int タイル枚数Y = (int) ( dr.設計画面サイズdpx.Height / フェードアウトに使うタイル画像.サイズdpx.Height ) + 1;

			for( int x = 0; x < タイル枚数X; x++ )
			{
				for( int y = 0; y < タイル枚数Y; y++ )
				{
					var 変換行列2Dpx = dr.行列を単位変換するDPXtoPX(
						SharpDX.Matrix3x2.Translation(
							x * フェードアウトに使うタイル画像.サイズdpx.Width,
							y * フェードアウトに使うタイル画像.サイズdpx.Height ) );

					フェードアウトに使うタイル画像?.進行描画する(
						dr,
						変換行列2Dpx: 変換行列2Dpx,
						変換行列3Dpx: null,
						不透明度0to1: this.透明度カウンタ.現在値の割合 );
				}
			}
		}

		protected float 総フェード時間sec = 1.0f;
		protected readonly FDK.カウンタ.単純増加後不変カウンタ 透明度カウンタ = new FDK.カウンタ.単純増加後不変カウンタ();
	}
}
