﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using FDK.メディア;

namespace SST.ステージ.演奏
{
	/// <summary>
	/// コンボのビュー。いずれ コンボ クラスへ統合予定。
	/// </summary>
	class コンボジャンプ : FDK.Activity
	{
		/// <summary>
		/// 表示する数値。新しい数値をここに上書きしていく。
		/// </summary>
		public int 数値 { get; set; } = 0;

		/// <summary>
		/// false にすると非表示。
		/// </summary>
		public bool 表示する { get; set; } = true;

		public コンボジャンプ()
		{
			this.子リスト.Add( this.数値と単位の画像 = new 画像( @"$(Static)\images\combo.png" ) );

			// 180度分のジャンプY座標差分を算出。(i:{0 → 90 → 179} で、[i]:{0 → -15 → 0})
			for( int i = 0; i < 180; i++ )
				this.ジャンプ差分値[ i ] = (int) ( -15.0 * Math.Sin( SharpDX.MathUtil.DegreesToRadians( i ) ) );
		}
		protected override void On活性化( デバイスリソース dr )
		{
			this.数値 = 0;
			this.現在の数値 = 0;
			this.ジャンプインデックス値 = 99999;
			this.ジャンプインデックス進行 = new FDK.カウンタ.定間隔進行();
		}
		protected override void On非活性化( デバイスリソース dr )
		{
		}
		public void 進行描画する( デバイスリソース dr, float 中央Xdpx, float 下辺Ydpx, float 文字間隔dpx )
		{
			// 進行。

			#region " ジャンプインデックス値 の進行。"
			//-----------------
			if( 360 > this.ジャンプインデックス値 )
			{
				this.ジャンプインデックス進行.経過時間の分だけ進行する(
					間隔ms: 2,
					定間隔処理: () => {
						if( 2000 > this.ジャンプインデックス値 )
							this.ジャンプインデックス値 += 3;
					} );
			}
			//-----------------
			#endregion
			#region " 数値が増加していればジャンプを開始する。"
			//-----------------
			if( 数値 > this.現在の数値 )
			{
				this.ジャンプインデックス値 = 0;
				this.ジャンプインデックス進行 = new FDK.カウンタ.定間隔進行();
			}
			//-----------------
			#endregion

			this.現在の数値 = this.数値;

			// 描画。

			if( this.表示する )
			{
				// 数値と単位を表示。
				var 位の数 = new int[ 10 ]; // 10桁もあれば足りるやろ
				int 桁数 = 0;

				#region " 現在の数値 の桁を 逆順に 位の数[] に格納する。（例：現在の数値=125 のとき 位の数 = { 5,2,1,0,0,0,0,0,0,0 }, 桁数 = 3 ） "
				//-----------------
				int n = this.現在の数値;
				while( ( 0 < n ) && ( 10 > 桁数 ) )
				{
					位の数[ 桁数 ] = n % 10;       // 1の位を格納
					n = ( n - ( n % 10 ) ) / 10;  // 右へシフト（例: 12345 → 1234 ）
					桁数++;
				}
				//-----------------
				#endregion
				#region " 単位文字の矩形(COMBO矩形) と 数字と単位を合わせた画像の全幅dpx を算出。"
				//-----------------
				var COMBO矩形 = this.文字矩形dpx[ 10 ];
				float 数字と単位を合わせた画像の全幅dpx = this.文字矩形dpx[ 10 ].Width;
				for( int i = 0; i < 桁数; i++ )
					数字と単位を合わせた画像の全幅dpx += this.文字矩形dpx[ 位の数[ i ] ].Width;
				//-----------------
				#endregion
				#region " 位の数[] を、COMBO文字→ 1の位 → 10の位 … の順に、右から左へ向かって順番に表示する。"
				//-----------------
				float x = 中央Xdpx + ( 数字と単位を合わせた画像の全幅dpx / 2f );      // 右端X
				float y = 下辺Ydpx;
				int jump = this.ジャンプインデックス値 - ( 桁数 * 桁ごとのジャンプの遅れ );

				// 単位 を表示。

				x -= COMBO矩形.Width;
				this.数値と単位の画像.進行描画する( dr, x, 下辺Ydpx - COMBO矩形.Height, 不透明度0to1: 不透明度0to1, 転送元矩形dpx: COMBO矩形 );

				// 数値を1の位から順に表示。

				for( int i = 0; i < 桁数; i++ )
				{
					var rc = this.文字矩形dpx[ 位の数[ i ] ];

					x -= rc.Width + 文字間隔dpx;
					y = 下辺Ydpx - rc.Height;

					jump = this.ジャンプインデックス値 - ( ( ( 桁数 - i ) - 1 ) * 桁ごとのジャンプの遅れ );
					if( ( 0 <= jump ) && ( 180 > jump ) )
						y += this.ジャンプ差分値[ jump ];

					this.数値と単位の画像.進行描画する( dr, x, y, 不透明度0to1, 転送元矩形dpx: rc );
				}
				//-----------------
				#endregion
			}
		}

		protected int 現在の数値 = -1;
		protected int ジャンプインデックス値 = 9999;
		protected int[] ジャンプ差分値 = new int[ 180 ];
		protected FDK.カウンタ.定間隔進行 ジャンプインデックス進行 = null;
		protected readonly FDK.メディア.画像 数値と単位の画像;
		protected readonly List<SharpDX.RectangleF> 文字矩形dpx = new List<SharpDX.RectangleF>() {
			#region " [0]～[9]: '0'～'9', [10]:'COMBO' "
			//----------------
			new SharpDX.RectangleF( 0, 0, 45, 70 ),
			new SharpDX.RectangleF( 45, 0, 45, 70 ),
			new SharpDX.RectangleF( 90, 0, 45, 70 ),
			new SharpDX.RectangleF( 135, 0, 45, 70 ),
			new SharpDX.RectangleF( 180, 0, 45, 70 ),
			new SharpDX.RectangleF( 0, 70, 45, 70 ),
			new SharpDX.RectangleF( 45, 70, 45, 70 ),
			new SharpDX.RectangleF( 90, 70, 45, 70 ),
			new SharpDX.RectangleF( 135, 70, 45, 70 ),
			new SharpDX.RectangleF( 180, 70, 45, 70 ),
			new SharpDX.RectangleF( 0, 140, 90, 32 ),
			//----------------
			#endregion
		};
		protected const int 桁ごとのジャンプの遅れ = 50;   // 1桁につき 50 インデックス遅れる
		protected const float 不透明度0to1 = 0.7f;
	}
}
