﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using FDK.メディア;

namespace SST.ステージ.演奏
{
	class スクロール譜面 : FDK.Activity
	{
		// 外部依存 Action。
		public Action<SSTFormat.チップ種別, ヒット判定種別> ヒット判定文字列開始 = null;
		public Action コンボリセット = null;
		public Action コンボ加算 = null;
		public Action<ヒット判定種別> ヒット判定数加算 = null;
		public Action 背景動画再生開始 = null;
		public Action<SSTFormat.チップ> チップヒット = null;
		public Action ステージクリア = null;

		public スクロール譜面()
		{
			this.子リスト.Add( this.チップ画像 = new 画像( @"$(Static)\images\Chips.png" ) );
		}
		protected override void On活性化( デバイスリソース dr )
		{
			this.描画開始チップ番号 = -1;
			this.チップ画像の矩形リスト = new FDK.メディア.矩形リスト( @"$(Static)\images\Chips Rectangle List.xml" );   // ここで読み込む → 変更があったら反映される（デバッグ用途）。
			var ユーザ = StrokeStyleT.ユーザ管理.現在選択されているユーザ;
			this.ヒット判定を行うチップと対応するレーン = new Dictionary<SSTFormat.チップ種別, ヒットレーン種別>() {
				{ SSTFormat.チップ種別.LeftCrash, ヒットレーン種別.LeftCrash },
				{ SSTFormat.チップ種別.Ride, ( ユーザ.Rideは左 ) ? ヒットレーン種別.LeftCrash : ヒットレーン種別.RightCrash },
				{ SSTFormat.チップ種別.Ride_Cup, ( ユーザ.Rideは左 ) ? ヒットレーン種別.LeftCrash : ヒットレーン種別.RightCrash },
				{ SSTFormat.チップ種別.China, ( ユーザ.Chinaは左 ) ? ヒットレーン種別.LeftCrash : ヒットレーン種別.RightCrash },
				{ SSTFormat.チップ種別.Splash, ( ユーザ.Splashは左 ) ? ヒットレーン種別.LeftCrash : ヒットレーン種別.RightCrash },
				{ SSTFormat.チップ種別.HiHat_Open, ヒットレーン種別.HiHat },
				{ SSTFormat.チップ種別.HiHat_HalfOpen, ヒットレーン種別.HiHat },
				{ SSTFormat.チップ種別.HiHat_Close, ヒットレーン種別.HiHat },
				//{ SSTFormat.チップ種別.HiHat_Foot, ヒット判定レーン種別.HiHat },
				{ SSTFormat.チップ種別.Snare, ヒットレーン種別.Snare },
				{ SSTFormat.チップ種別.Snare_OpenRim, ヒットレーン種別.Snare },
				{ SSTFormat.チップ種別.Snare_ClosedRim, ヒットレーン種別.Snare },
				//{ SSTFormat.チップ種別.Snare_Ghost, ヒット判定レーン種別.Snare },
				{ SSTFormat.チップ種別.Bass, ヒットレーン種別.Bass },
				{ SSTFormat.チップ種別.Tom1, ヒットレーン種別.Tom1 },
				{ SSTFormat.チップ種別.Tom1_Rim, ヒットレーン種別.Tom1 },
				{ SSTFormat.チップ種別.Tom2, ヒットレーン種別.Tom2 },
				{ SSTFormat.チップ種別.Tom2_Rim, ヒットレーン種別.Tom2 },
				{ SSTFormat.チップ種別.Tom3, ヒットレーン種別.Tom2 },
				{ SSTFormat.チップ種別.Tom3_Rim, ヒットレーン種別.Tom2 },
				{ SSTFormat.チップ種別.RightCrash, ヒットレーン種別.RightCrash },
			};
			this.活性化した直後である = true;
		}
		protected override void On非活性化( デバイスリソース dr )
		{
		}

		public void 小節線拍線を進行描画する( デバイスリソース dr, double 現在の演奏時刻sec, double 譜面スクロール速度の倍率 )
			=> this.画面内に収まるチップをすべて進行描画する( dr, this.小節線拍線を１つ描画する, 現在の演奏時刻sec, 譜面スクロール速度の倍率 );

		public void チップを進行描画する( デバイスリソース dr, double 現在の演奏時刻sec, double 譜面スクロール速度の倍率 )
			=> this.画面内に収まるチップをすべて進行描画する( dr, this.チップを１つ描画する, 現在の演奏時刻sec, 譜面スクロール速度の倍率 );

		/// <summary>
		/// 演奏スコア.listチップ[] のうち、描画を始めるチップのインデックス番号を示す。
		/// 演奏開始直後は 0 で始まり、対象番号のチップが描画範囲を流れ去るたびに +1 される。
		/// 未演奏時・演奏終了時は -1 。
		/// </summary>
		protected int 描画開始チップ番号 = -1;

		/// <param name="現在の演奏時刻sec">double.NaNならリアルタイムに取得する。</param>
		protected void 画面内に収まるチップをすべて進行描画する( デバイスリソース dr, Action<デバイスリソース, SSTFormat.チップ, float> 描画アクション, double 現在の演奏時刻sec, double 譜面スクロール速度の倍率 )
		{

			var 演奏スコア = StrokeStyleT.演奏スコア;
			Trace.Assert( null != 演奏スコア, "[バグあり] 演奏スコアが null です。" );

			#region " 最初の進行描画。"
			//----------------
			if( this.活性化した直後である )
			{
				this.活性化した直後である = false;
				this.描画開始チップ番号 = 0; // 演奏開始。
				this.チップアニメ.開始する( 最初の値: 0, 最後の値: 48, 値をひとつ増加させるのにかける時間ms: 10 );
			}
			//----------------
			#endregion

			for( int i = this.描画開始チップ番号; ( 0 <= i ) && ( 演奏スコア.listチップ.Count > i ); i++ )
			{
				var チップ = 演奏スコア.listチップ[ i ];

				// 時間差を算出する。
				double 描画時間差sec = 現在の演奏時刻sec - チップ.描画時刻sec;

				// 判定バーとチップの距離[dpx;符号付き;負数ならバー未達、0でバー直上、正数でバー通過]を算出する。
				double 描画距離dpx = 演奏スコア.n指定された時間secに対応する符号付きピクセル数を返す( 譜面スクロール速度の倍率, 描画時間差sec );

				// チップのY座標を算出し、ループの終了判定を行う。
				double y = 座標.判定バーの中央Y座標dpx + 描画距離dpx;
				if( y < -40.0 )   // y が画面上端より上に出ていればそこでチップのループ描画は終了。-40 dpx はチップが隠れるであろう適当なマージン。
					break;

				// チップが描画開始チップであり、かつ、そのY座標が画面下端を超えたなら、描画開始チップ番号を更新する。
				if( ( this.描画開始チップ番号 == i ) && ( dr.設計画面サイズdpx.Height + 40.0 < y ) )   // +40 dpx はチップが（以下同上
				{
					this.描画開始チップ番号++;
					if( 演奏スコア.listチップ.Count <= this.描画開始チップ番号 )
					{
						this.ステージクリア();
						this.描画開始チップ番号 = -1;    // 演奏終了。
					}
				}

				// AutoPlay チップなら、自動ヒット判定を行う。
				if( ( チップ.ヒットされていない ) &&    // チップが未ヒット、かつ、
					( StrokeStyleT.ユーザ管理.現在選択されているユーザ.チップ種別に対応するAutoPlayを返す( チップ.チップ種別 ) ) &&    // チップの AutoPlay が ON、かつ、
					( 0 <= 描画距離dpx ) )  // バーを通過した。
				{
					チップ.ヒット済みである = true;
					チップ.不可視 = true;
					if( チップ.チップ種別 == SSTFormat.チップ種別.背景動画 )
					{
						// (A) 背景動画の場合。
						this.背景動画再生開始?.Invoke();
					}
					else
					{
						// (B) その他のチップの場合。
						this.チップヒット?.Invoke( チップ );
						this.コンボ加算?.Invoke();
						this.ヒット判定数加算?.Invoke( ヒット判定種別.AUTO );
						this.ヒット判定文字列開始?.Invoke( チップ.チップ種別, ヒット判定種別.AUTO );
					}
				}

				// Miss 判定を行う。
				if( ( チップ.ヒットされていない ) &&    // チップが未ヒット、かつ、
					( this.ヒット判定を行うチップと対応するレーン.ContainsKey( チップ.チップ種別 ) ) && // チップがヒット判定対象である、かつ、
					// ( false == StrokeStyleT.ユーザ管理.現在選択されているユーザ.チップ種別に対応するAutoPlayを返す( チップ.eチップ ) ) &&	 → AutoPlay判定の後だから省略しても問題ない。はず。
					( 描画時間差sec > StrokeStyleT.ユーザ管理.現在選択されているユーザ.ヒット範囲sec.Poor ) )  // 描画時間差が Poor 範囲を超えている。
				{
					チップ.ヒット済みである = true;
					チップ.不可視 = true;
					this.コンボリセット?.Invoke();
					this.ヒット判定文字列開始?.Invoke( チップ.チップ種別, ヒット判定種別.MISS );
				}

				// チップを１つ描画する。
				if( チップ.可視 )
					描画アクション( dr, チップ, (float) y );
			}
		}
		protected void 小節線拍線を１つ描画する( デバイスリソース dr, SSTFormat.チップ chip, float Ydpx )
		{
			if( null == this.チップ画像 )
				return;

			this.チップ画像.加算合成 = false;

			switch( chip.チップ種別 )
			{
				case SSTFormat.チップ種別.小節線:
					#region " *** "
					//----------------
					{
						float 左位置dpx = 座標.レーンフレーム左端のX座標dpx + this.レーン種別toレーンフレーム左端からの相対X位置dpx[ SSTFormat.レーン種別.LeftCrash ] - 1f;
						float 上位置dpx = Ydpx - 1f;
						var 画像範囲orNull = this.チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.小節線 ) ];
						if( null != 画像範囲orNull )
						{
							var 画像範囲 = (SharpDX.RectangleF) 画像範囲orNull;
							this.チップ画像.進行描画する( dr, 左位置dpx, 上位置dpx, 転送元矩形dpx: 画像範囲 );
							this.チップ画像.進行描画する( dr, 左位置dpx + 画像範囲.Width, 上位置dpx, 転送元矩形dpx: 画像範囲 );
						}
					}
					//----------------
					#endregion
					break;

				case SSTFormat.チップ種別.拍線:
					#region " *** "
					//----------------
					{
						float 左位置dpx = 座標.レーンフレーム左端のX座標dpx + this.レーン種別toレーンフレーム左端からの相対X位置dpx[ SSTFormat.レーン種別.LeftCrash ] - 1f;
						float 上位置dpx = Ydpx;
						var 画像範囲orNull = this.チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.拍線 ) ];
						if( null != 画像範囲orNull )
						{
							var 画像範囲 = (SharpDX.RectangleF) 画像範囲orNull;
							this.チップ画像.進行描画する( dr, 左位置dpx: 左位置dpx, 上位置dpx: 上位置dpx, 転送元矩形dpx: 画像範囲 );
							this.チップ画像.進行描画する( dr, 左位置dpx: 左位置dpx + 画像範囲.Width, 上位置dpx: 上位置dpx, 転送元矩形dpx: 画像範囲 );
						}
					}
					//----------------
					#endregion
					break;
			}
		}
		protected void チップを１つ描画する( デバイスリソース dr, SSTFormat.チップ chip, float Ydpx )
		{
			if( null == this.チップ画像 )
				return;

			this.チップ画像.加算合成 = false;
			float 音量0to1 = chip.音量 * 0.25f;

			switch( chip.チップ種別 )
			{
				case SSTFormat.チップ種別.LeftCrash:
					this.単画チップを１つ描画する( dr, SSTFormat.レーン種別.LeftCrash, this.チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.LeftCrash ) ], Ydpx, 音量0to1 );
					break;

				case SSTFormat.チップ種別.HiHat_Close:
					this.アニメチップを１つ描画する( dr, this.チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.HiHat_Close ) ], SSTFormat.レーン種別.HiHat, Ydpx, 音量0to1 );
					break;

				case SSTFormat.チップ種別.HiHat_HalfOpen:
					this.アニメチップを１つ描画する( dr, this.チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.HiHat_Close ) ], SSTFormat.レーン種別.HiHat, Ydpx, 音量0to1 );
					this.単画チップを１つ描画する( dr, SSTFormat.レーン種別.Foot, this.チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.HiHat_HalfOpen ) ], Ydpx, 1.0f );    // 音量は反映しない
					break;

				case SSTFormat.チップ種別.HiHat_Open:
					this.アニメチップを１つ描画する( dr, this.チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.HiHat_Close ) ], SSTFormat.レーン種別.HiHat, Ydpx, 音量0to1 );
					this.単画チップを１つ描画する( dr, SSTFormat.レーン種別.Foot, this.チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.HiHat_Open ) ], Ydpx, 1.0f );    // 音量は反映しない
					break;

				case SSTFormat.チップ種別.HiHat_Foot:
					this.単画チップを１つ描画する( dr, SSTFormat.レーン種別.Foot, this.チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.HiHat_Foot ) ], Ydpx, 1.0f );    // 音量は反映しない
					break;

				case SSTFormat.チップ種別.Snare:
					this.アニメチップを１つ描画する( dr, this.チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.Snare ) ], SSTFormat.レーン種別.Snare, Ydpx, 音量0to1 );
					break;

				case SSTFormat.チップ種別.Snare_ClosedRim:
					this.単画チップを１つ描画する( dr, SSTFormat.レーン種別.Snare, this.チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.Snare_ClosedRim ) ], Ydpx, 1.0f );  // 音量は反映しない
					break;

				case SSTFormat.チップ種別.Snare_OpenRim:
					this.単画チップを１つ描画する( dr, SSTFormat.レーン種別.Snare, this.チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.Snare_OpenRim ) ], Ydpx, 音量0to1 );
					//this.単画チップを１つ描画する( dr, SSTFormat.レーン種別.Snare, this.チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.Snare ) ], y, 音量0to1 ); → ないほうが見た目がいいかも。
					break;

				case SSTFormat.チップ種別.Snare_Ghost:
					this.単画チップを１つ描画する( dr, SSTFormat.レーン種別.Snare, this.チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.Snare_Ghost ) ], Ydpx, 1.0f );  // 音量は反映しない
					break;

				case SSTFormat.チップ種別.Bass:
					this.アニメチップを１つ描画する( dr, this.チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.Bass ) ], SSTFormat.レーン種別.Bass, Ydpx, 音量0to1 );
					break;

				case SSTFormat.チップ種別.Tom1:
					this.アニメチップを１つ描画する( dr, this.チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.Tom1 ) ], SSTFormat.レーン種別.Tom1, Ydpx, 音量0to1 );
					break;

				case SSTFormat.チップ種別.Tom1_Rim:
					this.単画チップを１つ描画する( dr, SSTFormat.レーン種別.Tom1, this.チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.Tom1_Rim ) ], Ydpx, 1.0f );  // 音量は反映しない
					break;

				case SSTFormat.チップ種別.Tom2:
					this.アニメチップを１つ描画する( dr, this.チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.Tom2 ) ], SSTFormat.レーン種別.Tom2, Ydpx, 音量0to1 );
					break;

				case SSTFormat.チップ種別.Tom2_Rim:
					this.単画チップを１つ描画する( dr, SSTFormat.レーン種別.Tom2, this.チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.Tom2_Rim ) ], Ydpx, 1.0f );  // 音量は反映しない
					break;

				case SSTFormat.チップ種別.Tom3:
					this.アニメチップを１つ描画する( dr, this.チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.Tom3 ) ], SSTFormat.レーン種別.Tom3, Ydpx, 音量0to1 );
					break;

				case SSTFormat.チップ種別.Tom3_Rim:
					this.単画チップを１つ描画する( dr, SSTFormat.レーン種別.Tom3, this.チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.Tom3_Rim ) ], Ydpx, 1.0f );  // 音量は反映しない
					break;

				case SSTFormat.チップ種別.RightCrash:
					this.単画チップを１つ描画する( dr, SSTFormat.レーン種別.RightCrash, this.チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.RightCrash ) ], Ydpx, 音量0to1 );
					break;

				case SSTFormat.チップ種別.China:
					if( StrokeStyleT.ユーザ管理.現在選択されているユーザ.Chinaは左 )
						this.単画チップを１つ描画する( dr, SSTFormat.レーン種別.LeftCrash, this.チップ画像の矩形リスト[ "LeftChina" ], Ydpx, 音量0to1 );
					else
						this.単画チップを１つ描画する( dr, SSTFormat.レーン種別.RightCrash, this.チップ画像の矩形リスト[ "RightChina" ], Ydpx, 音量0to1 );
					break;

				case SSTFormat.チップ種別.Ride:
					if( StrokeStyleT.ユーザ管理.現在選択されているユーザ.Rideは左 )
						this.単画チップを１つ描画する( dr, SSTFormat.レーン種別.LeftCrash, this.チップ画像の矩形リスト[ "LeftRide" ], Ydpx, 音量0to1 );
					else
						this.単画チップを１つ描画する( dr, SSTFormat.レーン種別.RightCrash, this.チップ画像の矩形リスト[ "RightRide" ], Ydpx, 音量0to1 );
					break;

				case SSTFormat.チップ種別.Ride_Cup:
					if( StrokeStyleT.ユーザ管理.現在選択されているユーザ.Rideは左 )
						this.単画チップを１つ描画する( dr, SSTFormat.レーン種別.LeftCrash, this.チップ画像の矩形リスト[ "LeftRide_Cup" ], Ydpx, 音量0to1 );
					else
						this.単画チップを１つ描画する( dr, SSTFormat.レーン種別.RightCrash, this.チップ画像の矩形リスト[ "RightRide_Cup" ], Ydpx, 音量0to1 );
					break;

				case SSTFormat.チップ種別.Splash:
					if( StrokeStyleT.ユーザ管理.現在選択されているユーザ.Splashは左 )
						this.単画チップを１つ描画する( dr, SSTFormat.レーン種別.LeftCrash, this.チップ画像の矩形リスト[ "LeftSplash" ], Ydpx, 音量0to1 );
					else
						this.単画チップを１つ描画する( dr, SSTFormat.レーン種別.RightCrash, this.チップ画像の矩形リスト[ "RightSplash" ], Ydpx, 音量0to1 );
					break;
			}
		}
		protected void アニメチップを１つ描画する( デバイスリソース dr, SharpDX.RectangleF? 画像範囲orNull, SSTFormat.レーン種別 elane, float Ydpx, float 音量0to1 )
		{
			if( null == 画像範囲orNull )
				return;
			var 画像範囲 = (SharpDX.RectangleF) 画像範囲orNull;

			float チップ1枚の高さdpx = 18f;
			画像範囲.Offset( 0f, this.チップアニメ.現在値 * 15f );   // 下端3dpxは下のチップと共有してるので、18f-3f = 15f。
			画像範囲.Height = チップ1枚の高さdpx;
			float 左位置dpx = 座標.レーンフレーム左端のX座標dpx + this.レーン種別toレーンフレーム左端からの相対X位置dpx[ elane ] - 画像範囲.Width / 2f;
			float 上位置dpx = Ydpx - ( チップ1枚の高さdpx / 2f ) * 音量0to1;

			this.チップ画像.進行描画する( dr, 左位置dpx, 上位置dpx, 転送元矩形dpx: 画像範囲, Y方向拡大率: 音量0to1 );
		}
		protected void 単画チップを１つ描画する( デバイスリソース dr, SSTFormat.レーン種別 eLane, SharpDX.RectangleF? 元矩形dpx, float 上位置dpx, float 音量0to1 )
		{
			if( null == 元矩形dpx )
				return;

			var 画像範囲dpx = (SharpDX.RectangleF) 元矩形dpx;
			this.チップ画像.進行描画する(
				dr,
				左位置dpx: 座標.レーンフレーム左端のX座標dpx + this.レーン種別toレーンフレーム左端からの相対X位置dpx[ eLane ] - ( 画像範囲dpx.Width / 2f ),
				上位置dpx: 上位置dpx - ( ( 画像範囲dpx.Height / 2f ) * 音量0to1 ),
				転送元矩形dpx: 元矩形dpx,
				Y方向拡大率: 音量0to1 );
		}

		protected bool 活性化した直後である = false;
		protected readonly FDK.メディア.画像 チップ画像;
		protected FDK.メディア.矩形リスト チップ画像の矩形リスト = null;
		protected Dictionary<SSTFormat.チップ種別, ヒットレーン種別> ヒット判定を行うチップと対応するレーン = null;
		protected readonly FDK.カウンタ.単純増加後反復カウンタ チップアニメ = new FDK.カウンタ.単純増加後反復カウンタ();
		protected readonly Dictionary<SSTFormat.レーン種別, float> レーン種別toレーンフレーム左端からの相対X位置dpx = new Dictionary<SSTFormat.レーン種別, float>() {
			#region " *** "
			//----------------
			{ SSTFormat.レーン種別.LeftCrash, +36f },
			{ SSTFormat.レーン種別.HiHat, +105f },
			{ SSTFormat.レーン種別.Foot, +145f },
			{ SSTFormat.レーン種別.Snare, +214f },
			{ SSTFormat.レーン種別.Tom1, +310f },
			{ SSTFormat.レーン種別.Bass, +381f },
			{ SSTFormat.レーン種別.Tom2, +448f },
			{ SSTFormat.レーン種別.Tom3, +544f },
			{ SSTFormat.レーン種別.RightCrash, +632f },
			//----------------
			#endregion
		};
	}
}
