﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using FDK.メディア;

namespace SST.ステージ.結果
{
	class 結果ステージ : ステージ
	{
		public enum フェーズ
		{
			初期状態,
			表示中,
			終了,
		}
		public フェーズ 現在のフェーズ { get; protected set; } = フェーズ.初期状態;

		// 外部依存 Action。
		public Action BGMを終了する = null;

		public 結果ステージ()
		{
			this.子リスト.Add( this.背景動画 = new 動画( @"$(Static)\images\結果画面BGV.mp4" ) );
		}
		protected override void On活性化( デバイスリソース dr )
		{
			FDK.Log.Info( "結果ステージを開始します。" );
			this.背景動画.ループ再生する = true;
			this.現在のフェーズ = フェーズ.表示中;
		}
		protected override void On非活性化( デバイスリソース dr )
		{
			FDK.Log.Info( "結果ステージを終了します。" );
			this.BGMを終了する?.Invoke();    // ここでBGMを終了する。
		}
		public override void 進行描画する( デバイスリソース dr )
		{
			// 進行描画。

			this.背景動画.進行描画する( dr, new SharpDX.RectangleF( 0f, 0f, dr.設計画面サイズdpx.Width, dr.設計画面サイズdpx.Height ) );

			// 入力。

			StrokeStyleT.すべての入力デバイスをポーリングする();

			// Enter or ESC 押下 → ステージ終了。
			if( StrokeStyleT.キーボード入力.キーが押された( SharpDX.DirectInput.Key.Return ) ||
				StrokeStyleT.キーボード入力.キーが押された( SharpDX.DirectInput.Key.Escape ) )
			{
				this.現在のフェーズ = フェーズ.終了;
			}
		}

		protected readonly FDK.メディア.動画 背景動画;
	}
}
