﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using FDK.メディア;

namespace SST.ステージ.選曲
{
	/// <summary>
	/// 曲パネルリスト（９列３行）を表示する。
	/// </summary>
	/// <remarks>
	/// 静止時の可視範囲は、左右両端の１列を除いた７列３行。
	/// 左右両端の列は、静止時は画面外に位置しており、左右スクロール中にのみ画面内に一部が表示される。
	/// 「カーソル」は、常に、曲パネル内のいずれか１枚の曲を選択している。
	/// カーソルは、初期状態では中央の曲を選択しており、本クラスのメソッドを使って上下左右に移動することができる。
	/// カーソルが選択している曲は強調表示（視覚効果として少し拡大して表示）される。
	/// </remarks>
	class 曲パネルビュー : FDK.Activity
	{
		public 曲パネルビュー()
		{
			this.子リスト.Add( this.Nullパネルの画像 = new テクスチャ( @"$(Static)\images\選曲パネル.png" ) );
		}
		public void カーソルを上に移動する()
		{
			if( 0 < this.カーソル位置.Y )
			{
				this.カーソル位置.Y--;
			}
			else
			{
				this.カーソル位置.X--;
				this.カーソル位置.Y = 2;
			}

			// カーソルと一緒に、選択曲も移動する。
			StrokeStyleT.曲ツリー管理.前のノードを選択する();
		}
		public void カーソルを下に移動する()
		{
			if( 2 > this.カーソル位置.Y )
			{
				this.カーソル位置.Y++;
			}
			else
			{
				this.カーソル位置.X++;
				this.カーソル位置.Y = 0;
			}

			// カーソルと一緒に、選択曲も移動する。
			StrokeStyleT.曲ツリー管理.次のノードを選択する();
		}
		public void カーソルを左に移動する()
		{
			this.カーソル位置.X--;    // 制限なし

			// カーソルと一緒に、選択曲も移動する。
			StrokeStyleT.曲ツリー管理.前のノードを選択する();
			StrokeStyleT.曲ツリー管理.前のノードを選択する();
			StrokeStyleT.曲ツリー管理.前のノードを選択する();
		}
		public void カーソルを右に移動する()
		{
			this.カーソル位置.X++;    // 制限なし

			// カーソルと一緒に、選択曲も移動する。
			StrokeStyleT.曲ツリー管理.次のノードを選択する();
			StrokeStyleT.曲ツリー管理.次のノードを選択する();
			StrokeStyleT.曲ツリー管理.次のノードを選択する();
		}
		protected override void On活性化( デバイスリソース dr )
		{
			this.活性化した直後である = true;
		}
		protected override void On非活性化( デバイスリソース dr )
		{
		}
		public void 進行描画する( デバイスリソース dr )
		{
			// 進行。

			if( this.活性化した直後である )
			{
				this.活性化した直後である = false;
				this.横スクロール用カウンタ = new FDK.カウンタ.定間隔進行();
			}
			else
			{
				this.横スクロール用カウンタ.経過時間の分だけ進行する( 8, () => {

					int オフセットの加減算速度 = 1;

					#region " カーソルが中央から遠いほど速くなるよう、オフセットの加減算速度（絶対値）を計算する。"
					//------------------
					int 距離 = Math.Abs( 4 - this.カーソル位置.X );
					if( 1 >= 距離 )
						オフセットの加減算速度 = 2;
					else if( 4 >= 距離 )
						オフセットの加減算速度 = 4;
					else if( 6 >= 距離 )
						オフセットの加減算速度 = 6;
					else
						オフセットの加減算速度 = 8;
					//------------------
					#endregion

					// オフセット と カーソル位置.X を更新する。
					if( ( 4 > this.カーソル位置.X ) ||
						( ( 4 == this.カーソル位置.X ) && ( 0 > this.パネル全体のY軸回転オフセット ) ) )
					{
						#region " (A) パネルは、左から右へ、移動する。"
						//-----------------
						this.パネル全体のY軸回転オフセット += オフセットの加減算速度;

						// １列分移動した
						if( 64 <= this.パネル全体のY軸回転オフセット )
						{
							this.パネル全体のY軸回転オフセット -= 64;  // 0 付近に戻る
							this.カーソル位置.X++;
						}
						//-----------------
						#endregion
					}
					else if( ( 4 < this.カーソル位置.X ) ||
						( ( 4 == this.カーソル位置.X ) && ( 0 < this.パネル全体のY軸回転オフセット ) ) )
					{
						#region " (B) パネルは、右から左へ、移動する。"
						//-----------------
						this.パネル全体のY軸回転オフセット -= オフセットの加減算速度;

						// １列分移動した
						if( -64 >= this.パネル全体のY軸回転オフセット )
						{
							this.パネル全体のY軸回転オフセット += 64;  // 0 付近に戻る
							this.カーソル位置.X--;
						}
						//-----------------
						#endregion
					}

				} );
			}

			// 描画。

			Debug.Assert( null != StrokeStyleT.ユーザ管理?.現在選択されているユーザ?.曲ツリーのルートノード );

			var 曲リスト管理 = StrokeStyleT.曲ツリー管理;
			var 曲リスト = 曲リスト管理.現在選択されているノード?.親ノード.子ノードリスト ?? 曲リスト管理.現在の管理対象ツリー.子ノードリスト;
			var 描画する曲 = 曲リスト管理.現在選択されているノード;    // null 可
			var カーソル位置の曲 = (曲.Node) null;   // null 可

			#region " 左上隅パネルに対応する曲リストノードを検索する。"
			//-----------------
			int 現在のカーソルから左上隅までの差 = 0 - ( this.カーソル位置.X * 3 + this.カーソル位置.Y );   // 現在のカーソルの位置に、現在選択されている曲が対応するものとする。

			if( 0 < 現在のカーソルから左上隅までの差 )
			{
				// 曲リストを前方へたどる。
				for( int i = 0; i < 現在のカーソルから左上隅までの差; i++ )
					描画する曲 = 描画する曲?.次のノード;
			}
			else
			{
				// 曲リストを後方へたどる。
				for( int i = 現在のカーソルから左上隅までの差; i < 0; i++ )
					描画する曲 = 描画する曲?.前のノード;
			}
			//-----------------
			#endregion
			#region " 9×3枚の曲パネルを描画する。"
			//-----------------
			for( int i = 0; i < ( 9 * 3 ); i++ )
			{
				var パネル位置 = new SharpDX.Point( i / 3, i % 3 );

				if( パネル位置 == this.カーソル位置 )
				{
					// カーソル位置にあるパネルは後で描画するので、覚えておく。
					カーソル位置の曲 = 描画する曲;
				}
				else
				{
					this.パネルを一枚描画する( dr, 描画する曲, パネル位置, これはカーソル位置のパネルである: false );
				}

				// 次のノードへ移動。（選択ノードは移動しない。）
				描画する曲 = 描画する曲?.次のノード;
			}
			//-----------------
			#endregion
			#region " カーソル位置のパネルを描画する。"
			//-----------------
			if( ( 0 <= this.カーソル位置.X ) && ( 9 > this.カーソル位置.X ) &&
				( 0 <= this.カーソル位置.Y ) && ( 3 > this.カーソル位置.Y ) )
			{
				this.パネルを一枚描画する(
					dr,
					カーソル位置の曲,   // 先の for ループ内で取得済み。
					this.カーソル位置,
					これはカーソル位置のパネルである: true );
			}
			//-----------------
			#endregion
		}

		protected const float カーソル位置のパネルの拡大率 = 1.25f;
		protected bool 活性化した直後である = false;
		protected readonly FDK.メディア.テクスチャ Nullパネルの画像;
		protected FDK.カウンタ.定間隔進行 横スクロール用カウンタ = null;
		/// <summary>
		/// 左上隅のパネルを (0,0) とした時の、カーソル位置の座標。
		/// 負数も可。
		/// </summary>
		protected SharpDX.Point カーソル位置 = new SharpDX.Point( 4, 1 );
		/// <summary>
		/// -63～63。パネル全体の表示位置を、負数は 左 へ、正数は 右 へずらす 。（正負と左右の対応に注意。）
		/// </summary>
		/// <remarks>
		/// ±64 は、パネル１列分を表すサイズ。
		/// </remarks>
		protected int パネル全体のY軸回転オフセット = 0;

		/// <summary>
		/// パネルを一枚（ノード画像とタイトル画像）を、指定したパネル位置に描画する。
		/// </summary>
		/// <param name="パネルノード">null 可。</param>
		protected void パネルを一枚描画する( デバイスリソース dr, 曲.Node パネルノード, SharpDX.Point パネル位置, bool これはカーソル位置のパネルである = false )
		{
			if( null != パネルノード )
			{
				// ノード画像を表示する。
				パネルノード.ノード画像を描画する( dr, this.ワールド変換行列を計算して返す( パネル位置, SharpDX.Matrix.Scaling( パネルノード.ノード画像サイズdpx.Width, パネルノード.ノード画像サイズdpx.Height, 1f ) ) );
				
				// タイトル文字列画像を表示する。
			}
			else
			{
				// Nullパネル画像を表示する。
				this.Nullパネルの画像.進行描画する( dr, this.ワールド変換行列を計算して返す( パネル位置, this.Nullパネルの画像.等倍スケーリング行列 ) );
			}
		}

		protected SharpDX.Matrix ワールド変換行列を計算して返す( SharpDX.Point パネル位置, SharpDX.Matrix 等倍スケーリング行列 )
		{
			// 画面を見ながら直観的に調整した固定パラメータたち。
			const float 見かけの倍率 = 3.0f;
			const float パネル全体のY方向移動量dpx = +150f;    // パネル全体を少しだけ上にシフトする。
			const float パネル全体のZ方向移動量dpx = +3000f;
			const float 行間 = 1.1f;
			const float パネル間X方向角度deg = 19f;

			// 拡大縮小
			var mat = 等倍スケーリング行列 * SharpDX.Matrix.Scaling( 見かけの倍率 );

			// 平行移動
			float パネル間縦距離dpx = ( this.Nullパネルの画像.サイズdpx.Height * 見かけの倍率 * 行間 );
			mat = mat * SharpDX.Matrix.Translation( 0f, パネル全体のY方向移動量dpx + ( パネル位置.Y - 1 ) * パネル間縦距離dpx, パネル全体のZ方向移動量dpx );

			// Y軸回転
			mat = mat * SharpDX.Matrix.RotationY( SharpDX.MathUtil.DegreesToRadians( ( パネル位置.X - 4 ) * パネル間X方向角度deg ) );

			return mat;
		}
	}
}
