﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text.RegularExpressions;

namespace SST.曲
{
	/// <summary>
	/// box.def を表すクラス。
	/// </summary>
	public class BoxDef
	{
		public string Title { get; set; } = "";
		public string Artist { get; set; } = "";

		public BoxDef( string boxdefファイルパス )
		{
			this.BOX定義ファイルを読み込む( boxdefファイルパス );
		}
		public void BOX定義ファイルを読み込む( string boxdefファイルパス )
		{
			using( var sr = new StreamReader( boxdefファイルパス ) )
			{
				string 行;
				while( ( 行 = sr.ReadLine() ) != null )
				{
					try
					{
						string パラメータ = null;

						#region " TITLE コマンド "
						//---------------------
						if( SSTFormat.スコア.コマンドのパラメータ文字列部分を返す( 行, @"TITLE", out パラメータ ) )
						{
							this.Title = パラメータ;
							continue;
						}
						//---------------------
						#endregion
						#region " ARTIST コマンド "
						//---------------------
						if( SSTFormat.スコア.コマンドのパラメータ文字列部分を返す( 行, @"ARTIST", out パラメータ ) )
						{
							this.Artist = パラメータ;
							continue;
						}
						//---------------------
						#endregion
					}
					catch
					{
						// 例外は無視。
					}
				}
			}
		}
	}
}
