﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace FDK.メディア.サウンド.WASAPI
{
	public class SoundTimer : IDisposable
	{
		/// <summary>
		///		コンストラクタまたはリセットの時点からの相対経過時間[sec]。
		/// </summary>
		public double 現在時刻sec
		{
			get
			{
				lock( this._スレッド間同期 )
				{
					return ( 0 < this._停止回数 ) ?
						this._停止位置sec - this._開始位置sec :                 // 一時停止中
						this._Device.GetDevicePosition() - this._開始位置sec;   // 稼働中
				}
			}
		}


		public SoundTimer( Device device )
		{
			this._Device = device;
			this.リセットする();
		}

		public void Dispose()
		{
			this._Device = null;	// Disposeは不要
		}

		public void リセットする( double 新しい現在時刻sec = 0.0 )
		{
			lock( this._スレッド間同期 )
			{
				this._開始位置sec = this._Device.GetDevicePosition() - 新しい現在時刻sec;
				this._停止回数 = 0;
				this._停止位置sec = 0;
			}
		}

		public void 一時停止する()
		{
			lock( this._スレッド間同期 )
			{
				if( 0 == this._停止回数 )
					this._停止位置sec = this._Device.GetDevicePosition();

				this._停止回数++;
			}
		}

		public void 再開する()
		{
			lock( this._スレッド間同期 )
			{
				this._停止回数--;

				if( 0 == this._停止回数 )
					this.リセットする( this._停止位置sec - this._開始位置sec );
			}
		}


		private Device _Device = null;

		private int _停止回数 = 0;

		private double _開始位置sec = 0.0;

		private double _停止位置sec = 0.0;

		private readonly object _スレッド間同期 = new object();
	}
}
