﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using FDK;
using System;
using System.Collections.Generic;
using System.Linq;

namespace FDK.Tests
{
	[TestClass()]
	public class FDKUtilitiesTests
	{
		// 例外検証用メソッド
		private void 例外が出れば成功( Action action )
		{
			try
			{
				action();
				Assert.Fail();  // ここに来るということは、action() で例外がでなかったということ。
			}
			catch( AssertFailedException )
			{
				throw;  // 失敗。
			}
			catch
			{
				// 成功。
			}
		}

		// テスト用クラス
		class DisposeTest : IDisposable
		{
			public bool Dispose済み = false;
			public void Dispose()
			{
				this.Dispose済み = true;
			}
		}

		[TestMethod()]
		public void 解放するTest()
		{
			DisposeTest test = null;

			#region " ref あり Dispose → Dispose して null にする。"

			test = new DisposeTest();
			Assert.IsFalse( test.Dispose済み );    // まだ Dispose されていない

			FDK.FDKUtilities.解放する( ref test );
			Assert.IsNull( test );  // obj が解放された

			#endregion
		}

		[TestMethod()]
		public void 最大公約数を返すTest()
		{
			int 結果 = 0;

			// 正常系。

			Assert.AreEqual( actual: FDK.FDKUtilities.最大公約数を返す( 1, 1 ), expected: 1 );
			Assert.AreEqual( actual: FDK.FDKUtilities.最大公約数を返す( 1, 2 ), expected: 1 );
			Assert.AreEqual( actual: FDK.FDKUtilities.最大公約数を返す( 3, 1 ), expected: 1 );
			Assert.AreEqual( actual: FDK.FDKUtilities.最大公約数を返す( 630, 300 ), expected: 30 );

			// 準正常系。

			例外が出れば成功( () => { 結果 = FDK.FDKUtilities.最大公約数を返す( 1, 0 ); } );   // 0 の指定はダメ
			例外が出れば成功( () => { 結果 = FDK.FDKUtilities.最大公約数を返す( 1, -1 ); } );   // 負数の指定もダメ
		}

		[TestMethod()]
		public void 最小公倍数を返すTest()
		{
			int 結果 = 0;

			// 正常系。

			Assert.AreEqual( actual: FDK.FDKUtilities.最小公倍数を返す( 1, 1 ), expected: 1 );
			Assert.AreEqual( actual: FDK.FDKUtilities.最小公倍数を返す( 1, 2 ), expected: 2 );
			Assert.AreEqual( actual: FDK.FDKUtilities.最小公倍数を返す( 3, 1 ), expected: 3 );
			Assert.AreEqual( actual: FDK.FDKUtilities.最小公倍数を返す( 630, 300 ), expected: 6300 );

			// 準正常系。

			例外が出れば成功( () => { 結果 = FDK.FDKUtilities.最小公倍数を返す( 1, 0 ); } );   // 0 の指定はダメ
			例外が出れば成功( () => { 結果 = FDK.FDKUtilities.最小公倍数を返す( 1, -1 ); } );   // 負数の指定もダメ
		}

		[TestMethod()]
		public void 現在のメソッド名Test()
		{
			Assert.AreEqual(
				actual: FDK.FDKUtilities.現在のメソッド名,
				expected: typeof( FDKUtilitiesTests ).ToString() + @"." + nameof( 現在のメソッド名Test ) + @"()",
				ignoreCase: false );
		}

		[TestMethod()]
		public void 約分するTest()
		{
			var ret = FDKUtilities.約分する( 1, 1 );
			Assert.AreEqual( 1, ret.分子 );
			Assert.AreEqual( 1, ret.分母 );

			ret = FDKUtilities.約分する( 2, 3 );
			Assert.AreEqual( 2, ret.分子 );
			Assert.AreEqual( 3, ret.分母 );

			ret = FDKUtilities.約分する( 10, 5 );
			Assert.AreEqual( 2, ret.分子 );
			Assert.AreEqual( 1, ret.分母 );

			ret = FDKUtilities.約分する( 128, 120 );
			Assert.AreEqual( 16, ret.分子 );
			Assert.AreEqual( 15, ret.分母 );

			ret = FDKUtilities.約分する( 0, 100 );	// 分子が 0 なら 0/1 を返す。
			Assert.AreEqual( 0, ret.分子 );
			Assert.AreEqual( 1, ret.分母 );
		}
	}
}
