﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using SharpDX.DirectInput;
using FDK;
using FDK.カウンタ;
using FDK.メディア;
using FDK.同期;
using SST.曲;

namespace SST.ステージ.ユーザ
{
	class ユーザ選択ステージ : ステージ
	{
		public enum フェーズ
		{
			ログアウト,
			AutoPlayer選択,
			ユーザ一覧,
			ログイン,
			完了,
			キャンセル,
		}

		public フェーズ 現在のフェーズ
		{
			get;
			protected set;
		}


		public ユーザ選択ステージ()
		{
			this.子リスト.Add( this._ステージ台 = new 画像( @"$(System)images\ステージ台.png" ) );
			this.子リスト.Add( this._ドラムセット = new ドラムセット() );
			this.子リスト.Add( this._SelectYourStyle = new 画像( @"$(System)images\ユーザ画面 SelectYourStyle.png" ) );
			this.子リスト.Add( this._ユーザアイコン背景 = new 画像( @"$(System)images\ユーザ画面 アイコン背景.png" ) );
			this.子リスト.Add( this._テンプレート記号左 = new 画像( @"$(System)images\ユーザ画面 テンプレート記号左.png" ) );
			this.子リスト.Add( this._テンプレート記号右 = new 画像( @"$(System)images\ユーザ画面 テンプレート記号右.png" ) );
			this.子リスト.Add( this._SSTロゴ = new 画像( @"$(System)images\ユーザ画面 SSTロゴ.png" ) );
			this.子リスト.Add( this._背景動画 = new 動画( @"$(System)images\ユーザ画面BGV.mp4" ) );
			this.子リスト.Add( this._既定のユーザアイコン = new 画像( @"$(System)images\ユーザ画面 既定のアイコン.png" ) );
			this.子リスト.Add( this._FPS = new FPS() );
		}

		protected override void On活性化( グラフィックデバイス gd )
		{
			using( Log.Block( FDKUtilities.現在のメソッド名 ) )
			{
				this.現在のフェーズ = フェーズ.ログアウト;

				this._活性化した直後である = true;
			}
		}

		protected override void On非活性化( グラフィックデバイス gd )
		{
			using( Log.Block( FDKUtilities.現在のメソッド名 ) )
			{
				this.現在のフェーズ = フェーズ.完了;

				this._活性化した直後である = false;
			}
		}

		public override void 進行描画する( グラフィックデバイス gd )
		{
			Debug.Assert( this.活性化している );
			Debug.Assert( null != gd );

			if( this._活性化した直後である )
			{
				this._活性化した直後である = false;
				this._背景動画.再生を開始する( 開始位置sec: 0.0, ループ再生する: true );
			}

			this._FPS.VPSをカウントする();
			this._FPS.FPSをカウントしプロパティを更新する();

			App.入力管理.すべての入力デバイスをポーリングする();

			switch( this.現在のフェーズ )
			{
				case フェーズ.ログアウト:
					App.ユーザ管理.ログアウトする( gd );
					this.現在のフェーズ = ( App.ビュアーモードである ) ?
						フェーズ.AutoPlayer選択 :     // ビュアーモードでは常に AutoPlayer でログインする。
						フェーズ.ユーザ一覧;
					break;

				case フェーズ.AutoPlayer選択:
					App.ユーザ管理.ユーザを選択する( Properties.Resources.AUTOPLAYER );
					this.現在のフェーズ = フェーズ.ログイン;
					break;

				case フェーズ.ユーザ一覧:
					#region " 描画 "
					//----------------
					{
						this._背景動画.描画する( gd, new SharpDX.RectangleF( 0f, 0f, gd.設計画面サイズ.Width, gd.設計画面サイズ.Height ) );

						this._ステージ台.描画する( gd, 0, 0 );
						this._ドラムセット.進行描画する( gd );

						var user = App.ユーザ管理.選択されているユーザ;

						this._SelectYourStyle.描画する( gd, 711f, 184f );
						this._ユーザアイコン背景.描画する( gd, 445f, 377f );

						var icon = ( user.写真.生成成功 ) ? user.写真 : this._既定のユーザアイコン;
						icon.描画する( gd, 453, 385f,
							X方向拡大率: ( this._既定のユーザアイコン.サイズ.Width / icon.サイズ.Width ),
							Y方向拡大率: ( this._既定のユーザアイコン.サイズ.Height / icon.サイズ.Height ) );

						this._テンプレート記号左.描画する( gd, 748f, 329f );
						this._テンプレート記号右.描画する( gd, 748f + user.名前画像.サイズ.Width + this._テンプレート記号右.サイズ.Width / 3f, 329f );

						this._SSTロゴ.描画する( gd, 707f, 352f );

						user.名前画像.描画する( gd, 848f, 480f );

						this._FPS.描画する( gd );
					}
					//----------------
					#endregion
					#region " 入力 "
					//----------------
					if( App.入力管理.キーボードデバイス.キーが押された( 0, Key.Escape ) )
					{
						#region " ESC → キャンセル "
						//----------------
						this.現在のフェーズ = フェーズ.キャンセル;
						//----------------
						#endregion
					}
					else if( App.入力管理.シンバルが入力された() )
					{
						#region " シンバル類 → ユーザ決定、ログイン "
						//----------------
						if( null != App.ユーザ管理.選択されているユーザ )
						{
							this.現在のフェーズ = フェーズ.ログイン;
						}
						else
						{
							Log.ERROR( "ユーザが選択されていません。" );
						}
						//----------------
						#endregion
					}
					else if(
						App.入力管理.ドラムが入力された( 入力.ドラム入力種別.Snare ) ||
						App.入力管理.ドラムが入力された( 入力.ドラム入力種別.Snare_ClosedRim ) ||
						App.入力管理.ドラムが入力された( 入力.ドラム入力種別.Snare_OpenRim ) ||
						App.入力管理.キーボードデバイス.キーが押された( 0, Key.Left ) )
					{
						#region " 左 or スネア → 前のユーザへ "
						//----------------
						App.ユーザ管理.ひとつ前のユーザを選択する();
						//----------------
						#endregion
					}
					else if(
						App.入力管理.ドラムが入力された( 入力.ドラム入力種別.Tom3 ) ||
						App.入力管理.ドラムが入力された( 入力.ドラム入力種別.Tom3_Rim ) ||
						App.入力管理.キーボードデバイス.キーが押された( 0, Key.Right ) )
					{
						#region " 右 or Tom3 → 次のユーザへ "
						//----------------
						App.ユーザ管理.ひとつ後のユーザを選択する();
						//----------------
						#endregion
					}
					foreach( var ev in App.入力管理.MIDI入力デバイス.入力イベントリスト.Where( ( ie ) => ( 255 == ie.Key ) ) )
					{
						#region " ハイハットの開閉 "
						//----------------
						this._ドラムセット.ハイハットのベロシティ = ev.Velocity;
						//----------------
						#endregion
					}
					//----------------
					#endregion
					break;

				case フェーズ.ログイン:
					App.ユーザ管理.ログインする( gd );
					this.現在のフェーズ = フェーズ.完了;
					break;

				case フェーズ.完了:
				case フェーズ.キャンセル:
					break;
			}
		}


		private bool _活性化した直後である = true;

		private 画像 _ステージ台 = null;

		private ドラムセット _ドラムセット = null;

		private 画像 _SelectYourStyle = null;

		private 画像 _ユーザアイコン背景 = null;

		private 画像 _テンプレート記号左 = null;

		private 画像 _テンプレート記号右 = null;

		private 画像 _SSTロゴ = null;

		private 動画 _背景動画 = null;

		private 画像 _既定のユーザアイコン = null;

		private FPS _FPS = null;
	}
}
