﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Runtime.Serialization;
using FDK;

using ヒットランク種別 = SST.ステージ.演奏.ヒットランク種別;
using 動画表示パターン種別 = SST.ステージ.演奏.動画表示パターン種別;

namespace SST.設定
{
	/// <summary>
	///		オプション設定。
	///		SSTユーザごとに設定。
	/// </summary>
	[DataContract( Name = "Options", Namespace = "" )]
	[KnownType( typeof( 表示レーンの左右 ) )]
	[KnownType( typeof( ヒットランク種別 ) )]
	[KnownType( typeof( AutoPlay種別 ) )]
	[KnownType( typeof( 動画表示パターン種別 ) )]
	class オプション設定 : IExtensibleDataObject
	{
		/// <summary>
		///		演奏画面で左右（シンバル）レーンに配置できるチップの位置指定。
		/// </summary>
		[DataMember]
		public 表示レーンの左右 表示レーンの左右 { get; set; }

		/// <summary>
		///		チップが判定バーから（上または下に）どれだけ離れていると Perfect ～ Poor 判定になるのかの定義。秒単位。
		/// </summary>
		[DataMember]
		public Dictionary<ヒットランク種別, double> 最大ヒット距離sec { get; set; }

		/// <summary>
		///		AutoPlay 設定。
		/// </summary>
		[DataMember]
		public Dictionary<AutoPlay種別, bool> AutoPlay { get; set; }

		/// <summary>
		///		演奏画面での譜面スクロール速度の倍率。1.0 で等倍。
		/// </summary>
		[DataMember]
		public double 譜面スクロール速度の倍率 { get; set; }

		/// <summary>
		///		演奏動画の表示パターン。
		/// </summary>
		[DataMember]
		public 動画表示パターン種別 動画表示パターン種別 { get; set; }

		/// <summary>
		///		true なら、LeftCrash・RightCrash・Ride・China・Splash・HiHat（Close,Open,Foot）の入力としての区別がなくなり、
		///		いずれの入力でもいずれのチップをヒットできるようになる。
		/// </summary>
		[DataMember]
		public bool シンバルフリー { get; set; }

		public ドラムとチップと入力の対応表 ドラムとチップと入力の対応表
		{
			get;
			protected set;
		} = null;


		/// <summary>
		///		コンストラクタ。
		/// </summary>
		public オプション設定()
		{
			using( Log.Block( FDKUtilities.現在のメソッド名 ) )
			{
				this._既定値で初期化する( new StreamingContext() );
			}
		}

		/// <summary>
		///		AutoPlay の設定値をまとめて変更する。
		/// </summary>
		/// <param name="設定値">すべてのレーンに設定する値。</param>
		/// <remarks>
		///		ただし、Unknown は除く。
		/// </remarks>
		public void AutoPlayを一括設定する( bool 設定値 )
		{
			using( Log.Block( FDKUtilities.現在のメソッド名 ) )
			{
				foreach( AutoPlay種別 apt in Enum.GetValues( typeof( AutoPlay種別 ) ) )
				{
					if( apt == AutoPlay種別.Unknown )
						continue;

					this.AutoPlay[ apt ] = 設定値;
				}
			}
		}

		/// <summary>
		///		ファイルに保存する。
		/// </summary>
		/// <param name="ユーザフォルダパス">ユーザフォルダのパス。ユーザ名の部分は、ファイル名やパスで使える文字に調整済みであること。</param>
		public void 保存する( string ユーザフォルダパス )
		{
			using( Log.Block( FDKUtilities.現在のメソッド名 ) )
			{
				if( false == Directory.Exists( ユーザフォルダパス ) )
					Directory.CreateDirectory( ユーザフォルダパス ); // 失敗したら例外発生。

				var path = Path.Combine( ユーザフォルダパス, _Optionファイル名 );
				FDKUtilities.保存する( this, path );
			}
		}

		/// <summary>
		///		ファイルから復元する。
		/// </summary>
		/// <param name="ユーザフォルダパス">ユーザフォルダのパス。ユーザ名の部分は、ファイル名やパスで使える文字に調整済みであること。</param>
		public static オプション設定 復元する( string ユーザフォルダパス )
		{
			using( Log.Block( FDKUtilities.現在のメソッド名 ) )
			{
				var path = Path.Combine( ユーザフォルダパス, _Optionファイル名 );
				var options = FDKUtilities.復元または新規作成する<オプション設定>( path );

				options.ドラムとチップと入力の対応表 = new ドラムとチップと入力の対応表( options.表示レーンの左右 );

				// ファイルに反映されていないメンバはいつまでも反映されないので、ここで一度、明示的に保存することにする。
				options.保存する( ユーザフォルダパス );

				return options;
			}
		}


		/// <summary>
		///		オプション設定を保存するファイルのパス。
		/// </summary>
		private static readonly string _Optionファイル名 = @"Options.json";        // パスなし

		private Dictionary<ヒットランク種別, double> _最大ヒット距離secの既定値 = null;

		/// <summary>
		///		コンストラクタ時、または逆シリアル化時のメンバの既定値を設定する。
		/// </summary>
		/// <param name="sc">未使用。</param>
		/// <remarks>
		///		.NET 既定の初期値だと支障のある（逆シリアル化対象の）メンバがあれば、ここで初期化しておくこと。
		/// </remarks>
		[OnDeserializing]
		private void _既定値で初期化する( StreamingContext sc )
		{
			using( Log.Block( FDKUtilities.現在のメソッド名 ) )
			{
				this.表示レーンの左右 = new 表示レーンの左右() {
					Rideは左 = false, // 右
					Chinaは左 = false,    // 右
					Splashは左 = true,    // 左
				};

				this.ドラムとチップと入力の対応表 = new ドラムとチップと入力の対応表( this.表示レーンの左右 );

				// ※メンバ初期化子で設定してはならない。（OnDeserializing 時にはコンストラクタが呼び出されない。）
				this._最大ヒット距離secの既定値 = new Dictionary<ヒットランク種別, double>() {
					{ ヒットランク種別.PERFECT, 0.034 },
					{ ヒットランク種別.GREAT, 0.067 },
					{ ヒットランク種別.GOOD, 0.084 },
					{ ヒットランク種別.POOR, 0.117 },
					{ ヒットランク種別.MISS, double.NaN },  // 使わない
					{ ヒットランク種別.AUTO, double.NaN },  // 使わない
				};

				this.最大ヒット距離sec = new Dictionary<ヒットランク種別, double>();
				foreach( ヒットランク種別 hitRankType in Enum.GetValues( typeof( ヒットランク種別 ) ) )
					this.最大ヒット距離sec[ hitRankType ] = this._最大ヒット距離secの既定値[ hitRankType ];

				this.AutoPlay = new Dictionary<AutoPlay種別, bool>();
				foreach( AutoPlay種別 autoPlayType in Enum.GetValues( typeof( AutoPlay種別 ) ) )
					this.AutoPlay[ autoPlayType ] = false;

				this.譜面スクロール速度の倍率 = 1.0;
				this.動画表示パターン種別 = 動画表示パターン種別.中央表示;
				this.シンバルフリー = false;
			}
		}

		#region " IExtensibleDataObject の実装 "
		//----------------
		private ExtensionDataObject _ExData;

		public virtual ExtensionDataObject ExtensionData
		{
			get
				=> this._ExData;

			set
				=> this._ExData = value;
		}
		//----------------
		#endregion
	}
}
