#include "stdafx.h"
#include "DrawTexture.h"

namespace FDK
{
// public:

	void DrawTexture::t3D`( IDirect3DDevice9 *pDevice, IDirect3DTexture9* pTexture, int nx0to255, bool bZ, D3DMATRIX* pMatrix, LPRECT prc摜̕`̈ )
	{
		HRESULT hr = S_OK;

		if( pDevice == NULL || pTexture == NULL )
			return;

		D3DSURFACE_DESC desc;
		if( FAILED( pTexture->GetLevelDesc( 0, &desc ) ) )
			return;

		float x = ( (float) ( prc摜̕`̈->right - prc摜̕`̈->left ) ) / 2.0f;
		float y = ( (float) ( prc摜̕`̈->bottom - prc摜̕`̈->top ) ) / 2.0f;
		float z = 0.0f;
		float fUl = ( (float) prc摜̕`̈->left ) / ( (float) desc.Width );
		float fEUl = ( (float) prc摜̕`̈->right ) / ( (float) desc.Width );
		float fVl = ( (float) prc摜̕`̈->top ) / ( (float) desc.Height );
		float fVl = ( (float) prc摜̕`̈->bottom ) / ( (float) desc.Height );
		DWORD color = ((DWORD)(nx0to255) << 24) | 0x00FFFFFF;

		pPositionColoredVertexies[ 0 ].u = fUl;
		pPositionColoredVertexies[ 0 ].v = fVl;
		pPositionColoredVertexies[ 0 ].x = -x;
		pPositionColoredVertexies[ 0 ].y = y;
		pPositionColoredVertexies[ 0 ].z = z;
		pPositionColoredVertexies[ 0 ].color = color;

		pPositionColoredVertexies[ 1 ].u = fEUl;
		pPositionColoredVertexies[ 1 ].v = fVl;
		pPositionColoredVertexies[ 1 ].x = x;
		pPositionColoredVertexies[ 1 ].y = y;
		pPositionColoredVertexies[ 1 ].z = z;
		pPositionColoredVertexies[ 1 ].color = color;

		pPositionColoredVertexies[ 2 ].u = fUl;
		pPositionColoredVertexies[ 2 ].v = fVl;
		pPositionColoredVertexies[ 2 ].x = -x;
		pPositionColoredVertexies[ 2 ].y = -y;
		pPositionColoredVertexies[ 2 ].z = z;
		pPositionColoredVertexies[ 2 ].color = color;

		pPositionColoredVertexies[ 3 ].u = fEUl;
		pPositionColoredVertexies[ 3 ].v = fVl;
		pPositionColoredVertexies[ 3 ].x = x;
		pPositionColoredVertexies[ 3 ].y = -y;
		pPositionColoredVertexies[ 3 ].z = z;
		pPositionColoredVertexies[ 3 ].color = color;
				
		DrawTexture::t_OXe[g̐ݒ( pDevice, bZ );
		pDevice->SetTransform( D3DTS_WORLD, pMatrix );
		pDevice->SetTexture( 0, pTexture );
		pDevice->SetFVF( D3DFVF_XYZ | D3DFVF_DIFFUSE | D3DFVF_TEX1 );
		pDevice->DrawPrimitiveUP( D3DPT_TRIANGLESTRIP, 2, pPositionColoredVertexies, sizeof(STPositionColoredVertexies) );
	}
	void DrawTexture::t3D`( IDirect3DDevice9 *pDevice, IDirect3DTexture9* pTexture, int nx0to255, bool bZ, D3DMATRIX* pMatrix )
	{
		if( pTexture == NULL )
			return;

		D3DSURFACE_DESC desc;
		pTexture->GetLevelDesc( 0, &desc );
		RECT rcS摜;
		rcS摜.left = 0;
		rcS摜.top = 0;
		rcS摜.right = desc.Width;
		rcS摜.bottom = desc.Height;

		t3D`( pDevice, pTexture, nx0to255, bZ, pMatrix, &rcS摜 );
	}

	void DrawTexture::t2D`( IDirect3DDevice9 *pDevice, IDirect3DTexture9* pTexture, int nx0to255, bool bZ, float fgk{X, float fgk{Y, int x, int y, float depth, LPRECT prc摜̕`̈ )
	{
		HRESULT hr = S_OK;

		if( pDevice == NULL || pTexture == NULL )
			return;

		D3DSURFACE_DESC desc;
		pTexture->GetLevelDesc( 0, &desc );

		float fx = x - 0.5f;	// -0.5 ͍WƃsNŽ덷z邽߂̍W␳lB(MSDNQ)
		float fy = y - 0.5f;	//
		float w = ( prc摜̕`̈->right - prc摜̕`̈->left ) * fgk{X;
		float h = ( prc摜̕`̈->bottom - prc摜̕`̈->top ) * fgk{Y;
		float fUl = ( (float) prc摜̕`̈->left ) / ( (float) desc.Width );
		float fEUl = ( (float) prc摜̕`̈->right ) / ( (float) desc.Width );
		float fVl = ( (float) prc摜̕`̈->top ) / ( (float) desc.Height );
		float fVl = ( (float) prc摜̕`̈->bottom ) / ( (float) desc.Height );
		DWORD color = ((DWORD)(nx0to255) << 24) | 0x00FFFFFF;

		pTransformedColoredTexturedVertexies[ 0 ].u = fUl;
		pTransformedColoredTexturedVertexies[ 0 ].v = fVl;
		pTransformedColoredTexturedVertexies[ 0 ].x = fx;
		pTransformedColoredTexturedVertexies[ 0 ].y = fy;
		pTransformedColoredTexturedVertexies[ 0 ].z = depth;
		pTransformedColoredTexturedVertexies[ 0 ].w = 1.0f;
		pTransformedColoredTexturedVertexies[ 0 ].color = color;

		pTransformedColoredTexturedVertexies[ 1 ].u = fEUl;
		pTransformedColoredTexturedVertexies[ 1 ].v = fVl;
		pTransformedColoredTexturedVertexies[ 1 ].x = fx + w;
		pTransformedColoredTexturedVertexies[ 1 ].y = fy;
		pTransformedColoredTexturedVertexies[ 1 ].z = depth;
		pTransformedColoredTexturedVertexies[ 1 ].w = 1.0f;
		pTransformedColoredTexturedVertexies[ 1 ].color = color;

		pTransformedColoredTexturedVertexies[ 2 ].u = fUl;
		pTransformedColoredTexturedVertexies[ 2 ].v = fVl;
		pTransformedColoredTexturedVertexies[ 2 ].x = fx;
		pTransformedColoredTexturedVertexies[ 2 ].y = fy + h;
		pTransformedColoredTexturedVertexies[ 2 ].z = depth;
		pTransformedColoredTexturedVertexies[ 2 ].w = 1.0f;
		pTransformedColoredTexturedVertexies[ 2 ].color = color;

		pTransformedColoredTexturedVertexies[ 3 ].u = fEUl;
		pTransformedColoredTexturedVertexies[ 3 ].v = fVl;
		pTransformedColoredTexturedVertexies[ 3 ].x = fx + w;
		pTransformedColoredTexturedVertexies[ 3 ].y = fy + h;
		pTransformedColoredTexturedVertexies[ 3 ].z = depth;
		pTransformedColoredTexturedVertexies[ 3 ].w = 1.0f;
		pTransformedColoredTexturedVertexies[ 3 ].color = color;

		DrawTexture::t_OXe[g̐ݒ( pDevice, bZ );
		pDevice->SetTexture( 0, pTexture );
		pDevice->SetFVF( D3DFVF_XYZRHW | D3DFVF_DIFFUSE | D3DFVF_TEX1 );
		pDevice->DrawPrimitiveUP( D3DPT_TRIANGLESTRIP, 2, pTransformedColoredTexturedVertexies, sizeof(STTransformedColoredTextureVertexies) );
	}
	void DrawTexture::t2D`( IDirect3DDevice9 *pDevice, IDirect3DTexture9* pTexture, int nx0to255, bool bZ, float fgk{X, float fgk{Y, int x, int y, LPRECT prc摜̕`̈ )
	{
		t2D`( pDevice, pTexture, nx0to255, bZ, fgk{X, fgk{Y, x, y, 1.0f, prc摜̕`̈ );
	}
	void DrawTexture::t2D`( IDirect3DDevice9 *pDevice, IDirect3DTexture9* pTexture, int nx0to255, bool bZ, float fgk{X, float fgk{Y, int x, int y )
	{
		if( pDevice == NULL || pTexture == NULL )
			return;

		D3DSURFACE_DESC desc;
		pTexture->GetLevelDesc( 0, &desc );

		RECT rc摜̕`̈;
		rc摜̕`̈.left = 0;
		rc摜̕`̈.top = 0;
		rc摜̕`̈.right = desc.Width;
		rc摜̕`̈.bottom = desc.Height;
				
		t2D`( pDevice, pTexture, nx0to255, bZ, fgk{X, fgk{Y, x, y, &rc摜̕`̈ );
	}
	void DrawTexture::t2D`( IDirect3DDevice9 *pDevice, IDirect3DTexture9* pTexture, int nx0to255, bool bZ, float fgk{X, float fgk{Y, Point pt, float depth, LPRECT prc摜̕`̈ )
	{
		t2D`( pDevice, pTexture, nx0to255, bZ, fgk{X, fgk{Y, pt.X, pt.Y, depth, prc摜̕`̈ );
	}
	void DrawTexture::t2D`( IDirect3DDevice9 *pDevice, IDirect3DTexture9* pTexture, int nx0to255, bool bZ, float fgk{X, float fgk{Y, Point pt, LPRECT prc摜̕`̈ )
	{
		t2D`( pDevice, pTexture, nx0to255, bZ, fgk{X, fgk{Y, pt.X, pt.Y, 1.0f, prc摜̕`̈ );
	}
	void DrawTexture::t2D`( IDirect3DDevice9 *pDevice, IDirect3DTexture9* pTexture, int nx0to255, bool bZ, float fgk{X, float fgk{Y, Point pt )
	{
		if( pDevice == NULL || pTexture == NULL )
			return;

		D3DSURFACE_DESC desc;
		pTexture->GetLevelDesc( 0, &desc );

		RECT rc摜̕`̈;
		rc摜̕`̈.left = 0;
		rc摜̕`̈.top = 0;
		rc摜̕`̈.right = desc.Width;
		rc摜̕`̈.left = 0;

		t2D`( pDevice, pTexture, nx0to255, bZ, fgk{X, fgk{Y, pt.X, pt.Y, 1.0f, &rc摜̕`̈ );
	}

// protected:

	STPositionColoredVertexies				DrawTexture::pPositionColoredVertexies[ 4 ];
	STTransformedColoredTextureVertexies	DrawTexture::pTransformedColoredTexturedVertexies[ 4 ];

	void DrawTexture::t_OXe[g̐ݒ( IDirect3DDevice9 *pDevice, bool bZ )
	{
		if( bZ )
		{
			pDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );
			pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );
			pDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );
		}
		else
		{
			pDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );
			pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );
			pDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );
		}
	}
}
