#include "stdafx.h"
#include "CMediaSessionNative.h"
#include "CustomEVRPresenter.h"
#include "CustomGUID.h"

namespace FDK
{
	CMediaSessionNative* CMediaSessionNative::Instances[ MAX_INSTANCE ];
	bool CMediaSessionNative::bIntances͖ = true;
	CritSec CMediaSessionNative::csInstances;

	CMediaSessionNative* CMediaSessionNative::tIDCX^X擾( int id )
	{
		AutoLock lock( CMediaSessionNative::csInstances );

		if( id >= 0 && id < MAX_INSTANCE )
			return CMediaSessionNative::Instances[ id ];

		return NULL;
	}

	CMediaSessionNative::CMediaSessionNative()
	{
		this->t();
	}
	CMediaSessionNative::CMediaSessionNative( HWND hWnd, LPCWSTR stgt@C, bool b, bool b[v )
	{
		this->t();
		this->t\z( hWnd, stgt@C, b, b[v );
	}
	CMediaSessionNative::~CMediaSessionNative()
	{
		this->tj();

		::CloseHandle( this->evMESessionClosed );
		::CloseHandle( this->evMESessionTopologyStatus_MF_TOPOSTATUS_READY );
		::CloseHandle( this->evMESessionStarted );
		::CloseHandle( this->evMESessionStopped );

		#pragma region [ nInstanceID B]
		//-----------------
		for( int i = 0; i < MAX_INSTANCE; i++ )
		{
			if( Instances[ i ] == this )
			{
				Instances[ i ] = NULL;
				break;
			}
		}
		//-----------------
		#pragma endregion
	}

	void CMediaSessionNative::t()
	{
		this->pMediaSession = NULL;
		this->pMediaSource = NULL;
		this->pControl = NULL;
		this->pAttributes = NULL;

		this->csMediaSessionXe[^X.Lock();
		this->eMediaSessionXe[^X = EMediaSessionXe[^X::ĐI;
		this->csMediaSessionXe[^X.Unlock();

		this->evMESessionClosed								= ::CreateEvent( NULL, TRUE, FALSE, L"MediaSessionN[Yꂽ"  );
		this->evMESessionTopologyStatus_MF_TOPOSTATUS_READY	= ::CreateEvent( NULL, TRUE, FALSE, L"g|W" );
		this->evMESessionStarted							= ::CreateEvent( NULL, TRUE, FALSE, L"v[^`Jn" );
		this->evMESessionStopped							= ::CreateEvent( NULL, TRUE, FALSE, L"Đ~" );

		this->nQƃJE^ = 1;
		this->b[v = false;

		this->stgt@C[ 0 ] = '\0';

		#pragma region [ Instances[] ̏B]
		//-----------------
		if( bIntances͖ )
		{
			for( int i = 0; i < MAX_INSTANCE; i++ )
				Instances[ i ] = NULL;

			bIntances͖ = false;
		}
		//-----------------
		#pragma endregion
		#pragma region [ nInstanceID 擾B]
		//-----------------
		CMediaSessionNative::csInstances.Lock();
		this->nInstanceID = -1;
		for( int i = 0; i < MAX_INSTANCE; i++ )
		{
			if( Instances[ i ] == NULL )
			{
				Instances[ i ] = this;
				this->nInstanceID = i;
				break;
			}
		}
		CMediaSessionNative::csInstances.Unlock();
		//-----------------
		#pragma endregion
	}
	void CMediaSessionNative::t\z( HWND hWnd, LPCWSTR stgt@C, bool b, bool b[v )
	{
		HRESULT hr = S_OK;
		IMFPresentationDescriptor *pv[e[VLqq = NULL;
		IMFTopology *pTopology = NULL;
		DWORD dwXg[ = 0;

		#pragma region [ t@CۑB]
		//-----------------
		{
			TCHAR stgDrive[ _MAX_DRIVE ];
			TCHAR stgDir[ _MAX_DIR ];
			TCHAR stgFname[ _MAX_FNAME ];
			TCHAR stgExt[ _MAX_EXT ];
			_wsplitpath_s( stgt@C, stgDrive, _MAX_DRIVE, stgDir, _MAX_DIR, stgFname, _MAX_FNAME, stgExt, _MAX_EXT );
			swprintf_s( this->stgt@C, MAX_PATH, L"%s%s", stgFname, stgExt );
		}
		//-----------------
		#pragma endregion

		this->tj();

		this->b[v = b[v;
		::ResetEvent( this->evMESessionTopologyStatus_MF_TOPOSTATUS_READY );

		try
		{
			// MediaSession 쐬B

			#pragma region [ MediaSession 쐬ACxg擾JnB]
			//-----------------
			tFAILEDȂO( L"MediaSession ̍쐬",
				hr = ::MFCreateMediaSession( NULL, &(this->pMediaSession) ) );

			tFAILEDȂO( L"MediaSession ւ̃R[obNIuWFNg̓o^", 
				hr = this->pMediaSession->BeginGetEvent( this, NULL ) );
			//-----------------
			#pragma endregion

			
			// fBA\[X쐬B

			#pragma region [ fBA\[X쐬istgt@CjB]
			//-----------------
			{
				IMFSourceResolver *pSourceResolver = NULL;
				IUnknown *pSourceObjectIUnknown = NULL;

				try
				{
					// \[X]o쐬B

					tFAILEDȂO( L"\[X]o̍쐬",
						hr = ::MFCreateSourceResolver( &pSourceResolver ) );
		
					
					// \[XIuWFNg IUnknown Ŏ擾B
					
					MF_OBJECT_TYPE eObjectType = MF_OBJECT_INVALID;
					tFAILEDȂO( L"IMFSourceResolver::CreateObjectFromURL() ",
						hr = pSourceResolver->CreateObjectFromURL( stgt@C, MF_RESOLUTION_MEDIASOURCE, NULL, &eObjectType, &pSourceObjectIUnknown ) );

					
					// IUnknown  IMFMediaSource 擾B

					tFAILEDȂO( L"\[XIuWFNg IUnknown  IMFMediaSource ̎擾",
						hr = pSourceObjectIUnknown->QueryInterface( IID_IMFMediaSource, (void**) &(this->pMediaSource) ) );
				}
				finally
				{
					// \[X]oB

					COM_SAFE_RELEASE( pSourceObjectIUnknown );
					COM_SAFE_RELEASE( pSourceResolver );
				}
			}
			//-----------------
			#pragma endregion
			#pragma region [ fBA\[X̃v[e[VLqq擾ifBA\[XjB]
			//-----------------
			tFAILEDȂO( L"fBA\[X̃v[e[VLqq̎擾",
				hr = this->pMediaSource->CreatePresentationDescriptor( &pv[e[VLqq ) );
			//-----------------
			#pragma endregion
			#pragma region [ fBA\[X̃Xg[擾iv[e[VLqqjB]
			//-----------------
			tFAILEDȂO( L"fBA\[X̃Xg[̎擾",
				hr = pv[e[VLqq->GetStreamDescriptorCount( &dwXg[ ) );
			//-----------------
			#pragma endregion


			// g|W쐬B

			#pragma region [ Vg|W쐬B]
			//-----------------
			tFAILEDȂO( L"Vg|W̍쐬",
				hr = ::MFCreateTopology( &pTopology ) );
			//-----------------
			#pragma endregion
			#pragma region [ ׂẴXg[g|Wɓo^B]
			//-----------------
			for( DWORD dwXg[ԍ = 0; dwXg[ԍ < dwXg[; dwXg[ԍ++ )
			{
				IMFStreamDescriptor *pXg[Lqq = NULL;
				IMFTopologyNode *pXg[̃\[Xm[h = NULL;
				IMFTopologyNode *pXg[̏o̓m[h = NULL;
				GUID guidMajorType;

				try
				{
					#pragma region [ Xg[Lqq擾B]
					//-----------------
					{
						BOOL bXg[IĂ = FALSE;

						tFAILEDȂO( L"݂̃Xg[ԍɑΉXg[Lqq̎擾",
							hr = pv[e[VLqq->GetStreamDescriptorByIndex( dwXg[ԍ, &bXg[IĂ, &pXg[Lqq ) );
							
						if( !bXg[IĂ )
							continue;		// IĂȂXg[ȂΖB
					}
					//-----------------
					#pragma endregion

					#pragma region [ Xg[̃\[Xm[h쐬B]
					//-----------------
					tFAILEDȂO( L"V\[Xm[hi\[XXg[m[hj̍쐬",
						hr = ::MFCreateTopologyNode( MF_TOPOLOGY_SOURCESTREAM_NODE, &pXg[̃\[Xm[h ) );

					// K{̂Rݒ肷B

					tFAILEDȂO( L"\[Xm[h̑ւ̃fBA\[X̓o^",
						hr = pXg[̃\[Xm[h->SetUnknown( MF_TOPONODE_SOURCE, this->pMediaSource ) );

					tFAILEDȂO( L"\[Xm[h̑ւ̃v[e[VLqq̓o^",
						hr = pXg[̃\[Xm[h->SetUnknown( MF_TOPONODE_PRESENTATION_DESCRIPTOR, pv[e[VLqq ) );

					tFAILEDȂO( L"\[Xm[h̑ւ̃Xg[Lqq̓o^",
						hr = pXg[̃\[Xm[h->SetUnknown( MF_TOPONODE_STREAM_DESCRIPTOR, pXg[Lqq ) );
					//-----------------
					#pragma endregion

					#pragma region [ Xg[̏o̓m[h쐬B]
					//-----------------
					{
						IMFActivate *pRendererActivate = NULL;

						try
						{
							#pragma region [ Vo̓m[h쐬B]
							//-----------------
							tFAILEDȂO( L"Vo̓m[h̍쐬",
								hr = MFCreateTopologyNode( MF_TOPOLOGY_OUTPUT_NODE, &pXg[̏o̓m[h ) );
							//-----------------
							#pragma endregion

							#pragma region [ Xg[̃W[^Cv擾B]
							//-----------------
							{
								IMFMediaTypeHandler *pMediaTypeHandler = NULL;

								try
								{
									tFAILEDȂO( L"Xg[̃fBA^Cvnh̎擾",
										hr = pXg[Lqq->GetMediaTypeHandler( &pMediaTypeHandler ) );

									tFAILEDȂO( L"fBA^Cvnh̃W[^CvGUID̎擾",
										hr = pMediaTypeHandler->GetMajorType( &guidMajorType ) );
								}
								finally
								{
									COM_SAFE_RELEASE( pMediaTypeHandler );
								}
							}
							//-----------------
							#pragma endregion

							#pragma region [ rfI or I[fBI_ANeBx[g쐬B]
							//-----------------
							if( MFMediaType_Audio == guidMajorType )
							{
								#pragma region [ (A) I[fBI_ANeBx[g̍쐬 ]
								//-----------------
								tFAILEDȂO( L"I[fBI_ IMFActive ̍쐬",
									hr = MFCreateAudioRendererActivate( &pRendererActivate ) );
								//-----------------
								#pragma endregion
							}
							else if( MFMediaType_Video == guidMajorType )
							{
								#pragma region [ (B) rfI_(EVR)ANeBx[g with JX^v[^ ̍쐬 ]
								//-----------------
								IUnknown *pActivate = NULL;
								
								try
								{
									// rfI_ANeBx[g쐬B

									tFAILEDȂO( L"rfI_ IMFActivate ̍쐬",
										hr = ::MFCreateVideoRendererActivate( hWnd, &pRendererActivate ) );


									// JX^v[^ANeBx[g𐶐B

									CustomEVRPresenter::CreateInstance( NULL, IID_IUnknown, (void**) &pActivate );


									// JX^v[^ANeBx[g_ANeBx[gɓo^B

									tFAILEDȂO( L"_ւ̃JX^v[^̐ݒ", 
										hr = pRendererActivate->SetUnknown( MF_ACTIVATE_CUSTOM_VIDEO_PRESENTER_ACTIVATE, pActivate) );
								}
								finally
								{
									COM_SAFE_RELEASE( pActivate );
								}
								//-----------------
								#pragma endregion
							}
							else
								tHRESULTtO( MF_E_INVALIDTYPE, L"m̃fBA^CvłB" );
							//-----------------
							#pragma endregion
					
							#pragma region [ rfI or I[fBI_ANeBx[go̓m[h֐ݒB]
							//-----------------
							tFAILEDȂO( L"쐬 IMFActivate ̏o̓m[hւ̐ݒ",
								hr = pXg[̏o̓m[h->SetObject( pRendererActivate ) );
							//-----------------
							#pragma endregion
						}
						finally
						{
							COM_SAFE_RELEASE( pRendererActivate );
						}
					}
					//-----------------
					#pragma endregion

					if( b || guidMajorType != MFMediaType_Audio )	// ȂȂI[fBI_͒ǉȂB
					{
						// MediaFoundation  SAR WASAPIL[hgpB̎_ŊWASAPIr[hғĂꍇ́Ag|WɃnOAbv̂ŒӁB

						#pragma region [ \[Xm[hƏo̓m[hg|WɒǉĐڑB]
						//-----------------
						tFAILEDȂO( L"g|Wւ̃\[Xm[h̒ǉ",
							hr = pTopology->AddNode( pXg[̃\[Xm[h ) );
				
						tFAILEDȂO( L"g|Wւ̏o̓m[h̒ǉ",
							hr = pTopology->AddNode( pXg[̏o̓m[h ) );

						DWORD dwo̓CfbNX = 0;
						DWORD dwo̓m[h̓̓CfbNX = 0;
						tFAILEDȂO( L"g|Wł̃m[hԂ̐ڑ",
							hr = pXg[̃\[Xm[h->ConnectOutput( dwo̓CfbNX, pXg[̏o̓m[h, dwo̓m[h̓̓CfbNX ) );
						//-----------------
						#pragma endregion
					}
				}
				finally
				{
					COM_SAFE_RELEASE( pXg[Lqq );
					COM_SAFE_RELEASE( pXg[̃\[Xm[h );
					COM_SAFE_RELEASE( pXg[̏o̓m[h );
				}
			}
			//-----------------
			#pragma endregion


			// g|W MediaSession ɓo^B

			#pragma region [ g|W MediaSession ɓo^B ]
			//-----------------
			tFAILEDȂO( L"MediaSession ւ̃g|W̓o^",
				hr = this->pMediaSession->SetTopology( 0, pTopology ) );
			//-----------------
			#pragma endregion
			#pragma region [ g|W̊҂B]
			//-----------------

			// nOAbvӘ^F
			//@Eꂩ MediaSession Đ̏ꍇAŃnOB
			//  EOn\[X쐬(IntPtr) ĂяoꍇAŃnOBiOn\[X쐬()ĂяoƁj
			hr = ::WaitForSingleObject( this->evMESessionTopologyStatus_MF_TOPOSTATUS_READY, INFINITE );

			if( hr != WAIT_OBJECT_0 )
				tHRESULTtO( hr, String::Format( L"g|W̍쐬҂Ɏs܂B(LastError={0})", GetLastError() ) );
			//-----------------
			#pragma endregion

		}
		catch( Exception^ )	// ~B
		{
			COM_SAFE_RELEASE( this->pMediaSource );
			COM_SAFE_RELEASE( this->pMediaSession );
			throw;
		}
		finally
		{
			COM_SAFE_RELEASE( pv[e[VLqq );
			COM_SAFE_RELEASE( pTopology );
		}
	}
	void CMediaSessionNative::tj()
	{
		HRESULT hr = S_OK;

		#pragma region [ IMFAttributes ̉ ]
		//-----------------
		COM_SAFE_RELEASE( this->pAttributes );
		//-----------------
		#pragma endregion
		#pragma region [ IMFVideoDisplayControl ̉ ]
		//-----------------
		COM_SAFE_RELEASE( this->pControl );
		//-----------------
		#pragma endregion
		#pragma region [ MediaSession ̃N[Yij ]
		//-----------------
		if( this->pMediaSession )
		{
			// Close; 񓯊
			tFAILEDȂO( L"IMFMediaSession::Close() ",
				hr = this->pMediaSession->Close() );

			// R[obN Close CxgĈȉ̃CxgZbg܂ŁAő 5000ms ҂B
			if( ::WaitForSingleObjectEx( this->evMESessionClosed, 5000, true ) == WAIT_TIMEOUT )
				Trace::TraceWarning( L"IMFMediaSession::Close() ^CAEg܂B𑱍s܂B" );
		}
		//-----------------
		#pragma endregion
		#pragma region [ fBA\[X̃Vbg_EƉ ]
		//-----------------
		if( this->pMediaSource )
		{
			// Vbg_EB
			tFAILEDȂO( L"IMFMediaSource::Shutdown() ",
				hr = this->pMediaSource->Shutdown() );

			// B
			COM_SAFE_RELEASE( this->pMediaSource );
		}
		//-----------------
		#pragma endregion
		#pragma region [ MediaSession ̃Vbg_EƉ ]
		//-----------------
		if( this->pMediaSession )
		{
			// Vbg_EB
			tFAILEDȂO( L"IMFMediaSession::Shutdown() ",
				hr = this->pMediaSession->Shutdown() );

			// B
			COM_SAFE_RELEASE( this->pMediaSession );
		}
		//-----------------
		#pragma endregion
	}
	void CMediaSessionNative::tĐ( UINT64 nĐJnʒu100ns )
	{
		HRESULT hr = S_OK;

		::ResetEvent( this->evMESessionStarted );

		// ĐJnwB

		PROPVARIANT prop;
		::PropVariantInit(&prop);
		prop.vt = VT_I8;
		prop.hVal.QuadPart = nĐJnʒu100ns;

		tFAILEDȂO( L"IMFMediaSession::Start() ",
			hr = this->pMediaSession->Start( NULL, &prop ) );

		AutoLock lock( this->csMediaSessionXe[^X );
		this->eMediaSessionXe[^X = EMediaSessionXe[^X::Đ;
	}
	void CMediaSessionNative::t~()
	{
		HRESULT hr = S_OK;

		tFAILEDȂO( L"IMFMediaSession::Stop() ",
			hr = this->pMediaSession->Stop() );

		AutoLock lock( this->csMediaSessionXe[^X );
		this->eMediaSessionXe[^X = EMediaSessionXe[^X::~;
	}
	void CMediaSessionNative::tꎞ~()
	{
		HRESULT hr = S_OK;

		tFAILEDȂO( L"IMFMediaSession::Pause() ",
			hr = this->pMediaSession->Pause() );

		AutoLock lock( this->csMediaSessionXe[^X );
		this->eMediaSessionXe[^X = EMediaSessionXe[^X::ꎞ~;
	}
	void CMediaSessionNative::tĐĊJ()
	{
		HRESULT hr = S_OK;

		::ResetEvent( this->evMESessionStarted );

		PROPVARIANT prop;
		::PropVariantInit(&prop);
		prop.vt = VT_EMPTY;	// ݈ʒuĐ

		tFAILEDȂO( L"IMFMediaSession::Start() ",
			hr = this->pMediaSession->Start( NULL, &prop ) );

		AutoLock lock( this->csMediaSessionXe[^X );
		this->eMediaSessionXe[^X = EMediaSessionXe[^X::Đ;
	}
	
	void CMediaSessionNative::tĐ܂őҋ@()
	{
		HRESULT hr = ::WaitForSingleObject( this->evMESessionStarted, INFINITE );
	}

	CMediaSessionNative::EMediaSessionXe[^X CMediaSessionNative::eMediaSessionXe[^X擾()
	{
		AutoLock lock( this->csMediaSessionXe[^X );
		return this->eMediaSessionXe[^X;
	}
	bool CMediaSessionNative::bĐł()
	{
		AutoLock lock( this->csMediaSessionXe[^X );
		return ( this->eMediaSessionXe[^X == EMediaSessionXe[^X::Đ ||
			     this->eMediaSessionXe[^X == EMediaSessionXe[^X::Đ );
	}
	UInt64 CMediaSessionNative::ñ݂NbNԂ()
	{
		HRESULT hr = S_OK;

		IMFClock *pClock;
		tFAILEDȂO( L"IMFClock ̎擾",
			hr = this->pMediaSession->GetClock( &pClock ) );

		LONGLONG clockTime;
		MFTIME systemTime;
		
		tFAILEDȂO( L"oߎԂ̎擾",
			hr = pClock->GetCorrelatedTime( NULL, &clockTime, &systemTime ) );

		return clockTime;
	}
	void CMediaSessionNative::txݒ肷( UINT32 ux )
	{
		this->pAttributes->SetUINT32( GUIDofeNX`̓x, ux );
	}
	void CMediaSessionNative::tZ( bool bZ )
	{
		this->pAttributes->SetUINT32( GUIDofeNX`̉Z, (bZ) ? 1 : 0 );
	}

	void CMediaSessionNative::t̃Tvv()
	{
		if( this->eMediaSessionXe[^X == EMediaSessionXe[^X::Đ )	// Đ낤łȂ낤Ăяôŗv`FbNB
			this->pControl->SetRenderingPrefs( MFVideoRenderPrefs_RequestNextSample );
	}
	void CMediaSessionNative::tŐṼTv`悷( LPRECT prc` )
	{
		#pragma region [ s`FbN ]
		//-----------------
		if( this->eMediaSessionXe[^X != EMediaSessionXe[^X::Đ )
			return;
		//-----------------
		#pragma endregion

		this->pControl->SetVideoPosition( NULL, prc` );

		// Ǝ`bZ[WŃv[^֒ʒmB
		this->pControl->SetRenderingPrefs( MFVideoRenderPrefs_DisplaySample );
	}

	void CMediaSessionNative::t摜TCY擾( SIZE *pSize )
	{
		if( this->eMediaSessionXe[^X == EMediaSessionXe[^X::Đ )
			this->pControl->GetNativeVideoSize( pSize, NULL );
	}
	void CMediaSessionNative::tEVRփfoCXύXʒm()
	{
		// Ǝ`bZ[WŃv[^֒ʒmB
		pControl->SetRenderingPrefs( MFVideoRenderPrefs_DisplayChange );
	}

	void CMediaSessionNative::t`Jn錾( int id )
	{
		AutoLock lock( CMediaSessionNative::csInstances );

		CMediaSessionNative *pMSU = CMediaSessionNative::tIDCX^X擾( id );

		if( pMSU )
			::SetEvent( pMSU->evMESessionStarted );
	}

	void CMediaSessionNative::tSCX^XEVRփfoCXύXʒm𑗂()
	{
		AutoLock lock( CMediaSessionNative::csInstances );

		for( int i = 0; i < MAX_INSTANCE; i++ )
		{
			if( CMediaSessionNative::Instances[ i ] )
				CMediaSessionNative::Instances[ i ]->tEVRփfoCXύXʒm();
		}
	}
	void CMediaSessionNative::tSCX^X֎̃Tvv()
	{
		AutoLock lock( CMediaSessionNative::csInstances );

		for( int i = 0; i < MAX_INSTANCE; i++ )
		{
			if( CMediaSessionNative::Instances[ i ] )
				CMediaSessionNative::Instances[ i ]->t̃Tvv();
		}
	}
	void CMediaSessionNative::tSCX^X~()
	{
		AutoLock lock( CMediaSessionNative::csInstances );

		for( int i = 0; i < MAX_INSTANCE; i++ )
		{
			if( CMediaSessionNative::Instances[ i ] )
				CMediaSessionNative::Instances[ i ]->t~();
		}
	}

	// IMFAsyncCallback 
	STDMETHODIMP CMediaSessionNative::GetParameters( DWORD *pdwFlags, DWORD *pdwQueue )
	{
		*pdwFlags = MFASYNC_FAST_IO_PROCESSING_CALLBACK;	// uR[obN 1ms ȓɊv錾
		*pdwQueue = MFASYNC_CALLBACK_QUEUE_STANDARD;		// u[NL[ MediaFoundation ̕Ŵ̂gpv錾
		return S_OK;
	}
	STDMETHODIMP CMediaSessionNative::Invoke( IMFAsyncResult *pAsyncResult )
	{
		//  ̃Xbh̓[NL[XbhsB

		if( ::WaitForSingleObject( this->evMESessionClosed, 0 ) == WAIT_OBJECT_0 )
			return S_OK;	// MESessionClosed ̌ɂȂCxg110̂ŋrB


		HRESULT			hr = S_OK;
		IMFMediaEvent  *pCxg = NULL;
		MediaEventType	eCxg^Cv = MEUnknown;

		try
		{
			#pragma region [ CxgƃCxg^Cv擾B]
			//-----------------
			// MesiaSession 烁fBACxg擾B
			tFAILEDȂA( hr = this->pMediaSession->EndGetEvent( pAsyncResult, &pCxg ) );    // 񓯊̏IȂ̂ End.. łB̃\bh̍ŌōĂ Begin... B
			
			// fBACxgCxg^Cv擾B
			tFAILEDȂA( hr = pCxg->GetType( &eCxg^Cv ) );

			// fBACxgCxgXe[^X擾B
			HRESULT hrCxgXe[^X = S_OK;
			tFAILEDȂA( hr = pCxg->GetStatus( &hrCxgXe[^X ) );

			// CxgXe[^XusvȂ炱ŏIB
			if( FAILED( hrCxgXe[^X ) )	
				return hrCxgXe[^X;
			//-----------------
			#pragma endregion


			// Cxg^CvɂďB

			switch( eCxg^Cv )
			{
			case MESessionTopologySet:
				Debug::WriteLine( String::Format( "Invoke: MESessionTopologySet: [{0}]", gcnew String( this->stgt@C ) ) );
				break;

			case MESessionTopologyStatus:
				#pragma region [ g|W̃Xe[^XωB]
				//-----------------
				Debug::Write( "Invoke(): MESessionTopologyStatus (" );
				{
					MF_TOPOSTATUS status = MF_TOPOSTATUS_INVALID;

					#pragma region [ Cxgg|WXe[^XR[h擾B]
					//-----------------
					UINT32 nR[h;
					tFAILEDȂA( hr = pCxg->GetUINT32( MF_EVENT_TOPOLOGY_STATUS, &nR[h ) );
					status = (MF_TOPOSTATUS) nR[h;
					//-----------------
					#pragma endregion

					switch( status )
					{
						case MF_TOPOSTATUS_READY:
							#pragma region [ g|W̉͂B]
							//-----------------
							Debug::Write( "MF_TOPOSTATUS_READY" );

							// IMFVideoDisplayControl 擾B
							COM_SAFE_RELEASE( this->pControl );
							MFGetService( this->pMediaSession, MR_VIDEO_RENDER_SERVICE, IID_PPV_ARGS( &(this->pControl) ) );

							// IMFAttributes 擾B
							COM_SAFE_RELEASE( this->pAttributes );
							MFGetService( this->pMediaSession, MR_VIDEO_RENDER_SERVICE, IID_PPV_ARGS( &(this->pAttributes) ) );

							// CxgZbgB
							::SetEvent( this->evMESessionTopologyStatus_MF_TOPOSTATUS_READY );
							//-----------------
							#pragma endregion
							break;

						case MF_TOPOSTATUS_STARTED_SOURCE:
							Debug::Write( "MF_TOPOSTATUS_STARTED_SOURCE" );
							break;

						case MF_TOPOSTATUS_SINK_SWITCHED:
							Debug::Write( "MF_TOPOSTATUS_SINK_SWITCHED" );
							break;

						case MF_TOPOSTATUS_ENDED:
							#pragma region [ g|W̍ĐiAMediaSession͓ł܂g|WgĂ\ԁjB]
							//-----------------
							{
								Debug::Write( "MF_TOPOSTATUS_ENDED" );

								if( this->b[v )
									this->tĐ( 0 );	// SɃg|WOɎwoĂ݂BTEh̓[vȂB
							}
							//-----------------
							#pragma endregion
							break;

						default:
							Debug::Write( String::Format( "{0}", (int)status ) );
							break;
					}
				}
				Debug::WriteLine( String::Format( "): [{0}]", gcnew String( this->stgt@C ) ) );
				//-----------------
				#pragma endregion
				break;

			case MESessionStarted:
				#pragma region [ ĐJniĐJnjB]
				//-----------------
				{
					Debug::WriteLine( String::Format( "Invoke: MESessionStarted: [{0}]", gcnew String( this->stgt@C ) ) );

					this->csMediaSessionXe[^X.Lock();
					this->eMediaSessionXe[^X = EMediaSessionXe[^X::Đ;
					this->csMediaSessionXe[^X.Unlock();

					// `JntO𗧂āACxg𔭉΁B
					::SetEvent( this->evMESessionStarted );
				}
				//-----------------
				#pragma endregion
				break;

			case MESessionStopped:
				#pragma region [ Đ~iĐ~jB]
				//-----------------
				{
					Debug::WriteLine( String::Format( "Invoke: MESessionStopped: [{0}]", gcnew String( this->stgt@C ) ) );

					this->csMediaSessionXe[^X.Lock();
					this->eMediaSessionXe[^X = EMediaSessionXe[^X::~;
					this->csMediaSessionXe[^X.Unlock();

					// `JntO𗧂āACxg𔭉΁B
					::SetEvent( this->evMESessionStopped );
				}
				//-----------------
				#pragma endregion
				break;

			case MESessionPaused:
				#pragma region [ Đꎞ~iĐꎞ~jB]
				//-----------------
				{
					Debug::WriteLine( String::Format( "Invoke: MESessionPaused: [{0}]", gcnew String( this->stgt@C ) ) );

					this->csMediaSessionXe[^X.Lock();
					this->eMediaSessionXe[^X = EMediaSessionXe[^X::ꎞ~;
					this->csMediaSessionXe[^X.Unlock();
				}
				//-----------------
				#pragma endregion
				break;

			case MESessionEnded:
				#pragma region [ tIB]
				//-----------------
				{
					Debug::WriteLine( String::Format( "Invoke: MESessionEnded: [{0}]", gcnew String( this->stgt@C ) ) );

					AutoLock lock( this->csMediaSessionXe[^X );
					this->eMediaSessionXe[^X = EMediaSessionXe[^X::ĐI;
				}
				//-----------------
				#pragma endregion
				break;

			case MESessionClosed:
				#pragma region [ MediaSession  Close B]
				//-----------------
				{
					Debug::WriteLine( String::Format( "Invoke: MESessionClosed: [{0}]", gcnew String( this->stgt@C ) ) );
					::SetEvent( this->evMESessionClosed );
				}
				//-----------------
				#pragma endregion
				break;

			default:
				Debug::WriteLine( String::Format( "Invoke: {1}: [{0}]", gcnew String( this->stgt@C ), eCxg^Cv ) );
				break;
			}
		}
		finally
		{
			COM_SAFE_RELEASE( pCxg );

			#pragma region [ ̃Cxg҂JnB]
			//-----------------
			if( eCxg^Cv != MESessionClosed )	// MESessionClosed ȍ~̓Cxg擾ȂB
				hr = this->pMediaSession->BeginGetEvent( this, NULL );
			//-----------------
			#pragma endregion
		}

		return S_OK;
	}

	// IUnknown 
	STDMETHODIMP CMediaSessionNative::QueryInterface( REFIID riid, void **ppvObject )
	{
		if( riid == __uuidof(IUnknown) )
			*ppvObject = static_cast<IUnknown*>( this );

		#pragma region [ ̑iG[j]
		//-----------------
		else
		{
			*ppvObject = NULL;
			return E_NOINTERFACE;
		}
		//-----------------
		#pragma endregion

		this->AddRef();
		return S_OK;
	}
	STDMETHODIMP_( ULONG ) CMediaSessionNative::AddRef()
	{
		return ::InterlockedIncrement( &this->nQƃJE^ );
	}
	STDMETHODIMP_( ULONG ) CMediaSessionNative::Release()
	{
		ULONG c = ::InterlockedDecrement( &this->nQƃJE^ );

		if( c == 0 )
			delete this;
	
		return c;
	}
}