#pragma once

#include "\CUnknown.h"

namespace FDK
{
		// wp֐

		inline MFOffset MakeOffset( float v )
		{
			MFOffset offset;
			offset.value = short(v);
			offset.fract = WORD(65536 * (v-offset.value));
			return offset;
		}
		inline MFVideoArea MakeArea( float x, float y, DWORD width, DWORD height )
		{
			MFVideoArea area;
			area.OffsetX = MakeOffset( x );
			area.OffsetY = MakeOffset( y );
			area.Area.cx = width;
			area.Area.cy = height;
			return area;
		}
		inline LONG GetOffset( const MFOffset& offset )
		{
			return (LONG)((float)offset.value + offset.fract/65536.0f);
		}
		inline HRESULT GetFrameRate( IMFMediaType *pType, MFRatio *pRatio )
		{
			return ::MFGetAttributeRatio( pType, MF_MT_FRAME_RATE, (UINT32*)&pRatio->Numerator, (UINT32*)&pRatio->Denominator );
		}
		inline HRESULT GetVideoDisplayAreaAux( IMFMediaType *pType, MFVideoArea *pArea )
		{
			HRESULT hr = S_OK;
			BOOL bPanScan = FALSE;
			UINT32 width = 0, height = 0;

			bPanScan = ::MFGetAttributeUINT32( pType, MF_MT_PAN_SCAN_ENABLED, FALSE );

			// In pan/scan mode, try to get the pan/scan region.
			if( bPanScan )
				hr = pType->GetBlob( MF_MT_PAN_SCAN_APERTURE, (UINT8*)pArea, sizeof(MFVideoArea), NULL );

			// If not in pan/scan mode, or there is not pan/scan region, get the geometric aperture.
			if( !bPanScan || hr == MF_E_ATTRIBUTENOTFOUND )
				hr = pType->GetBlob( MF_MT_GEOMETRIC_APERTURE, (UINT8*)pArea, sizeof(MFVideoArea), NULL );

			// Default: Use the entire video area.
			if( !bPanScan || hr == MF_E_ATTRIBUTENOTFOUND )
			{
				hr = ::MFGetAttributeSize( pType, MF_MT_FRAME_SIZE, &width, &height );
				if (SUCCEEDED(hr))
					*pArea = MakeArea( 0.0, 0.0, width, height );
			}

			return hr;
		}

		//class MediaTypeBuilder;
		//class AudioTypeBuilder;
		//class VideoTypeBuilder;
		//class MPEGVideoTypeBuilder;
	
		class MediaTypeBuilder : public CUnknown
		{
		protected:
			IMFMediaType *m_pType;
	
		protected:
			BOOL IsValid();
			IMFMediaType *GetMediaType();
		
			MediaTypeBuilder( IMFMediaType* pType, HRESULT& hr );
			MediaTypeBuilder( HRESULT& hr );
			virtual ~MediaTypeBuilder();
	
		public:
		
			// static Ȑ\bhBVfBA^Cvꍇ͂̃o[WgƁB
			template <class T>
			static HRESULT Create( T** ppTypeBuilder )
			{
				if( ppTypeBuilder == NULL )
					return E_POINTER;
			
				HRESULT hr = S_OK;

				T *pTypeBuilder = new T( hr );

				if( pTypeBuilder == NULL )
					return E_OUTOFMEMORY;
			
				if( SUCCEEDED( hr ) )
				{
					*ppTypeBuilder = pTypeBuilder;
					(*ppTypeBuilder)->AddRef();
				}
		
				COM_SAFE_RELEASE( pTypeBuilder );
				return hr;
			}
		
			// ̃fBA^Cv珉ꍇ͂̃o[WgƁB
			template <class T>
			static HRESULT Create( IMFMediaType *pType, T** ppTypeBuilder )
			{
				if( ppTypeBuilder == NULL )
					return E_POINTER;
			
				HRESULT hr = S_OK;
			
				T *pTypeBuilder = new T( pType, hr );

				if( pTypeBuilder == NULL )
					return E_OUTOFMEMORY;
			
				if( SUCCEEDED( hr ) )
				{
					*ppTypeBuilder = pTypeBuilder;
					(*ppTypeBuilder)->AddRef();
				}
			
				COM_SAFE_RELEASE( pTypeBuilder );
				return hr;
			}
		
			// W[^Cv GUID ԂB
			HRESULT GetMajorType( GUID *pGuid );
		
			// fBAf[^kĂ邩ԂB
			HRESULT IsCompressedFormat( BOOL *pbCompressed );
		
			// w肳ꂽfBA^CvƓł邩ׂB
			HRESULT IsEqual( IMFMediaType *pType, DWORD *pdwFlags );
		
			// Retrieves an alternative representation of the media type.
			HRESULT GetRepresentation( GUID guidRepresentation, LPVOID *ppvRepresentation );
		
			// GetRepresentation() ŊmۂꂽB
			HRESULT FreeRepresentation( GUID guidRepresentation, LPVOID pvRepresentation );


			// wp\bh
		
			// CopyFrom: Copy all of the attributes from another media type into this type.
			HRESULT CopyFrom( MediaTypeBuilder *pType );
			HRESULT CopyFrom( IMFMediaType *pType );
		
			HRESULT SetMajorType( GUID guid );
			HRESULT GetMediaType( IMFMediaType **ppType );
			HRESULT SetSubType( GUID guid );
			HRESULT GetSubType( GUID *pGuid );
		
			// Tu^Cv FOURCC 𒊏oBׂẴTu^Cṽp^[ɓĂ͂܂ł͂ȂB
			HRESULT GetFourCC( DWORD *pFourCC );

			//  Queries whether each sample is independent of the other samples in the stream.
			HRESULT GetAllSamplesIndependent( BOOL* pbIndependent );
		
			//  Specifies whether each sample is independent of the other samples in the stream.
			HRESULT SetAllSamplesIndependent( BOOL bIndependent );
		
			// TvŒTCYH
			HRESULT GetFixedSizeSamples( BOOL *pbFixed );
		
			// TvŒTCYǂݒ肷B
			HRESULT SetFixedSizeSamples( BOOL bFixed );
		
			// TṽTCYioCgPʁj擾B
			HRESULT GetSampleSize( UINT32 *pnSize );
		
			// TṽTCYioCgPʁjݒ肷B
			HRESULT SetSampleSize( UINT32 nSize );
		
			// MFWrapMediaType() ֐ŃbvꂽfBA^Cv擾B
			HRESULT Unwrap( IMFMediaType **ppOriginal );
		
			// The following versions return reasonable defaults if the relevant attribute is not present (zero/FALSE).
			// This is useful for making quick comparisons betweeen media types. 
		
			BOOL AllSamplesIndependent();
			BOOL FixedSizeSamples();
			UINT32 SampleSize();
		};

		class VideoTypeBuilder : public MediaTypeBuilder
		{
			friend class MediaTypeBuilder; 

		protected:

			VideoTypeBuilder( IMFMediaType *pType, HRESULT& hr );
			VideoTypeBuilder( HRESULT& hr );

		public:

			// t[ǂ̂悤ɃC^[XĂ邩̏󋵂擾B
			HRESULT GetInterlaceMode( MFVideoInterlaceMode *pmode );

			// t[ǂ̂悤ɃC^[XĂ邩̏󋵂ݒ肷B
			HRESULT SetInterlaceMode( MFVideoInterlaceMode mode );

			// This returns the default or attempts to compute it, in its absence.
			HRESULT GetDefaultStride( INT32 *pnStride );

			// ftHgXgChݒ肷B̒ĺA񈳏kf[^tH[}bgɑ΂Ă݈̂ӖB
			HRESULT SetDefaultStride( INT32 nStride );
		
			// rfIt[̕ƍ擾B
			HRESULT GetFrameDimensions( UINT32 *pdwWidthInPixels, UINT32 *pdwHeightInPixels );

			// rfIt[̕ƍݒ肷B
			HRESULT SetFrameDimensions( UINT32 dwWidthInPixels, UINT32 dwHeightInPixels );

			// Retrieves the data error rate in bit errors per second
			HRESULT GetDataBitErrorRate( UINT32 *pRate );

			// Sets the data error rate in bit errors per second
			HRESULT SetDataBitErrorRate( UINT32 rate );

			// Retrieves the approximate data rate of the video stream.
			HRESULT GetAverageBitRate( UINT32 *pRate );

			// Sets the approximate data rate of the video stream.
			HRESULT SetAvgerageBitRate( UINT32 rate );

			// Retrieves custom color primaries.
			HRESULT GetCustomVideoPrimaries( MT_CUSTOM_VIDEO_PRIMARIES *pPrimaries );

			// Sets custom color primaries.
			HRESULT SetCustomVideoPrimaries( const MT_CUSTOM_VIDEO_PRIMARIES& primary );

			// Gets the number of frames per second.
			HRESULT GetFrameRate( UINT32 *pnNumerator, UINT32 *pnDenominator );
		
			// Gets the frames per second as a ratio.
			HRESULT GetFrameRate( MFRatio *pRatio );

			// Sets the number of frames per second.
			HRESULT SetFrameRate( UINT32 nNumerator, UINT32 nDenominator );
		
			// Sets the number of frames per second, as a ratio.
			HRESULT SetFrameRate( const MFRatio& ratio );

			// Queries the geometric aperture.
			HRESULT GetGeometricAperture( MFVideoArea *pArea );

			// Sets the geometric aperture.
			HRESULT SetGeometricAperture( const MFVideoArea& area );
		
			// Retrieves the maximum number of frames from one key frame to the next.
			HRESULT GetMaxKeyframeSpacing( UINT32 *pnSpacing );

			// Sets the maximum number of frames from one key frame to the next.
			HRESULT SetMaxKeyframeSpacing( UINT32 nSpacing );

			// Retrieves the region that contains the valid portion of the signal.
			HRESULT GetMinDisplayAperture( MFVideoArea *pArea );

			// Sets the the region that contains the valid portion of the signal.
			HRESULT SetMinDisplayAperture( const MFVideoArea& area );

			// Retrieves the aspect ratio of the output rectangle for a video media type. 
			HRESULT GetPadControlFlags( MFVideoPadFlags *pFlags );
		
			// Sets the aspect ratio of the output rectangle for a video media type. 
			HRESULT SetPadControlFlags( MFVideoPadFlags flags );

			// Retrieves an array of palette entries for a video media type. 
			HRESULT GetPaletteEntries( MFPaletteEntry *paEntries, UINT32 nEntries );

			// Sets an array of palette entries for a video media type. 
			HRESULT SetPaletteEntries( MFPaletteEntry *paEntries, UINT32 nEntries );

			// Retrieves the number of palette entries.
			HRESULT GetNumPaletteEntries( UINT32 *pnEntries );
		
			// Queries the 43 region of video that should be displayed in pan/scan mode.
			HRESULT GetPanScanAperture( MFVideoArea *pArea );

			// Sets the 43 region of video that should be displayed in pan/scan mode.
			HRESULT SetPanScanAperture( const MFVideoArea& area );

			// Queries whether pan/scan mode is enabled.
			HRESULT IsPanScanEnabled( BOOL *pBool );

			// Sets whether pan/scan mode is enabled.
			HRESULT SetPanScanEnabled( BOOL bEnabled );

			// Queries the pixel aspect ratio
			HRESULT GetPixelAspectRatio( UINT32 *pnNumerator, UINT32 *pnDenominator );

			// Sets the pixel aspect ratio
			HRESULT SetPixelAspectRatio( UINT32 nNumerator, UINT32 nDenominator );
			HRESULT SetPixelAspectRatio( const MFRatio& ratio );

			// Queries the intended aspect ratio.
			HRESULT GetSourceContentHint( MFVideoSrcContentHintFlags *pFlags );
		
			// Sets the intended aspect ratio.
			HRESULT SetSourceContentHint( MFVideoSrcContentHintFlags nFlags );

			// Queries an enumeration which represents the conversion function from RGB to R'G'B'.
			HRESULT GetTransferFunction( MFVideoTransferFunction *pnFxn );

			// Set an enumeration which represents the conversion function from RGB to R'G'B'.
			HRESULT SetTransferFunction( MFVideoTransferFunction nFxn );

			// Queries how chroma was sampled for a Y'Cb'Cr' video media type.
			HRESULT GetChromaSiting( MFVideoChromaSubsampling *pSampling );

			// Sets how chroma was sampled for a Y'Cb'Cr' video media type.
			HRESULT SetChromaSiting( MFVideoChromaSubsampling nSampling );

			// Queries the optimal lighting conditions for viewing.
			HRESULT GetVideoLighting( MFVideoLighting *pLighting );

			// Sets the optimal lighting conditions for viewing.
			HRESULT SetVideoLighting( MFVideoLighting nLighting );

			// Queries the nominal range of the color information in a video media type. 
			HRESULT GetVideoNominalRange( MFNominalRange *pRange );

			// Sets the nominal range of the color information in a video media type. 
			HRESULT SetVideoNominalRange( MFNominalRange nRange );

			// Queries the color primaries for a video media type.
			HRESULT GetVideoPrimaries( MFVideoPrimaries *pPrimaries );

			// Sets the color primaries for a video media type.
			HRESULT SetVideoPrimaries( MFVideoPrimaries nPrimaries );

			// Gets a enumeration representing the conversion matrix from the Y'Cb'Cr' color space to the R'G'B' color space.
			HRESULT GetYUVMatrix( MFVideoTransferMatrix *pMatrix );

			// Sets an enumeration representing the conversion matrix from the Y'Cb'Cr' color space to the R'G'B' color space.
			HRESULT SetYUVMatrix( MFVideoTransferMatrix nMatrix );
		
			// 
			// The following versions return reasonable defaults if the relevant attribute is not present (zero/FALSE).
			// This is useful for making quick comparisons betweeen media types. 
			//

			MFRatio GetPixelAspectRatio(); // Defaults to 1:1 (square pixels)
			BOOL IsPanScanEnabled(); // Defaults to FALSE
		
			// Returns (in this order) 
			// 1. The pan/scan region, only if pan/scan mode is enabled.
			// 2. The geometric aperture.
			// 3. The entire video area.
			HRESULT GetVideoDisplayArea( MFVideoArea *pArea );
		};
		class AudioTypeBuilder : public MediaTypeBuilder
		{
			friend class MediaTypeBuilder;
	
		protected:

			AudioTypeBuilder( IMFMediaType* pType, HRESULT& hr );
			AudioTypeBuilder( HRESULT& hr );
	
		public:
		
			// Query the average number of bytes per second.
			HRESULT GetAvgerageBytesPerSecond( UINT32 *pBytes );

			// Sets the average number of bytes per second.
			HRESULT SetAvgerageBytesPerSecond( UINT32 nBytes );

			// Query the bits per audio sample
			HRESULT GetBitsPerSample( UINT32 *pBits );
		
			// Sets the bits per audio sample
			HRESULT SetBitsPerSample( UINT32 nBits );

			// Query the block aignment in bytes
			HRESULT GetBlockAlignment( UINT32 *pBytes );

			// Sets the block aignment in bytes
			HRESULT SetBlockAlignment( UINT32 nBytes );

			// Query the assignment of audio channels to speaker positions.
			HRESULT GetChannelMask( UINT32 *pMask );

			// Sets the assignment of audio channels to speaker positions.
			HRESULT SetChannelMask( UINT32 nMask );

			// Query the number of audio samples per second (floating-point value).
			HRESULT GetFloatSamplesPerSecond( double *pfSampleRate );

			// Sets the number of audio samples per second (floating-point value).
			HRESULT SetFloatSamplesPerSecond( double fSampleRate );

			// Queries the number of audio channels
			HRESULT GetNumChannels( UINT32 *pnChannels );

			// Sets the number of audio channels
			HRESULT SetNumChannels( UINT32 nChannels );

			// Query the number of audio samples contained in one compressed block of audio data.
			HRESULT GetSamplesPerBlock( UINT32 *pnSamples );

			// Sets the number of audio samples contained in one compressed block of audio data.
			HRESULT SetSamplesPerBlock( UINT32 nSamples );

			// Query the number of audio samples per second as an integer value.
			HRESULT GetSamplesPerSecond( UINT32 *pnSampleRate );

			// Set the number of audio samples per second as an integer value.
			HRESULT SetSamplesPerSecond( UINT32 nSampleRate );

			// Query number of valid bits of audio data in each sample.
			HRESULT GetValidBitsPerSample( UINT32 *pnBits );

			// Set the number of valid bits of audio data in each sample.
			HRESULT SetValidBitsPerSample( UINT32 nBits );
		
			// The following versions return zero if the relevant attribute is not present. This is useful for making quick comparisons betweeen media types. 

			UINT32 AvgerageBytesPerSecond();
			UINT32 BitsPerSample();
			UINT32 GetBlockAlignment();
			double FloatSamplesPerSecond();
			UINT32 NumChannels();
			UINT32 SamplesPerSecond();
		};
		class MPEGVideoTypeBuilder : public VideoTypeBuilder
		{
			friend class MediaTypeBuilder;
	
		protected:

			MPEGVideoTypeBuilder( IMFMediaType* pType, HRESULT& hr );
			MPEGVideoTypeBuilder( HRESULT& hr );
	
		public:

			// Retrieves the MPEG sequence header for a video media type.
			HRESULT GetMpegSeqHeader( BYTE *pData, UINT32 cbSize );

			// Sets the MPEG sequence header for a video media type.
			HRESULT SetMpegSeqHeader( const BYTE *pData, UINT32 cbSize );

			// Retrieves the size of the MPEG sequence header.
			HRESULT GetMpegSeqHeaderSize( UINT32 *pcbSize );

			// Retrieve the group-of-pictures (GOP) start time code, for an MPEG-1 or MPEG-2 video media type.
			HRESULT GetStartTimeCode( UINT32 *pnTime );

			// Sets the group-of-pictures (GOP) start time code, for an MPEG-1 or MPEG-2 video media type.
			HRESULT SetStartTimeCode( UINT32 nTime );

			// Retrieves assorted flags for MPEG-2 video media type
			HRESULT GetMPEG2Flags( UINT32 *pnFlags );

			// Sets assorted flags for MPEG-2 video media type
			HRESULT SetMPEG2Flags( UINT32 nFlags );

			// Retrieves the MPEG-2 level in a video media type.
			HRESULT GetMPEG2Level( UINT32 *pLevel );

			// Sets the MPEG-2 level in a video media type.
			HRESULT SetMPEG2Level( UINT32 nLevel );

			// Retrieves the MPEG-2 profile in a video media type
			HRESULT GetMPEG2Profile( UINT32 *pProfile );
		
			// Sets the MPEG-2 profile in a video media type
			HRESULT SetMPEG2Profile( UINT32 nProfile );
		};
}