﻿using System;
using System.Diagnostics;
using FDK;

namespace StrokeStyleT
{
	[Serializable]
	public class SystemConfig : ISerializableXML		// XML化対象クラスは public であり、StrokeStyleT.ISerializableXML を実装すること。
	{
		#region [ CSongProperties クラス定義 ]
		//-----------------
		public class CSongProperties
		{
			public long n遅延差分ms = 0;
		}
		//-----------------
		#endregion

		// XML化対象。

		// システムサウンド。
		public ESoundDeviceType SoundDeviceType = ESoundDeviceType.ExclusiveWASAPI;
		public int SoundMaxDelay = 0;
		public int SoundUpdatePeriod = 6;

		/// <summary>
		/// <para>曲毎に固有のプロパティ。</para>
		/// <para>\&lt;SSTFファイルのフルパス（マクロあり）, CSongPropertiesインスタンス&gt;</para>
		/// </summary>
		public CSerializableDictionary<string, CSongProperties> SongProperties = new CSerializableDictionary<string, CSongProperties>();

		// XML化対象クラスはパラメータなしの public コンストラクタを持つこと。
		public SystemConfig()
		{
		}
	
		// ISerializableXML の実装
		public void t規定の初期化()
		{
		}
	}
}
