﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using System.Windows.Forms;
using FDK;

namespace StrokeStyleT
{
	/// <summary>
	/// <para>ユーザ別局管理ウィンドウを表示する。</para>
	/// <para>On進行() が E進行結果.完了 を返したとき、Global.User.SongListFiles が編集されている。</para>
	/// </summary>
	class CActユーザ別曲リスト管理 : CActivity
	{
		enum EフェーズID { ダイアログ表示, 完了, キャンセル }
		Cスレッドセーフ<EフェーズID> eフェーズID = new Cスレッドセーフ<EフェーズID>( EフェーズID.ダイアログ表示 );
		
		public void tリセット()
		{
			this.eフェーズID.Set( EフェーズID.ダイアログ表示 );
		}

		public override int On進行()
		{
			switch( this.eフェーズID.Get() )
			{
				case EフェーズID.完了:
					return (int) E進行結果.完了;

				case EフェーズID.キャンセル:
					return (int) E進行結果.キャンセル;
			}
			return (int) E進行結果.継続;
		}
		public override void On描画前()
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return;
			//-----------------
			#endregion

			switch( this.eフェーズID.Get() )
			{
				case EフェーズID.ダイアログ表示:
					{
						var dialog = new Cユーザ別曲リスト管理ウィンドウ( Global.App.Window, Global.User.Config.SongListFiles );

						Global.tダイアログ表示の前処理();
						var dr = dialog.ShowDialog();
						Global.tダイアログ表示の後処理();

						// 曲リストをリセット。

						if( dr == DialogResult.OK )
						{
							#region [ Config への反映と保存 ]
							//-----------------
							Global.User.Config.SongListFiles.Clear();
							foreach( TreeNode node in dialog.treeView曲ツリー.Nodes )		// この Nodes の中身はすべてSongListノードである
								Global.User.Config.SongListFiles.Add( Folder.tファイルパス内のマクロを展開する( node.Text ) );

							CXMLFile<CConfig>.t保存する( Global.User.Config, Path.Combine( Folder.stgユーザ個別フォルダ, Properties.Resources.XMLNAME_CONFIG ) );
							//-----------------
							#endregion

							#region [ SongListファイルへの反映と保存 ]
							//-----------------
							foreach( TreeNode node in dialog.treeView曲ツリー.Nodes )		// この Nodes の中身はすべてSongListノードである
							{
								var songList = new SongList() {
									Songs = new List<SongNode>(),
								};
								dialog.tGUIツリーからSongツリーを再帰的に構築する( node.Nodes, songList.Songs );

								songList.t保存する( Folder.tファイルパス内のマクロを展開する( node.Text ) );
							}
							//-----------------
							#endregion

							Global.tSongListをすべて読み込んでマージする( Global.User.Config.SongListFiles );
							this.eフェーズID.Set( EフェーズID.完了 );
						}
						else
							this.eフェーズID.Set( EフェーズID.キャンセル );
					}
					break;
			}
		}
	}
}
