﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using FDK;

namespace StrokeStyleT
{
	/// <summary>
	/// <para>ユーザ選択ウィンドウを表示し、On進行() が E進行結果.完了 を返したとき、選択されたユーザ名が「stg選択されたユーザ」に格納されている。</para>
	/// <para>キャンセルされた場合は、「stg選択されたユーザ」は null になっている。</para>
	/// </summary>
	class CActユーザ選択 : CActivity
	{
		public string stg選択されたユーザ名;

		enum EフェーズID { 背景描画, ダイアログ表示, 完了 }
		Cスレッドセーフ<EフェーズID> eフェーズID = new Cスレッドセーフ<EフェーズID>( EフェーズID.背景描画 );

		public void tリセット()
		{
			this.stg選択されたユーザ名 = null;
			this.b背景描画済み = false;
			this.eフェーズID.Set( EフェーズID.背景描画 );
		}

		public override int On進行()
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				throw new Exception( "活性化していません。" );
			//-----------------
			#endregion

			switch( this.eフェーズID.Get() )
			{
				case EフェーズID.背景描画:
					#region [ 何もしない ]
					//-----------------
					break;
					//-----------------
					#endregion

				case EフェーズID.ダイアログ表示:
					#region [ 何もしない ]
					//-----------------
					break;
					//-----------------
					#endregion

				case EフェーズID.完了:
					return (int) E進行結果.完了;
			}
			return (int) E進行結果.継続;
		}
		public override void On描画前()
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return;
			//-----------------
			#endregion

			switch( this.eフェーズID.Get() )
			{
				case EフェーズID.背景描画:
					#region [ １ターンだけスルーし、親Activityの On描画() に背景を描画させる。２ターン目はダイアログ表示フェーズへ。]
					//-----------------
					if( !this.b背景描画済み )
						this.b背景描画済み = true;
					else
						this.eフェーズID.Set( EフェーズID.ダイアログ表示 );
					break;
					//-----------------
					#endregion

				case EフェーズID.ダイアログ表示:
					#region [ SSTFEditor 作成（なければ）、ログインユーザの選択・作成・削除。ウィンドウを閉じたら完了フェーズへ。]
					//-----------------
					{
						#region [ 現状ユーザ数が 0 人、または SSTFEditor用ユーザが存在していないなら、SSTFEditor用ユーザを作成する。]
						//-----------------
						bool bSSTFEditor用ユーザを作成する = false;

						#region [ SSTFEditor用ユーザの作成は必要か？ ]
						//-----------------
						if( Global.User.UserList.Users.Count == 0 )
						{
							bSSTFEditor用ユーザを作成する = true;
						}
						else
						{
							bSSTFEditor用ユーザを作成する = true;
							foreach( var name in Global.User.UserList.Users )
							{
								if( name.Equals( Properties.Resources.DEFAULT_VIEWER_USER_NAME, StringComparison.OrdinalIgnoreCase ) )
								{
									bSSTFEditor用ユーザを作成する = false;		// ユーザがあった（ので作らない）
									break;
								}
							}
						}
						//-----------------
						#endregion

						if( bSSTFEditor用ユーザを作成する )
						{
							#region [ 必要だったので作成する。]
							//-----------------
							// ユーザを新規追加し UsersList.xml ファイルを保存する。
							Global.User.UserList.Users.Add( Properties.Resources.DEFAULT_VIEWER_USER_NAME );
							CXMLFile<CUserList>.t保存する( Global.User.UserList, Path.Combine( Folder.stgユーザ共通フォルダ, Properties.Resources.XMLNAME_USERLIST ) );

							// SSTFEditorユーザ用のConfig.xmlファイルを作成する。
							var config = new CConfig();
							config.tすべてのAutoPlayを設定する( true );		// 全オート
							config.HitSound = true;							// 仮想ドラム音あり
							CXMLFile<CConfig>.t保存する( config, Path.Combine( Folder.stgユーザ共通フォルダ, Properties.Resources.DEFAULT_VIEWER_USER_NAME, Properties.Resources.XMLNAME_CONFIG ) );
							//-----------------
							#endregion
						}
						//-----------------
						#endregion

						#region [ ダイアログを表示し、ログインユーザ選択・作成・削除を行う。]
						//-----------------
						var dlgユーザ選択ウィンドウ = new Cユーザ選択ウィンドウ( Global.App.Window );

						Global.tダイアログ表示の前処理();
						var dr = dlgユーザ選択ウィンドウ.ShowDialog( Global.App.Window );
						Global.tダイアログ表示の後処理();
						//-----------------
						#endregion

						if( !string.IsNullOrEmpty( dlgユーザ選択ウィンドウ.stg確定されたユーザ名 ) )
						{
							// (A) ユーザが選択された
							this.stg選択されたユーザ名 = dlgユーザ選択ウィンドウ.stg確定されたユーザ名;
							Trace.TraceInformation( "ユーザ「" + this.stg選択されたユーザ名 + "」が選択されました。" );
						}
						else
						{
							// (B) キャンセルされた
							Trace.TraceInformation( "ログインユーザの選択がキャンセルされました。" );
						}

						// A,B のいずれにしろフェーズは完了へ。
						
						this.eフェーズID.Set( EフェーズID.完了 );
					}
					break;
					//-----------------
					#endregion

				case EフェーズID.完了:
					break;	// 何もしない（On進行 が 完了 を返すのを待つ。）
			}
		}

		private bool b背景描画済み = false;
	}
}
