﻿using System;
using System.Diagnostics;
using System.Text;
using System.IO;
using System.Windows.Forms;
using FDK;

namespace StrokeStyleT
{
	class CUser : IDisposable
	{
		/// <summary>登録されているユーザの一覧。UserList.xml の内容。</summary>
		public CUserList UserList
		{
			get;
			protected set;
		}

		/// <summary>現在のログインユーザ名。ログインすると名前が格納され、ログアウトすると null に戻る。</summary>
		public Cスレッドセーフ<string> stgログインユーザ名;

		/// <summary>ログイン中のユーザのコンフィグ。ログインしていない場合は null 。</summary>
		public CConfig Config
		{
			get;
			protected set;
		}

		
		public void tログインする( string stgユーザ名 )
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( !string.IsNullOrEmpty( this.stgログインユーザ名.Get() ) )
				throw new Exception( string.Format( "まだユーザ「{0}」がログアウトしていないのにログインしようとした。", this.stgログインユーザ名.Get() ) );
			//-----------------
			#endregion

			#region [ ユーザ個別フォルダを変更。なければ作成。]
			//-----------------
			Folder.stgユーザ個別フォルダ = Path.Combine( Folder.stgユーザ共通フォルダ, stgユーザ名 );

			if( !Directory.Exists( Folder.stgユーザ個別フォルダ ) )			// 存在してないなら
				Directory.CreateDirectory( Folder.stgユーザ個別フォルダ );	// 作成。
			//-----------------
			#endregion

			// Config.xml を読み込む。存在しなかったら初期値。
			this.Config = CConfig.t読み込む( Path.Combine( Folder.stgユーザ個別フォルダ, Properties.Resources.XMLNAME_CONFIG ) );

			Global.Stage.演奏.t演奏レーンチップ対応表をConfigに合わせて再構築する();
			
			#region [ ユーザの曲リストに合わせて Global.Song.list曲リストを更新する。 ]
			//-----------------
			Global.tSongListをすべて読み込んでマージする( Global.User.Config.SongListFiles );
			Global.Stage.選曲.t選択曲を最初の曲にリセットする();
			//-----------------
			#endregion

			#region [ 仮想ドラムサウンドを構築する。]
			//-----------------
			if( Global.User.Config.KitListFiles.Count > 0 )
			{
				// (A) KitListFiles 要素があった場合 → 先頭にあるキットを選択。今のところ複数キット対応は未実装。
				string fileName = Global.User.Config.KitListFiles[ 0 ];
				Global.VirtualDrums.KitList = CKitList.t読み込む( fileName );
			}
			else
			{
				// (B) KitListFiles 要素がなかった場合 → 規定のドラムを使用。
				Global.VirtualDrums.KitList = new CKitList();
			}

			Global.VirtualDrums.tチップに対応するサウンド対応表を構築しサウンドインスタンスを生成する();
			//-----------------
			#endregion

			// ログイン完了。

			this.stgログインユーザ名.Set( stgユーザ名 );
			Trace.TraceInformation( string.Format( "ユーザ「{0}」がログインしました。", this.stgログインユーザ名.Get() ) );
		}
		public void tログアウトする()
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( string.IsNullOrEmpty( this.stgログインユーザ名.Get() ) )
				throw new Exception( "誰もログインしていないのにログアウトしようとした。" );
			//-----------------
			#endregion

			#region [ Config.xml を保存。]
			//-----------------
			this.Config.t保存する( Path.Combine( Folder.stgユーザ個別フォルダ, Properties.Resources.XMLNAME_CONFIG ) );
			this.Config = null;
			//-----------------
			#endregion

			#region [ ユーザ個別フォルダを無効化。]
			//-----------------
			Folder.stgユーザ個別フォルダ = null;
			//-----------------
			#endregion

	
			// ログアウト完了。
			
			this.stgログインユーザ名.Set( null );
			Trace.TraceInformation( "ログアウトが完了しました。" );
		}
		
		public bool b登録済みユーザである( string stgユーザ名 )
		{
			return this.UserList.Users.Contains( stgユーザ名 );
		}
		public void tユーザを新規登録する( string stgユーザ名 )
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b登録済みユーザである( stgユーザ名 ) )
				throw new Exception( string.Format( "既に登録されているユーザと同じ名前のユーザ「{0}」を新規登録しようとした。事前に存在確認をすること。", stgユーザ名 ) );
			//-----------------
			#endregion

			
			string stgユーザ個別フォルダ = Path.Combine( Folder.stgユーザ共通フォルダ, stgユーザ名 );


			// ユーザ個別フォルダを作成。

			Directory.CreateDirectory( stgユーザ個別フォルダ );
			Trace.TraceInformation( "ユーザ個別フォルダを作成しました。[{0}]", stgユーザ個別フォルダ );


			// Config.xml をユーザ個別フォルダ内に新規作成。

			var config = new CConfig();
			CXMLFile<CConfig>.t保存する( config, Path.Combine( stgユーザ個別フォルダ, Properties.Resources.XMLNAME_CONFIG ) );
			Trace.TraceInformation( "ユーザ個別フォルダ内に Config.xml を新規作成しました。" );


			// UserList.xml に登録し、保存。

			this.UserList.Users.Add( stgユーザ名 );
			CXMLFile<CUserList>.t保存する( this.UserList, Path.Combine( Folder.stgユーザ共通フォルダ, Properties.Resources.XMLNAME_USERLIST ) );
			Trace.TraceInformation( "UserList.xml にユーザを追加しました。" );
		}
		public void tユーザを削除する( string stgユーザ名 )
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( !this.b登録済みユーザである( stgユーザ名 ) )
				throw new Exception( string.Format( "未登録のユーザ「{0}」を削除しようとした。事前に存在確認をすること。", stgユーザ名 ) );
			//-----------------
			#endregion


			string stgユーザ個別フォルダ = Path.Combine( Folder.stgユーザ共通フォルダ, stgユーザ名 );


			// ユーザ個別フォルダを中身ごと削除。

			Directory.Delete( stgユーザ個別フォルダ, true );
			Trace.TraceInformation( "ユーザ個別フォルダを削除しました。[{0}]", stgユーザ個別フォルダ );


			// UserList.xml から削除し、保存。

			this.UserList.Users.Remove( stgユーザ名 );
			CXMLFile<CUserList>.t保存する( this.UserList, Path.Combine( Folder.stgユーザ共通フォルダ, Properties.Resources.XMLNAME_USERLIST ) );
			Trace.TraceInformation( "UserList.xml からユーザを削除しました。" );
		}

		public CUser()
		{
			this.UserList = CXMLFile<CUserList>.t読み込む( Path.Combine( Folder.stgユーザ共通フォルダ, Properties.Resources.XMLNAME_USERLIST ) );
			this.stgログインユーザ名 = new Cスレッドセーフ<string>( null );
			this.Config = null;
		}
		public void Dispose()
		{
			// ログアウトしてなかったらログアウトする。

			if( !string.IsNullOrEmpty( this.stgログインユーザ名.Get() ) )
				this.tログアウトする();
		}
	}
}
