﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using System.Xml.Serialization;
using FDK;

namespace StrokeStyleT
{
	/// <summary>
	/// <para>キーアサインを記録し、XML形式ファイルで保存する。</para>
	/// <para>１つの Pad には複数の Key が割り当て可能（１対Ｎ）。</para>
	/// <para>また、Eチップ と Pad のマッピング（１対１）も提供する（XML化対象外）。</para>
	/// </summary>
	[Serializable]
	public class CKeyAssign : ISerializableXML		// XML化対象クラスは public であり、StrokeStyleT.ISerializableXML を実装すること。
	{
		#region [ Key クラス定義 ]
		//-----------------
		public class Key : ICloneable
		{
			public string DeviceGUID;
			public int DeviceID;
			public int Note;

			#region [ ICloneable 実装 ]
			//-----------------
			public object Clone()
			{
				return (object) new Key() {
					DeviceGUID = this.DeviceGUID,
					DeviceID = this.DeviceID,
					Note = this.Note,
				};
			}
			//-----------------
			#endregion
		}
		//-----------------
		#endregion
		#region [ Pad クラス定義 ]
		//-----------------
		public class Pad : ICloneable
		{
			public E入力アサインパッド PadType;
			public List<Key> Keys;

			#region [ ICloneable 実装 ]
			//-----------------
			public object Clone()
			{
				var clone = new Pad();

				clone.PadType = this.PadType;
				clone.Keys = new List<Key>();
				foreach( var key in this.Keys )
					clone.Keys.Add( (Key) key.Clone() );

				return (object) clone;
			}
			//-----------------
			#endregion
		}
		//-----------------
		#endregion

		// XML化対象。

		public List<Pad> Pads = new List<Pad>();
		public int FootPedalMin = -1;
		public int FootPedalMax = -1;

		// XML化対象外。

		[XmlIgnore]
		internal Dictionary<Eチップ, Pad> dicチップtoPad = new Dictionary<Eチップ, Pad>();


		// XML化対象クラスはパラメータなしの public コンストラクタを持つこと。
		public CKeyAssign()
		{
		}

		#region [ ICloneable 実装 ]
		//-----------------
		public object Clone()
		{
			var ks = new CKeyAssign();

			ks.FootPedalMin = this.FootPedalMin;
			ks.FootPedalMax = this.FootPedalMax;

			#region [ CKeyAssign.Pads のコピー ]
			//-----------------
			ks.Pads = new List<Pad>();
			foreach( var item in this.Pads )
				ks.Pads.Add( (Pad) item.Clone() );
			//-----------------
			#endregion
			#region [ CKeyAssign.dicチップtoPad のコピー ]
			//-----------------
			this.tdicチップtoPadの初期化( ks );
			//-----------------
			#endregion

			return (object) ks;
		}
		//-----------------
		#endregion

		public void tdicチップtoPadの初期化( CKeyAssign target )
		{
			if( target.Pads.Count == 0 )
				return;

			//if( target.Pads.Count != Enum.GetValues( typeof( E入力アサインパッド ) ).Length )
			//{
			//	Trace.TraceError( "Keythis.xml の Pads 要素の数が不足しています。初期値でリセットします。" );
			//	this.t保存対象の初期化();
			//	return;
			//}

			target.dicチップtoPad = new Dictionary<Eチップ, Pad>() {
				{ Eチップ.LeftCrash, target.Pads[(int) E入力アサインパッド.LeftCymbal ] },
				{ Eチップ.HiHat_Foot, target.Pads[(int) E入力アサインパッド.FootPedal ] },
				{ Eチップ.HiHat_Close, target.Pads[(int) E入力アサインパッド.HiHat ] },		// Close, HalfOpen, Open はすべて同一キーバインド
				{ Eチップ.HiHat_HalfOpen, target.Pads[(int) E入力アサインパッド.HiHat ] },	//
				{ Eチップ.HiHat_Open, target.Pads[(int) E入力アサインパッド.HiHat ] },		//
				{ Eチップ.Snare, target.Pads[(int) E入力アサインパッド.Snare ] },
				{ Eチップ.Snare_Ghost, target.Pads[(int) E入力アサインパッド.Snare ] },
				{ Eチップ.Snare_OpenRim, target.Pads[(int) E入力アサインパッド.SnareOpenRim ] },
				{ Eチップ.Snare_ClosedRim, target.Pads[(int) E入力アサインパッド.SnareClosedRim ] },
				{ Eチップ.Tom1, target.Pads[(int) E入力アサインパッド.Tom1 ] },
				{ Eチップ.Tom1_Rim, target.Pads[(int) E入力アサインパッド.Tom1Rim ] },
				{ Eチップ.Bass, target.Pads[(int) E入力アサインパッド.Bass ] },
				{ Eチップ.Tom2, target.Pads[(int) E入力アサインパッド.Tom2 ] },
				{ Eチップ.Tom2_Rim, target.Pads[(int) E入力アサインパッド.Tom2Rim ] },
				{ Eチップ.Tom3, target.Pads[(int) E入力アサインパッド.Tom3 ] },
				{ Eチップ.Tom3_Rim, target.Pads[(int) E入力アサインパッド.Tom3Rim ] },
				{ Eチップ.RightCrash, target.Pads[(int) E入力アサインパッド.RightCymbal ] },
				{ Eチップ.Ride, target.Pads[(int) E入力アサインパッド.RideCymbal ] },
				{ Eチップ.Ride_Cup, target.Pads[(int) E入力アサインパッド.RideCup ] },
				{ Eチップ.China, target.Pads[(int) E入力アサインパッド.ChinaCymbal ] },
				{ Eチップ.Splash, target.Pads[(int) E入力アサインパッド.Splash ] },
			};
		}

		
		// ISerializableXML の実装
		public void t規定の初期化()
		{
			this.FootPedalMin = -1;
			this.FootPedalMax = -1;

			this.Pads.Clear();

			// ここで行っているのは最小限の設定。

			#region [ LeftCymbal ]
			//-----------------
			this.Pads.Add( new Pad() {
				PadType = E入力アサインパッド.LeftCymbal,
				Keys = new List<Key>() {
					new Key() { DeviceID = 0, Note = 49 },
					new Key() { DeviceID = 0, Note = 57 },
					new Key() { DeviceID = 1, Note = 49 },
					new Key() { DeviceID = 1, Note = 57 },
				}
			} );
			//-----------------
			#endregion
			#region [ FootPedal ]
			//-----------------
			this.Pads.Add( new Pad() {
				PadType = E入力アサインパッド.FootPedal,
				Keys = new List<Key>() {
					new Key() { DeviceID = 0, Note = 44 },
					new Key() { DeviceID = 1, Note = 44 },
				}
			} );
			//-----------------
			#endregion
			#region [ HiHat ]
			//-----------------
			this.Pads.Add( new Pad() {
				PadType = E入力アサインパッド.HiHat,
				Keys = new List<Key>() {
					new Key() { DeviceID = 0, Note = 42 },
					new Key() { DeviceID = 0, Note = 46 },
					new Key() { DeviceID = 1, Note = 44 },
					new Key() { DeviceID = 1, Note = 46 },
				}
			} );
			//-----------------
			#endregion
			#region [ Snare ]
			//-----------------
			this.Pads.Add( new Pad() {
				PadType = E入力アサインパッド.Snare,
				Keys = new List<Key>() {
					new Key() { DeviceID = 0, Note = 38 },
					new Key() { DeviceID = 0, Note = 40 },
					new Key() { DeviceID = 1, Note = 38 },
					new Key() { DeviceID = 1, Note = 40 },
				}
			} );
			//-----------------
			#endregion
			#region [ SnareOpenRim ]
			//-----------------
			this.Pads.Add( new Pad() {
				PadType = E入力アサインパッド.SnareOpenRim,
				Keys = new List<Key>(),
			} );
			//-----------------
			#endregion
			#region [ SnareClosedRim ]
			//-----------------
			this.Pads.Add( new Pad() {
				PadType = E入力アサインパッド.SnareClosedRim,
				Keys = new List<Key>(),
			} );
			//-----------------
			#endregion
			#region [ Tom1 ]
			//-----------------
			this.Pads.Add( new Pad() {
				PadType = E入力アサインパッド.Tom1,
				Keys = new List<Key>() {
					new Key() { DeviceID = 0, Note = 48 },
					new Key() { DeviceID = 0, Note = 50 },
					new Key() { DeviceID = 1, Note = 48 },
					new Key() { DeviceID = 1, Note = 50 },
				}
			} );
			//-----------------
			#endregion
			#region [ Tom1Rim ]
			//-----------------
			this.Pads.Add( new Pad() {
				PadType = E入力アサインパッド.Tom1Rim,
				Keys = new List<Key>(),
			} );
			//-----------------
			#endregion
			#region [ Bass ]
			//-----------------
			this.Pads.Add( new Pad() {
				PadType = E入力アサインパッド.Bass,
				Keys = new List<Key>() {
					new Key() { DeviceID = 0, Note = 33 },
					new Key() { DeviceID = 0, Note = 35 },
					new Key() { DeviceID = 0, Note = 36 },
					new Key() { DeviceID = 1, Note = 33 },
					new Key() { DeviceID = 1, Note = 35 },
					new Key() { DeviceID = 1, Note = 36 },
				}
			} );
			//-----------------
			#endregion
			#region [ Tom2 ]
			//-----------------
			this.Pads.Add( new Pad() {
				PadType = E入力アサインパッド.Tom2,
				Keys = new List<Key>() {
					new Key() { DeviceID = 0, Note = 45 },
					new Key() { DeviceID = 0, Note = 47 },
					new Key() { DeviceID = 1, Note = 45 },
					new Key() { DeviceID = 1, Note = 47 },
				}
			} );
			//-----------------
			#endregion
			#region [ Tom2Rim ]
			//-----------------
			this.Pads.Add( new Pad() {
				PadType = E入力アサインパッド.Tom2Rim,
				Keys = new List<Key>(),
			} );
			//-----------------
			#endregion
			#region [ Tom3 ]
			//-----------------
			this.Pads.Add( new Pad() {
				PadType = E入力アサインパッド.Tom3,
				Keys = new List<Key>() {
					new Key() { DeviceID = 0, Note = 41 },
					new Key() { DeviceID = 0, Note = 43 },
					new Key() { DeviceID = 1, Note = 41 },
					new Key() { DeviceID = 1, Note = 43 },
				}
			} );
			//-----------------
			#endregion
			#region [ Tom3Rim ]
			//-----------------
			this.Pads.Add( new Pad() {
				PadType = E入力アサインパッド.Tom3Rim,
				Keys = new List<Key>(),
			} );
			//-----------------
			#endregion
			#region [ RightCymbal ]
			//-----------------
			this.Pads.Add( new Pad() {
				PadType = E入力アサインパッド.RightCymbal,
				Keys = new List<Key>(),
			} );
			//-----------------
			#endregion
			#region [ RideCymbal ]
			//-----------------
			this.Pads.Add( new Pad() {
				PadType = E入力アサインパッド.RideCymbal,
				Keys = new List<Key>() {
					new Key() { DeviceID = 0, Note = 51 },
					new Key() { DeviceID = 0, Note = 59 },
					new Key() { DeviceID = 1, Note = 51 },
					new Key() { DeviceID = 1, Note = 59 },
				}
			} );
			//-----------------
			#endregion
			#region [ RideCup ]
			//-----------------
			this.Pads.Add( new Pad() {
				PadType = E入力アサインパッド.RideCup,
				Keys = new List<Key>() {
					new Key() { DeviceID = 0, Note = 53 },
					new Key() { DeviceID = 1, Note = 53 },
				}
			} );
			//-----------------
			#endregion
			#region [ ChinaCymbal ]
			//-----------------
			this.Pads.Add( new Pad() {
				PadType = E入力アサインパッド.ChinaCymbal,
				Keys = new List<Key>() {
					new Key() { DeviceID = 0, Note = 52 },
					new Key() { DeviceID = 1, Note = 52 },
				}
			} );
			//-----------------
			#endregion
			#region [ Splash ]
			//-----------------
			this.Pads.Add( new Pad() {
				PadType = E入力アサインパッド.Splash,
				Keys = new List<Key>() {
					new Key() { DeviceID = 0, Note = 55 },
					new Key() { DeviceID = 1, Note = 55 },
				}
			} );
			//-----------------
			#endregion
		}
	}
}
