﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Diagnostics;
using FDK;

namespace StrokeStyleT
{
	class Song : IDisposable
	{
		// プロパティ

		/// <summary>
		/// <para>曲リスト。</para>
		/// <para>Config で指定されたすべての SongList.xml をマージしたもの。</para>
		/// </summary>
		public List<SongNode> list曲リスト = new List<SongNode>();

		public int n描画開始チップ番号 = -1;


		// プロパティ；現在演奏中シリーズ

		/// <summary>
		/// <para>現在演奏中の曲。</para>
		/// <para>選曲ステージで曲が選択された瞬間、選択された Song への参照が格納される。</para>
		/// <para>この値は、次に別の SongNode の参照が格納されるまで維持され続ける。</para>
		/// </summary>
		public SongNode r現在演奏中の曲 = null;

		/// <summary>
		/// <para>現在演奏中のスコア。</para>
		/// <para>r現在演奏中の曲の SongNode.ScoreFile から生成される。</para>
		/// <para>プレイヤーモードで起動している時は null の場合がある（起動直後など）。</para>
		/// </summary>
		public Cスコア r現在演奏中の曲のスコア = null;

		/// <summary>
		/// <para>現在演奏中の曲のスコアに対応する背景動画。</para>
		/// <para>r現在演奏中の曲のスコア の読み込み時に、自動検索・抽出・生成される。</para>
		/// </summary>
		public CMediaSession r現在演奏中のスコアの背景動画 = null;
		public string str背景動画ファイルパス
		{
			get;
			protected set;
		}

		/// <summary>
		/// <para>現在演奏中の曲のスコアに対応する背景動画から抽出された音声(BGM)。</para>
		/// <para>r現在演奏中の曲のスコア の読み込み時に、自動検索・抽出・生成される。</para>
		/// </summary>
		public CSound r現在演奏中のスコアのBGM = null;



		// メソッド

		public Song()
		{
			this.str背景動画ファイルパス = null;
		}
		public Cスコア tスコアを読み込む( string strスコアファイル名 )
		{
			var score = new Cスコア();
			try
			{
				#region [ スコアファイルを読み込む。]
				//-----------------
				score.t曲データファイルを読み込む( strスコアファイル名 );
				//-----------------
				#endregion

				#region [ 背景動画ファイル名を検出する。]
				//-----------------
				var path = Utils.t指定した拡張子を持つファイルを検索し最初に見つけたファイルの絶対パスを返す( Path.GetDirectoryName( strスコアファイル名 ), Global.User.Config.SongFileExtensions );

				if( string.IsNullOrEmpty( path ) )
					return null;	// 準正常
				//-----------------
				#endregion
				#region [ 背景動画からBGMを作成する。]
				//-----------------
				try
				{
					var ms = new MemoryStream();
					C音声ストリーム抽出.tWAVイメージ抽出( path, out ms );
					this.r現在演奏中のスコアのBGM = Global.SoundDevice.tサウンドを作成する( ms.ToArray() );
				}
				catch( Exception e )
				{
					Utils.t例外の詳細をログに出力する( e );
					this.r現在演奏中のスコアのBGM = null;
					throw;	// そのまま下の失敗例外へ。
				}
				//-----------------
				#endregion

				// 背景動画の作成は描画スレッドで行う必要がある。
				// そのため、ここではファイルパスだけ控えておき、背景動画の作成は演奏ステージの活性化にて行う。
				this.str背景動画ファイルパス = path;

				this.n描画開始チップ番号 = ( score.listチップ.Count > 0 ) ? 0 : -1;
			}
			catch( Exception e )
			{
				// 読み込みに失敗したり、背景動画の検出に失敗した場合はここへ来る。

				Utils.t例外の詳細をログに出力する( e );
				Global.tDisposeする( ref score );
			}

			return score;
		}
		public void t曲リストをクリアしConfigに記されているSongListをすべて読み込んでマージする()
		{
			this.list曲リスト = new List<SongNode>();

			// すべての SongListFiles 要素について…
			foreach( string str生ファイル名 in Global.User.Config.SongListFiles )
			{
				SongList list = SongList.t読み込む( str生ファイル名 );
				if( list == null )
					continue;


				// すべてのノードを Global.Song.list曲リスト へマージ。

				int nマージ数 = 0;
				foreach( SongNode s in list.Songs )
				{
					this.list曲リスト.Add( s );
					nマージ数++;
				}
			}
		}

		public void Dispose()
		{
			this.list曲リスト = null;

			// 以下、念のため。
			Global.tDisposeする( ref this.r現在演奏中の曲のスコア );
			Global.tDisposeする( ref this.r現在演奏中のスコアのBGM );
			Global.tDisposeする( ref this.r現在演奏中のスコアの背景動画 );
		}
	}
}
