#include "stdafx.h"
#include "refCInputǗ.h"
#include "refCInputKeyboard.h"
#include "refCInputMouse.h"
#include "refCInputMIDI.h"

namespace FDK
{
// public:

	CInputǗ::CInputǗ( IntPtr hWnd )
	{
		HRESULT hr = S_OK;


		// MIDI͗pR[obN̍쐬iSMIDI̓foCXŋʁj

		this->dgMidiInProc = gcnew MidiInProcDelegate( this, &CInputǗ::midiInProc );
		this->gchMidiInProc = GCHandle::Alloc( this->dgMidiInProc );
		DWORD_PTR pdwMidiInProc = reinterpret_cast<DWORD_PTR>( Marshal::GetFunctionPointerForDelegate( this->dgMidiInProc ).ToPointer() );


		// eȍ

		this->pDI = NULL;
		this->hWnd = hWnd;
		this->timer = gcnew CTimer( CTimer::E::MultiMedia );
		this->list̓foCX = gcnew List<IInputDevice^>( 10 );
		this->pcsCallback = new CritSec();


		// DirectInput ̐

		IDirectInput8 *pdi;
		tFAILEDȂO( L"DirectInput ̐",
			hr = ::DirectInput8Create( ( HINSTANCE )::GetModuleHandle( NULL ), DIRECTINPUT_VERSION, IID_IDirectInput8, (void**) &pdi, NULL ) );
		this->pDI = pdi;


		// (1) L[{[h

		this->list̓foCX->Add( gcnew CInputKeyboard( hWnd, this->pDI ) );


		// (2) }EX

		this->list̓foCX->Add( gcnew CInputMouse( hWnd, this->pDI ) );


		// (3) MIDI

		this->nMidiIn = ::midiInGetNumDevs();
		for( UInt32 i = 0; i < this->nMidiIn; i++ )
		{
			MMRESULT mhr = 0;

			CInputMIDI^ item = gcnew CInputMIDI( i );
			this->list̓foCX->Add( item );

			MIDIINCAPS caps;
			mhr = ::midiInGetDevCaps( i, &caps, sizeof(MIDIINCAPS) );
			if( mhr != 0 )
				continue;	// G[

			item->strfoCX = gcnew String( caps.szPname );

			HMIDIIN hMidiIn = (HMIDIIN) item->hMidiIn;
			mhr = ::midiInOpen( &hMidiIn, i, pdwMidiInProc, NULL, CALLBACK_FUNCTION );
			if( mhr == 0 && hMidiIn != 0 )
			{
				::midiInStart( hMidiIn );	// ͎tJn
				item->hMidiIn = (UInt32) hMidiIn;
			}
		}

		// (4) WCXeBbNGΉ

	}
	CInputǗ::~CInputǗ()
	{
		if( this->_list̓foCX != nullptr )
		{
			// SMIDI̓foCX~B

			for each( IInputDevice^ device in this->_list̓foCX )
			{
				// ~
				if( device->e̓foCX == E̓foCX::MIDI )
				{
					CInputMIDI^ midi = (CInputMIDI^) device;
					::midiInStop(  (HMIDIIN) midi->hMidiIn );
					::midiInReset( (HMIDIIN) midi->hMidiIn );
					::midiInClose( (HMIDIIN) midi->hMidiIn );
				}

				// 
				delete device;
			}

			this->_list̓foCX->Clear();
			SAFE_REF_DELETE( this->_list̓foCX );
		}

		if( this->gchMidiInProc.IsAllocated )
			this->gchMidiInProc.Free();

		SAFE_REF_DELETE( this->timer );
		SAFE_REF_DELETE( this->dgMidiInProc );
		//SAFE_REF_DELETE( this->_Keyboard );	// _list̓foCXɊ܂܂Ă̂ŉς݁B
		//SAFE_REF_DELETE( this->_Mouse );		//                   V
		this->hWnd = IntPtr::Zero;

		this->!CInputǗ();
	}
	CInputǗ::!CInputǗ()
	{
		SAFE_COM_RELEASE( this->pDI );
	}

	IInputDevice^ CInputǗ::MidiIn( int ID )
	{
		for each( IInputDevice^ device in this->list̓foCX )
		{
			if( ( device->e̓foCX == E̓foCX::MIDI ) && ( device->ID == ID ) )
				return device;
		}
		return nullptr;
	}

// protected:

	void CInputǗ::midiInProc( HMIDIIN hMidiIn, UINT wMsg, DWORD_PTR dwInstance, DWORD_PTR dwParam1, DWORD_PTR dwParam2 )
	{
		AutoLock lock( *CInputǗ::pcsCallback );

		int nStatus = dwParam1 & 0xF0;
		Int64 time = this->timer->nVXems;	// lockOɎ擾

		if( ( this->list̓foCX != nullptr ) && ( this->list̓foCX->Count != 0 ) )
		{
			for each( IInputDevice^ device in this->list̓foCX )
			{
				if( device->e̓foCX != E̓foCX::MIDI )
					continue;

				CInputMIDI^ tmidi = (CInputMIDI^) device;
				if( ((HMIDIIN)tmidi->hMidiIn) == hMidiIn )
				{
					tmidi->tbZ[WMIDIM̂ݎM( wMsg, dwInstance, dwParam1, dwParam2, time );
					break;
				}
			}
		}
	}

}
